/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.validator.executor;

import com.jfireframework.baseutil.anno.AnnotationUtil;
import com.jfireframework.baseutil.exception.JustThrowException;
import com.jfireframework.baseutil.reflect.ReflectUtil;
import com.jfireframework.validator.executor.BeanValidateExecutor;
import com.jfireframework.validator.executor.MethodValidatorExecutor;
import com.jfireframework.validator.executor.impl.BeanValidateExecutorImpl;
import com.jfireframework.validator.executor.impl.MethodValidatorExecutorImpl;
import com.jfireframework.validator.executor.impl.NopBeanValidatorExecutor;
import com.jfireframework.validator.metadata.AnnoRelConstraintMetaDataStore;
import com.jfireframework.validator.paramnamefetcher.ParamNameFetcher;
import com.jfireframework.validator.propertyfetcher.PropertyValueFetcherFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.validation.Constraint;
import javax.validation.Valid;

public class ExecutorFactory {
    private ParamNameFetcher paramNameFetcher;
    private PropertyValueFetcherFactory propertyValueFetcherFactory;
    private final AnnoRelConstraintMetaDataStore annoRelConstraintMetaDataStore;
    private final ConcurrentMap<Class<?>, BeanValidateExecutor> beanValidatorStore = new ConcurrentHashMap();
    private final ConcurrentMap<Method, MethodValidatorExecutor> methodValidatorStore = new ConcurrentHashMap<Method, MethodValidatorExecutor>();

    public ExecutorFactory(PropertyValueFetcherFactory propertyValueFetcherFactory, ParamNameFetcher paramNameFetcher, AnnoRelConstraintMetaDataStore annoRelConstraintMetaDataStore) {
        this.propertyValueFetcherFactory = propertyValueFetcherFactory;
        this.paramNameFetcher = paramNameFetcher;
        this.annoRelConstraintMetaDataStore = annoRelConstraintMetaDataStore;
    }

    public void setParamNameFetcher(ParamNameFetcher paramNameFetcher) {
        this.paramNameFetcher = paramNameFetcher;
    }

    public void setPropertyValueFetcherFactory(PropertyValueFetcherFactory propertyValueFetcherFactory) {
        this.propertyValueFetcherFactory = propertyValueFetcherFactory;
    }

    public BeanValidateExecutor getInstance(Class<?> ckass) {
        if (this.notNeedValidate(ckass)) {
            return new NopBeanValidatorExecutor();
        }
        BeanValidateExecutor beanValidator = (BeanValidateExecutor)this.beanValidatorStore.get(ckass);
        if (beanValidator == null) {
            beanValidator = new BeanValidateExecutorImpl(ckass, this.annoRelConstraintMetaDataStore, this.propertyValueFetcherFactory, this);
            this.beanValidatorStore.putIfAbsent(ckass, beanValidator);
            beanValidator = (BeanValidateExecutor)this.beanValidatorStore.get(ckass);
        }
        return beanValidator;
    }

    boolean notNeedValidate(Class<?> ckass) {
        if (ckass.isPrimitive() || ckass == String.class || ckass == Integer.class || ckass == Long.class || ckass == Short.class || ckass == Double.class || ckass == Float.class || ckass == Boolean.class || ckass == Character.class || ckass == Byte.class) {
            return true;
        }
        AnnotationUtil annotationUtil = new AnnotationUtil();
        if (annotationUtil.isPresent(Constraint.class, ckass)) {
            return false;
        }
        for (Field field : ReflectUtil.getAllFields(ckass)) {
            if (annotationUtil.isPresent(Constraint.class, field)) {
                return false;
            }
            if (field.isAnnotationPresent(Valid.class)) {
                return false;
            }
            for (Annotation annotation : field.getAnnotations()) {
                if (!annotation.annotationType().getSimpleName().equals("List")) continue;
                try {
                    Class<?> componentType;
                    Method valueMethod = annotation.annotationType().getMethod("value", new Class[0]);
                    if (!valueMethod.getReturnType().isArray() || !annotationUtil.isPresent(Constraint.class, componentType = valueMethod.getReturnType().getComponentType())) continue;
                    return false;
                }
                catch (NoSuchMethodException e) {
                }
                catch (Exception e) {
                    throw new JustThrowException((Throwable)e);
                }
            }
        }
        return true;
    }

    public MethodValidatorExecutor getInstace(Method method) {
        MethodValidatorExecutor validator = (MethodValidatorExecutor)this.methodValidatorStore.get(method);
        if (validator == null) {
            validator = new MethodValidatorExecutorImpl(method, this, this.annoRelConstraintMetaDataStore, this.paramNameFetcher);
            this.methodValidatorStore.putIfAbsent(method, validator);
            validator = (MethodValidatorExecutor)this.methodValidatorStore.get(method);
        }
        return validator;
    }
}

