/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.validator.executor.impl;

import com.jfireframework.baseutil.anno.AnnotationUtil;
import com.jfireframework.baseutil.exception.JustThrowException;
import com.jfireframework.baseutil.reflect.ReflectUtil;
import com.jfireframework.validator.engine.ConstraintViolationImpl;
import com.jfireframework.validator.engine.PathImpl;
import com.jfireframework.validator.executor.BeanValidateExecutor;
import com.jfireframework.validator.executor.ExecutorFactory;
import com.jfireframework.validator.metadata.AnnoRelConstraintMetaDataStore;
import com.jfireframework.validator.metadata.ConstraintMetaData;
import com.jfireframework.validator.propertyfetcher.PropertyValueFetcher;
import com.jfireframework.validator.propertyfetcher.PropertyValueFetcherFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintViolation;
import javax.validation.Valid;

public class BeanValidateExecutorImpl
implements BeanValidateExecutor {
    private PropertyValidator[] propertyValidators;
    private CascadeValidator[] cascadeValidators;
    private ConstraintMetaData[] beanLevelConstraints;
    private final Class<?> ckass;

    public BeanValidateExecutorImpl(Class<?> ckass, final AnnoRelConstraintMetaDataStore annoRelConstraintMetaDataStore, final PropertyValueFetcherFactory fetcherFactory, final ExecutorFactory validatorFactory) {
        this.ckass = ckass;
        class Helper {
            Helper() {
            }

            Field[] filterPojoFields(Class<?> ckass) {
                ArrayList<Field> fields = new ArrayList<Field>();
                for (Field field : ReflectUtil.getAllFields(ckass)) {
                    if (!this.isPojoProperty(field)) continue;
                    fields.add(field);
                }
                return fields.toArray(new Field[fields.size()]);
            }

            void generate(Class<?> ckass) {
                Field[] fields = this.filterPojoFields(ckass);
                BeanValidateExecutorImpl.access$002(BeanValidateExecutorImpl.this, this.generatePropertyValidators(fields));
                BeanValidateExecutorImpl.access$102(BeanValidateExecutorImpl.this, this.generateCascadeValidators(fields));
                BeanValidateExecutorImpl.access$202(BeanValidateExecutorImpl.this, this.generateBeanLevelConstraints(ckass));
            }

            ConstraintMetaData[] generateBeanLevelConstraints(Class<?> ckass) {
                AnnotationUtil annotationUtil = new AnnotationUtil();
                if (annotationUtil.isPresent(Constraint.class, ckass)) {
                    ArrayList<ConstraintMetaData> list = new ArrayList<ConstraintMetaData>();
                    for (Annotation annotation : ckass.getAnnotations()) {
                        for (ConstraintMetaData constraintMetaData : annoRelConstraintMetaDataStore.relevanceConstraintMetaDatas(annotation)) {
                            list.add(constraintMetaData);
                        }
                    }
                    return list.toArray(new ConstraintMetaData[list.size()]);
                }
                return new ConstraintMetaData[0];
            }

            PropertyValidator[] generatePropertyValidators(Field[] fields) {
                LinkedList<ConstraintMetaData> constraintValidatorMetaDatas = new LinkedList<ConstraintMetaData>();
                LinkedList<PropertyValidatorImpl> list = new LinkedList<PropertyValidatorImpl>();
                for (Field field : fields) {
                    constraintValidatorMetaDatas.clear();
                    for (Annotation annotation : field.getAnnotations()) {
                        for (ConstraintMetaData constraintValidatorMetaData : annoRelConstraintMetaDataStore.relevanceConstraintMetaDatas(annotation)) {
                            constraintValidatorMetaDatas.add(constraintValidatorMetaData);
                        }
                    }
                    if (constraintValidatorMetaDatas.size() <= 0) continue;
                    PropertyValidatorImpl fieldValidator = new PropertyValidatorImpl(constraintValidatorMetaDatas.toArray(new ConstraintMetaData[constraintValidatorMetaDatas.size()]), field.getName(), fetcherFactory.getInstance(field));
                    list.add(fieldValidator);
                }
                return list.toArray(new PropertyValidator[list.size()]);
            }

            CascadeValidator[] generateCascadeValidators(Field[] fields) {
                ArrayList<CascadeValidator> list = new ArrayList<CascadeValidator>();
                for (Field field : fields) {
                    if (!field.isAnnotationPresent(Valid.class)) continue;
                    list.add(this.buildCascadeValidator(field));
                }
                return list.toArray(new CascadeValidator[list.size()]);
            }

            boolean isPojoProperty(Field field) {
                String name = field.getName();
                Class<?> type = field.getType();
                name = type == Boolean.TYPE || type == Boolean.class ? "is" + name.substring(0, 1).toUpperCase() + name.substring(1) : "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
                try {
                    int length = field.getDeclaringClass().getMethod(name, new Class[0]).getParameterTypes().length;
                    return length == 0;
                }
                catch (NoSuchMethodException e) {
                    return false;
                }
                catch (SecurityException e) {
                    throw new JustThrowException((Throwable)e);
                }
            }

            CascadeValidator buildCascadeValidator(Field field) {
                Class<?> type = field.getType();
                if (type.isArray()) {
                    return new CascadeArrayValidatorImpl(fetcherFactory.getInstance(field), field.getName(), validatorFactory);
                }
                if (Collection.class.isAssignableFrom(type)) {
                    return new CascadeCollectionValidatorImpl(fetcherFactory.getInstance(field), field.getName(), validatorFactory);
                }
                if (Map.class.isAssignableFrom(type)) {
                    return new CascadeMapValidatorImpl(fetcherFactory.getInstance(field), field.getName(), validatorFactory);
                }
                return new CascadeBeanValidatorImpl(fetcherFactory.getInstance(field), field.getName(), validatorFactory);
            }
        }
        new Helper().generate(ckass);
    }

    @Override
    public <T> void validateBean(final Object bean, final PathImpl path, final Set<ConstraintViolation<T>> constraintViolations, final Class<?> group) {
        class Helper {
            Helper() {
            }

            void validateProperty() {
                for (PropertyValidator validator : BeanValidateExecutorImpl.this.propertyValidators) {
                    validator.validate(bean, validator.fetcher().value(bean), path, constraintViolations, group);
                }
            }

            void validateCascade() {
                for (CascadeValidator validator : BeanValidateExecutorImpl.this.cascadeValidators) {
                    validator.validate(validator.fetcher().value(bean), path, constraintViolations, group);
                }
            }

            void validateEntireBean() {
                for (ConstraintMetaData each : BeanValidateExecutorImpl.this.beanLevelConstraints) {
                    if (!each.hasGroup(group)) continue;
                    for (ConstraintValidator<?, ?> validator : each.constraintValidators()) {
                        if (validator.isValid(bean, null)) continue;
                        ConstraintViolationImpl constraintViolation = new ConstraintViolationImpl(each.message(), each.messageTemplate(), new PathImpl(path, BeanValidateExecutorImpl.this.ckass.getSimpleName()), bean, null);
                        constraintViolations.add(constraintViolation);
                    }
                }
            }
        }
        Helper helper = new Helper();
        helper.validateEntireBean();
        helper.validateProperty();
        helper.validateCascade();
    }

    @Override
    public <T> void validateConstrutor(Constructor<?> constructor, Object[] params, PathImpl path, Set<ConstraintViolation<T>> constraintViolations, Class<?> group) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void validateProperty(Object bean, String propertyName, PathImpl pathImpl, Set<ConstraintViolation<T>> constraintViolations, Class<?> group) {
        for (PropertyValidator propertyValidator : this.propertyValidators) {
            if (!propertyName.equals(propertyValidator.propertyName())) continue;
            propertyValidator.validate(bean, propertyValidator.fetcher().value(bean), pathImpl, constraintViolations, group);
            break;
        }
        for (CascadeValidator cascadeValidator : this.cascadeValidators) {
            if (!propertyName.equals(cascadeValidator.propertyName())) continue;
            cascadeValidator.validate(cascadeValidator.fetcher().value(bean), pathImpl, constraintViolations, group);
            break;
        }
    }

    @Override
    public <T> void validatePropertyValue(String propertyName, Object value, PathImpl pathImpl, Set<ConstraintViolation<T>> constraintViolations, Class<?> group) {
        for (PropertyValidator propertyValidator : this.propertyValidators) {
            if (!propertyName.equals(propertyValidator.propertyName())) continue;
            propertyValidator.validate(null, value, pathImpl, constraintViolations, group);
            break;
        }
        for (CascadeValidator cascadeValidator : this.cascadeValidators) {
            if (!propertyName.equals(cascadeValidator.propertyName())) continue;
            cascadeValidator.validate(value, pathImpl, constraintViolations, group);
            break;
        }
    }

    static /* synthetic */ PropertyValidator[] access$002(BeanValidateExecutorImpl x0, PropertyValidator[] x1) {
        x0.propertyValidators = x1;
        return x1;
    }

    static /* synthetic */ CascadeValidator[] access$102(BeanValidateExecutorImpl x0, CascadeValidator[] x1) {
        x0.cascadeValidators = x1;
        return x1;
    }

    static /* synthetic */ ConstraintMetaData[] access$202(BeanValidateExecutorImpl x0, ConstraintMetaData[] x1) {
        x0.beanLevelConstraints = x1;
        return x1;
    }

    class CascadeMapValidatorImpl
    extends CascadeValidatorImpl {
        public CascadeMapValidatorImpl(PropertyValueFetcher fetcher, String name, ExecutorFactory validatorFactory) {
            super(fetcher, name, validatorFactory);
        }

        @Override
        public <T> void validate(Object propertyValue, PathImpl path, Set<ConstraintViolation<T>> constraintViolations, Class<?> group) {
            Map map = (Map)propertyValue;
            for (Map.Entry entry : map.entrySet()) {
                PathImpl self = new PathImpl(path, this.name, true, null, entry.getKey());
                if (entry.getValue() == null) continue;
                this.validatorFactory.getInstance(entry.getValue().getClass()).validateBean(entry.getValue(), self, constraintViolations, group);
            }
        }
    }

    class CascadeCollectionValidatorImpl
    extends CascadeValidatorImpl {
        public CascadeCollectionValidatorImpl(PropertyValueFetcher fetcher, String name, ExecutorFactory validatorFactory) {
            super(fetcher, name, validatorFactory);
        }

        @Override
        public <T> void validate(Object propertyValue, PathImpl path, Set<ConstraintViolation<T>> constraintViolations, Class<?> group) {
            Collection collection = (Collection)propertyValue;
            int i = 0;
            for (Object value : collection) {
                if (value != null) {
                    PathImpl self = new PathImpl(path, this.name, true, i, null);
                    this.validatorFactory.getInstance(value.getClass()).validateBean(value, self, constraintViolations, group);
                }
                ++i;
            }
        }
    }

    class CascadeArrayValidatorImpl
    extends CascadeValidatorImpl {
        public CascadeArrayValidatorImpl(PropertyValueFetcher fetcher, String name, ExecutorFactory validatorFactory) {
            super(fetcher, name, validatorFactory);
        }

        @Override
        public <T> void validate(Object propertyValue, PathImpl path, Set<ConstraintViolation<T>> constraintViolations, Class<?> group) {
            Object[] array = (Object[])propertyValue;
            for (int i = 0; i < array.length; ++i) {
                Object value = array[i];
                if (value == null) continue;
                PathImpl self = new PathImpl(path, this.name, true, i, null);
                this.validatorFactory.getInstance(value.getClass()).validateBean(value, self, constraintViolations, group);
            }
        }
    }

    class CascadeBeanValidatorImpl
    extends CascadeValidatorImpl {
        public CascadeBeanValidatorImpl(PropertyValueFetcher fetcher, String name, ExecutorFactory validatorFactory) {
            super(fetcher, name, validatorFactory);
        }

        @Override
        public <T> void validate(Object propertyValue, PathImpl path, Set<ConstraintViolation<T>> constraintViolations, Class<?> group) {
            if (propertyValue == null) {
                return;
            }
            BeanValidateExecutor beanValidator = this.validatorFactory.getInstance(propertyValue.getClass());
            PathImpl self = new PathImpl(path, this.name);
            beanValidator.validateBean(propertyValue, self, constraintViolations, group);
        }
    }

    abstract class CascadeValidatorImpl
    implements CascadeValidator {
        protected final PropertyValueFetcher fetcher;
        protected final String name;
        protected final ExecutorFactory validatorFactory;

        public CascadeValidatorImpl(PropertyValueFetcher fetcher, String name, ExecutorFactory validatorFactory) {
            this.fetcher = fetcher;
            this.name = name;
            this.validatorFactory = validatorFactory;
        }

        @Override
        public PropertyValueFetcher fetcher() {
            return this.fetcher;
        }

        @Override
        public String propertyName() {
            return this.name;
        }
    }

    class PropertyValidatorImpl
    implements PropertyValidator {
        private final ConstraintMetaData[] metaDatas;
        private final String name;
        private final PropertyValueFetcher fetcher;

        public PropertyValidatorImpl(ConstraintMetaData[] metaDatas, String name, PropertyValueFetcher fetcher) {
            this.metaDatas = metaDatas;
            this.name = name;
            this.fetcher = fetcher;
        }

        @Override
        public <T> void validate(Object bean, Object propertyValue, PathImpl path, Set<ConstraintViolation<T>> constraintViolations, Class<?> group) {
            for (ConstraintMetaData each : this.metaDatas) {
                if (!each.hasGroup(group)) break;
                for (ConstraintValidator<?, ?> constraintValidator : each.constraintValidators()) {
                    boolean valid = constraintValidator.isValid(propertyValue, null);
                    if (valid) continue;
                    PathImpl self = new PathImpl(path, this.name, false, null, null);
                    ConstraintViolationImpl basicConstraintViolation = new ConstraintViolationImpl(each.message(), each.messageTemplate(), self, propertyValue, bean);
                    constraintViolations.add(basicConstraintViolation);
                }
            }
        }

        @Override
        public PropertyValueFetcher fetcher() {
            return this.fetcher;
        }

        @Override
        public String propertyName() {
            return this.name;
        }
    }

    static interface CascadeValidator {
        public PropertyValueFetcher fetcher();

        public String propertyName();

        public <T> void validate(Object var1, PathImpl var2, Set<ConstraintViolation<T>> var3, Class<?> var4);
    }

    static interface PropertyValidator {
        public PropertyValueFetcher fetcher();

        public String propertyName();

        public <T> void validate(Object var1, Object var2, PathImpl var3, Set<ConstraintViolation<T>> var4, Class<?> var5);
    }
}

