/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.validator.executor.impl;

import com.jfireframework.baseutil.anno.AnnotationUtil;
import com.jfireframework.validator.engine.ConstraintViolationImpl;
import com.jfireframework.validator.engine.PathImpl;
import com.jfireframework.validator.executor.ExecutorFactory;
import com.jfireframework.validator.executor.MethodValidatorExecutor;
import com.jfireframework.validator.metadata.AnnoRelConstraintMetaDataStore;
import com.jfireframework.validator.metadata.ConstraintMetaData;
import com.jfireframework.validator.paramnamefetcher.ParamNameFetcher;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintViolation;
import javax.validation.Valid;

public class MethodValidatorExecutorImpl
implements MethodValidatorExecutor {
    private final Method method;
    private final ExecutorFactory beanValidatorFactory;
    private final ValidateInfo[] valadateInfos;
    private final ConstraintMetaData[] entireParamsValidate;

    public MethodValidatorExecutorImpl(final Method method, ExecutorFactory beanValidatorFactory, final AnnoRelConstraintMetaDataStore annoRelConstraintMetaDataStore, final ParamNameFetcher paramNameFetcher) {
        this.beanValidatorFactory = beanValidatorFactory;
        this.method = method;
        final AnnotationUtil annotationUtil = new AnnotationUtil();
        final Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        class Helper {
            Helper() {
            }

            ValidateInfo[] generateValidateInfos() {
                String[] names = paramNameFetcher.names(method);
                LinkedList<ValidateInfo> validateInfos = new LinkedList<ValidateInfo>();
                for (int i = 0; i < parameterAnnotations.length; ++i) {
                    Annotation[] annotations = parameterAnnotations[i];
                    ValidateInfo info = null;
                    if (annotationUtil.isPresent(Constraint.class, annotations)) {
                        info = new ValidateInfo();
                        info.index = i;
                        info.validateType = ValidateType.validateByConstraint;
                        info.path = method.getDeclaringClass().getName() + "." + method.getName() + "_" + names[i];
                        ArrayList<ConstraintMetaData> list = new ArrayList<ConstraintMetaData>();
                        for (Annotation annotation : annotations) {
                            ConstraintMetaData[] constraintMetaDatas;
                            for (ConstraintMetaData metaData : constraintMetaDatas = annoRelConstraintMetaDataStore.relevanceConstraintMetaDatas(annotation)) {
                                list.add(metaData);
                            }
                        }
                        info.metaDatas = list.toArray(new ConstraintMetaData[list.size()]);
                    }
                    if (annotationUtil.isPresent(Valid.class, annotations)) {
                        ValidateInfo validateInfo = info = info == null ? new ValidateInfo() : info;
                        if (info.validateType == null) {
                            info.validateType = ValidateType.validateAsBean;
                            info.path = method.getDeclaringClass().getName() + "." + method.getName() + "_" + names[i];
                        } else {
                            info.validateType = ValidateType.all;
                        }
                    }
                    if (info == null) continue;
                    validateInfos.add(info);
                }
                return validateInfos.toArray(new ValidateInfo[validateInfos.size()]);
            }

            ConstraintMetaData[] generateCrossParamConstraintMetaDatas() {
                LinkedList<ConstraintMetaData> tmp = new LinkedList<ConstraintMetaData>();
                if (annotationUtil.isPresent(Constraint.class, method)) {
                    for (Annotation annotation : method.getAnnotations()) {
                        for (ConstraintMetaData constraintMetaData : annoRelConstraintMetaDataStore.relevanceConstraintMetaDatas(annotation)) {
                            tmp.add(constraintMetaData);
                        }
                    }
                }
                return tmp.toArray(new ConstraintMetaData[tmp.size()]);
            }
        }
        Helper helper = new Helper();
        this.valadateInfos = helper.generateValidateInfos();
        this.entireParamsValidate = helper.generateCrossParamConstraintMetaDatas();
    }

    @Override
    public void validate(final Object[] params, final Set<ConstraintViolation<Method>> result, final Class<?> group) {
        class Helper {
            Helper() {
            }

            private void validateAsBean(ValidateInfo info) {
                Object value = params[info.index];
                if (value != null) {
                    MethodValidatorExecutorImpl.this.beanValidatorFactory.getInstance(value.getClass()).validateBean(value, new PathImpl(info.path), result, group);
                }
            }

            private void validateByConstraint(ValidateInfo info) {
                Object value = params[info.index];
                for (ConstraintMetaData metaData : info.metaDatas) {
                    for (ConstraintValidator<?, ?> constraintValidator : metaData.constraintValidators()) {
                        if (constraintValidator.isValid(value, null)) continue;
                        ConstraintViolationImpl constraintViolation = new ConstraintViolationImpl(metaData.message(), metaData.messageTemplate(), new PathImpl(info.path), value, MethodValidatorExecutorImpl.this.method);
                        result.add(constraintViolation);
                    }
                }
            }

            void validateSingleParam() {
                block5: for (ValidateInfo each : MethodValidatorExecutorImpl.this.valadateInfos) {
                    switch (each.validateType) {
                        case validateAsBean: {
                            this.validateAsBean(each);
                            continue block5;
                        }
                        case validateByConstraint: {
                            this.validateByConstraint(each);
                            continue block5;
                        }
                        case all: {
                            this.validateAsBean(each);
                            this.validateByConstraint(each);
                            continue block5;
                        }
                        default: {
                            throw new NullPointerException();
                        }
                    }
                }
            }

            void validateEntireParams() {
                for (ConstraintMetaData constraintMetaData : MethodValidatorExecutorImpl.this.entireParamsValidate) {
                    for (ConstraintValidator<?, ?> constraintValidator : constraintMetaData.constraintValidators()) {
                        if (constraintValidator.isValid((Object)params, null)) continue;
                        ConstraintViolationImpl constraintViolation = new ConstraintViolationImpl(constraintMetaData.message(), constraintMetaData.messageTemplate(), new PathImpl(MethodValidatorExecutorImpl.this.method.getDeclaringClass().getName() + "." + MethodValidatorExecutorImpl.this.method.getName()), params, MethodValidatorExecutorImpl.this.method);
                        result.add(constraintViolation);
                    }
                }
            }
        }
        Helper helper = new Helper();
        helper.validateEntireParams();
        if (!result.isEmpty()) {
            return;
        }
        helper.validateSingleParam();
    }

    class ValidateInfo {
        ValidateType validateType;
        int index;
        String path;
        ConstraintMetaData[] metaDatas;

        ValidateInfo() {
        }
    }

    static enum ValidateType {
        validateByConstraint,
        validateAsBean,
        all;

    }
}

