/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.validator.messageinterpolator;

import com.jfireframework.baseutil.StringUtil;
import com.jfireframework.baseutil.collection.StringCache;
import com.jfireframework.baseutil.exception.JustThrowException;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.validation.MessageInterpolator;

public class ResourceBundleMessageInterpolator
implements MessageInterpolator {
    private final ResourceBundle buildIn = ResourceBundle.getBundle("BuildInValidationMessages");
    private final ResourceBundle user;

    public ResourceBundleMessageInterpolator() {
        ResourceBundle user;
        try {
            user = ResourceBundle.getBundle("ValidationMessages");
        }
        catch (Exception e) {
            user = null;
        }
        this.user = user;
    }

    public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
        return this.interpolate(messageTemplate, context, this.buildIn, this.user);
    }

    private String interpolate(String messageTemplate, MessageInterpolator.Context context, ResourceBundle buildIn, ResourceBundle user) {
        if (messageTemplate.charAt(0) == '{' && messageTemplate.endsWith("}")) {
            if (buildIn.containsKey(messageTemplate = messageTemplate.substring(1, messageTemplate.length() - 1))) {
                messageTemplate = buildIn.getString(messageTemplate);
            } else if (user != null && user.containsKey(messageTemplate)) {
                messageTemplate = user.getString(messageTemplate);
            }
        }
        messageTemplate = this.resolve(messageTemplate, context.getConstraintDescriptor().getAttributes());
        return StringUtil.format((String)messageTemplate, (Object[])new Object[]{context.getConstraintDescriptor().getAttributes()});
    }

    public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
        ResourceBundle buildIn = ResourceBundle.getBundle("BuildIn.ValidationMessages.properties");
        ResourceBundle user = ResourceBundle.getBundle("ValidationMessages.properties");
        return this.interpolate(messageTemplate, context, buildIn, user);
    }

    String resolve(String message, Map<String, Object> attributes) {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("js");
        for (Map.Entry<String, Object> each : attributes.entrySet()) {
            scriptEngine.put(each.getKey(), each.getValue());
        }
        StringCache cache = new StringCache();
        int end = 0;
        int index = 0;
        do {
            String script;
            char c;
            if ((c = message.charAt(index)) == '$') {
                if (index + 1 >= message.length() || message.charAt(index + 1) != '{') continue;
                end = message.indexOf(125, index);
                if (end == -1) {
                    throw new UnsupportedOperationException(StringUtil.format((String)"\u6d88\u606f:{}\u5b58\u5728\u95ee\u9898\uff0c${\u6ca1\u6709\u88ab\u5305\u56f4", (Object[])new Object[]{message}));
                }
                script = message.substring(index + 2, end);
                try {
                    cache.append(scriptEngine.eval(script));
                }
                catch (Exception e) {
                    throw new JustThrowException((Throwable)e);
                }
                index = end + 1;
                continue;
            }
            if (c == '{') {
                end = message.indexOf(125, index);
                if (end == -1) {
                    throw new UnsupportedOperationException(StringUtil.format((String)"\u6d88\u606f:{}\u5b58\u5728\u95ee\u9898\uff0c${\u6ca1\u6709\u88ab\u5305\u56f4", (Object[])new Object[]{message}));
                }
                script = message.substring(index + 1, end);
                try {
                    cache.append(scriptEngine.eval(script));
                }
                catch (Exception e) {
                    throw new JustThrowException((Throwable)e);
                }
                index = end + 1;
                continue;
            }
            cache.append(c);
            ++index;
        } while (index < message.length());
        return cache.toString();
    }
}

