/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.validator.metadata;

import com.jfireframework.baseutil.anno.AnnotationUtil;
import com.jfireframework.baseutil.exception.JustThrowException;
import com.jfireframework.validator.constraint.validator.AssertFalseValidator;
import com.jfireframework.validator.constraint.validator.AssertTrueValidator;
import com.jfireframework.validator.constraint.validator.DecimalMaxValidator;
import com.jfireframework.validator.constraint.validator.DecimalMinValidator;
import com.jfireframework.validator.constraint.validator.DigitsValidator;
import com.jfireframework.validator.constraint.validator.FutureValidator;
import com.jfireframework.validator.constraint.validator.MaxValidator;
import com.jfireframework.validator.constraint.validator.MinValidator;
import com.jfireframework.validator.constraint.validator.NotNullValidator;
import com.jfireframework.validator.constraint.validator.NullValidator;
import com.jfireframework.validator.constraint.validator.PastValidator;
import com.jfireframework.validator.constraint.validator.PatternValidator;
import com.jfireframework.validator.constraint.validator.SizeValidator;
import com.jfireframework.validator.metadata.ConstraintMetaData;
import com.jfireframework.validator.metadata.impl.ConstraintMetaDataImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

public class AnnoRelConstraintMetaDataStore {
    private ValidateBy validateBy = new ValidateBy();
    private final ConcurrentMap<Annotation, ConstraintMetaData[]> store = new ConcurrentHashMap<Annotation, ConstraintMetaData[]>();
    private final MessageInterpolator interpolator;
    private ConstraintValidatorFactory constraintValidatorFactory;

    public AnnoRelConstraintMetaDataStore(MessageInterpolator interpolator, ConstraintValidatorFactory constraintValidatorFactory) {
        this.interpolator = interpolator;
        this.constraintValidatorFactory = constraintValidatorFactory;
    }

    public void setConstraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
    }

    public ConstraintMetaData[] relevanceConstraintMetaDatas(Annotation annotation) {
        ConstraintMetaData[] constraintValidatorMetaDatas = (ConstraintMetaData[])this.store.get(annotation);
        if (constraintValidatorMetaDatas == null) {
            class Helper {
                Helper() {
                }

                ConstraintMetaData[] process(Annotation annotation) {
                    AnnotationUtil annotationUtil = new AnnotationUtil();
                    LinkedList<Object> constraintMetaDatas = new LinkedList<Object>();
                    if (annotationUtil.isPresent(Constraint.class, new Annotation[]{annotation})) {
                        Constraint[] constraints;
                        for (Constraint constraint : constraints = (Constraint[])annotationUtil.getAnnotations(Constraint.class, new Annotation[]{annotation})) {
                            LinkedList<ConstraintValidator> tmp = new LinkedList<ConstraintValidator>();
                            Annotation metaAnnotation = (Annotation)annotationUtil.getMetaAnnotation((Annotation)constraint, new Annotation[]{annotation});
                            for (Class<? extends ConstraintValidator<?, ?>> each : AnnoRelConstraintMetaDataStore.this.validateBy.validateBy(metaAnnotation, constraint)) {
                                try {
                                    ConstraintValidator instance = AnnoRelConstraintMetaDataStore.this.constraintValidatorFactory.getInstance(each);
                                    instance.initialize(metaAnnotation);
                                    tmp.add(instance);
                                }
                                catch (Exception e) {
                                    throw new JustThrowException((Throwable)e);
                                }
                            }
                            ConstraintMetaDataImpl constraintValidatorMetaData = new ConstraintMetaDataImpl(metaAnnotation, AnnoRelConstraintMetaDataStore.this.interpolator, tmp.toArray(new ConstraintValidator[tmp.size()]));
                            constraintMetaDatas.add(constraintValidatorMetaData);
                        }
                    }
                    if (annotation.annotationType().getSimpleName().equals("List")) {
                        try {
                            Class<?> componentType;
                            Method valueMethod = annotation.annotationType().getMethod("value", new Class[0]);
                            valueMethod.setAccessible(true);
                            if (valueMethod.getReturnType().isArray() && annotationUtil.isPresent(Constraint.class, componentType = valueMethod.getReturnType().getComponentType())) {
                                Annotation[] constraintAnnotations;
                                for (Annotation constraint : constraintAnnotations = (Annotation[])valueMethod.invoke((Object)annotation, new Object[0])) {
                                    for (ConstraintMetaData constraintValidatorMetaData : this.process(constraint)) {
                                        constraintMetaDatas.add(constraintValidatorMetaData);
                                    }
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return constraintMetaDatas.toArray(new ConstraintMetaData[constraintMetaDatas.size()]);
                }
            }
            constraintValidatorMetaDatas = new Helper().process(annotation);
            this.store.putIfAbsent(annotation, constraintValidatorMetaDatas);
            constraintValidatorMetaDatas = (ConstraintMetaData[])this.store.get(annotation);
        }
        return constraintValidatorMetaDatas;
    }

    class ValidateBy {
        private final IdentityHashMap<Class<? extends Annotation>, Class<? extends ConstraintValidator<?, ?>>[]> buildIn = new IdentityHashMap();

        public ValidateBy() {
            this.buildIn.put(AssertFalse.class, new Class[]{AssertFalseValidator.class});
            this.buildIn.put(AssertTrue.class, new Class[]{AssertTrueValidator.class});
            this.buildIn.put(DecimalMax.class, new Class[]{DecimalMaxValidator.class});
            this.buildIn.put(DecimalMin.class, new Class[]{DecimalMinValidator.class});
            this.buildIn.put(Digits.class, new Class[]{DigitsValidator.class});
            this.buildIn.put(Future.class, new Class[]{FutureValidator.class});
            this.buildIn.put(Max.class, new Class[]{MaxValidator.class});
            this.buildIn.put(Min.class, new Class[]{MinValidator.class});
            this.buildIn.put(NotNull.class, new Class[]{NotNullValidator.class});
            this.buildIn.put(Null.class, new Class[]{NullValidator.class});
            this.buildIn.put(Past.class, new Class[]{PastValidator.class});
            this.buildIn.put(Pattern.class, new Class[]{PatternValidator.class});
            this.buildIn.put(Size.class, new Class[]{SizeValidator.class});
        }

        Class<? extends ConstraintValidator<?, ?>>[] validateBy(Annotation annotation, Constraint constraint) {
            try {
                Class[] ckasses = constraint.validatedBy();
                if (ckasses.length != 0) {
                    return ckasses;
                }
                Class<? extends Annotation> type = annotation.annotationType();
                ckasses = this.buildIn.get(type);
                if (ckasses == null) {
                    throw new NullPointerException();
                }
                return ckasses;
            }
            catch (Exception e) {
                throw new JustThrowException((Throwable)e);
            }
        }
    }
}

