/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.validator.metadata.impl;

import com.jfireframework.baseutil.exception.JustThrowException;
import com.jfireframework.validator.metadata.ConstraintMetaData;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.MessageInterpolator;
import javax.validation.Payload;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintMetaDataImpl
implements ConstraintMetaData {
    private final String message;
    private final String messageTemplate;
    private final Class<?>[] groups;
    private final ConstraintValidator<?, ?>[] constraintValidators;
    private static final Logger logger = LoggerFactory.getLogger(ConstraintMetaDataImpl.class);

    public ConstraintMetaDataImpl(Annotation annotation, MessageInterpolator interpolator, ConstraintValidator<?, ?> ... constraintValidators) {
        this.constraintValidators = constraintValidators;
        try {
            this.messageTemplate = this.getMessageTemplate(annotation);
            this.message = this.resolveMessageTemplate(annotation, this.messageTemplate, interpolator);
            this.groups = this.getGroups(annotation);
        }
        catch (Exception e) {
            logger.error("\u51fa\u73b0\u5f02\u5e38\uff0c\u6ce8\u89e3\u7684\u4fe1\u606f\u662f:{}", (Object)annotation.toString(), (Object)e);
            throw new JustThrowException((Throwable)e);
        }
    }

    private Class<?>[] getGroups(Annotation annotation) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method groups = annotation.annotationType().getDeclaredMethod("groups", new Class[0]);
        groups.setAccessible(true);
        Class[] tmp = (Class[])groups.invoke((Object)annotation, new Object[0]);
        if (tmp.length == 0) {
            return new Class[]{Default.class};
        }
        return tmp;
    }

    private String getMessageTemplate(Annotation annotation) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method message = annotation.annotationType().getDeclaredMethod("message", new Class[0]);
        message.setAccessible(true);
        return (String)message.invoke((Object)annotation, new Object[0]);
    }

    private String resolveMessageTemplate(Annotation annotation, String messageTemplate, MessageInterpolator interpolator) {
        Method[] methods = annotation.annotationType().getMethods();
        final HashMap<String, Object> map = new HashMap<String, Object>();
        for (Method each : methods) {
            if (each.getParameterTypes().length != 0) continue;
            each.setAccessible(true);
            try {
                map.put(each.getName(), each.invoke((Object)annotation, new Object[0]));
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                throw new JustThrowException((Throwable)e);
            }
        }
        ConstraintDescriptor<Annotation> descriptor = new ConstraintDescriptor<Annotation>(){

            public Annotation getAnnotation() {
                throw new UnsupportedOperationException();
            }

            public Set<Class<?>> getGroups() {
                throw new UnsupportedOperationException();
            }

            public Set<Class<? extends Payload>> getPayload() {
                throw new UnsupportedOperationException();
            }

            public List<Class<? extends ConstraintValidator<Annotation, ?>>> getConstraintValidatorClasses() {
                throw new UnsupportedOperationException();
            }

            public Map<String, Object> getAttributes() {
                return map;
            }

            public Set<ConstraintDescriptor<?>> getComposingConstraints() {
                throw new UnsupportedOperationException();
            }

            public boolean isReportAsSingleViolation() {
                throw new UnsupportedOperationException();
            }
        };
        return interpolator.interpolate(messageTemplate, new MessageInterpolator.Context((ConstraintDescriptor)descriptor){
            final /* synthetic */ ConstraintDescriptor val$descriptor;
            {
                this.val$descriptor = constraintDescriptor;
            }

            public Object getValidatedValue() {
                throw new UnsupportedOperationException();
            }

            public ConstraintDescriptor<?> getConstraintDescriptor() {
                return this.val$descriptor;
            }
        });
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public ConstraintValidator<?, ?>[] constraintValidators() {
        return this.constraintValidators;
    }

    @Override
    public boolean hasGroup(Class<?> ckass) {
        for (Class<?> each : this.groups) {
            if (each != ckass) continue;
            return true;
        }
        return false;
    }

    @Override
    public String messageTemplate() {
        return this.messageTemplate;
    }
}

