/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.validator.propertyfetcher.impl;

import com.jfireframework.baseutil.exception.JustThrowException;
import com.jfireframework.baseutil.smc.compiler.JavaStringCompiler;
import com.jfireframework.baseutil.smc.model.CompilerModel;
import com.jfireframework.baseutil.smc.model.MethodModel;
import com.jfireframework.validator.propertyfetcher.PropertyValueFetcher;
import com.jfireframework.validator.propertyfetcher.PropertyValueFetcherFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;

public class CodePropertyValueFetcherFactory
implements PropertyValueFetcherFactory {
    private final AtomicInteger count = new AtomicInteger(0);
    private final Method getValueMethod;

    public CodePropertyValueFetcherFactory() {
        try {
            this.getValueMethod = ValueFetcher.class.getMethod("getValue", Object.class);
        }
        catch (Exception e) {
            throw new JustThrowException((Throwable)e);
        }
    }

    @Override
    public PropertyValueFetcher getInstance(Field field) {
        return new CodeFieldValueFetcher(field);
    }

    class CodeFieldValueFetcher
    implements PropertyValueFetcher {
        private final ValueFetcher valueFetcher;

        public CodeFieldValueFetcher(Field field) {
            String name = field.getName();
            Class<?> type = field.getType();
            name = type == Boolean.TYPE || type == Boolean.class ? "is" + name.substring(0, 1).toUpperCase() + name.substring(1) : "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
            CompilerModel compilerModel = new CompilerModel("CodeFieldValueFetcher_" + CodePropertyValueFetcherFactory.this.count.incrementAndGet(), Object.class, new Class[]{ValueFetcher.class});
            MethodModel methodModel = new MethodModel(CodePropertyValueFetcherFactory.this.getValueMethod);
            String body = "return ((" + field.getDeclaringClass().getName() + ")$0)." + name + "();";
            methodModel.setBody(body);
            compilerModel.putMethod(CodePropertyValueFetcherFactory.this.getValueMethod, methodModel);
            JavaStringCompiler compiler = new JavaStringCompiler();
            try {
                this.valueFetcher = (ValueFetcher)compiler.compile(compilerModel, CodePropertyValueFetcherFactory.class.getClassLoader()).newInstance();
            }
            catch (Exception e) {
                throw new JustThrowException((Throwable)e);
            }
        }

        @Override
        public Object value(Object bean) {
            return this.valueFetcher.getValue(bean);
        }
    }

    public static interface ValueFetcher {
        public Object getValue(Object var1);
    }
}

