/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.guicedpersistence.btm;

import bitronix.tm.resource.jdbc.PoolingDataSource;
import com.jwebmp.guicedpersistence.db.ConnectionBaseInfo;
import javax.sql.DataSource;

public class BTMConnectionBaseInfo
extends ConnectionBaseInfo
implements Cloneable {
    public BTMConnectionBaseInfo() {
        this.setServerInstanceNameProperty("Instance");
    }

    public BTMConnectionBaseInfo(boolean xa) {
        this.setXa(xa);
    }

    public DataSource toPooledDatasource() {
        PoolingDataSource pds = new PoolingDataSource();
        if (!this.isXa()) {
            this.setAllowLocalTransactions(true);
        }
        if (this.getTransactionIsolation() != null) {
            pds.setIsolationLevel(this.getTransactionIsolation());
        }
        if (this.getMinPoolSize() != null) {
            pds.setMinPoolSize(this.getMinPoolSize().intValue());
        }
        if (this.getMaxPoolSize() != null) {
            pds.setMaxPoolSize(this.getMaxPoolSize().intValue());
        }
        if (this.getMaxIdleTime() != null) {
            pds.setMaxIdleTime(this.getMaxIdleTime().intValue());
        }
        if (this.getPreparedStatementCacheSize() != null) {
            pds.setPreparedStatementCacheSize(this.getPreparedStatementCacheSize().intValue());
        }
        if (this.getAcquireIncrement() != null) {
            pds.setAcquireIncrement(this.getAcquireIncrement().intValue());
        }
        if (this.getAcquisitionInterval() != null) {
            pds.setAcquisitionInterval(this.getAcquisitionInterval().intValue());
        }
        if (this.getAcquisitionTimeout() != null) {
            pds.setAcquisitionTimeout(this.getAcquisitionTimeout().intValue());
        }
        if (this.getAllowLocalTransactions() != null) {
            pds.setAllowLocalTransactions(this.getAllowLocalTransactions().booleanValue());
        }
        if (this.getApplyTransactionTimeout() != null) {
            pds.setApplyTransactionTimeout(this.getApplyTransactionTimeout().booleanValue());
        }
        if (this.getAutomaticEnlistingEnabled() != null) {
            pds.setAutomaticEnlistingEnabled(this.getAutomaticEnlistingEnabled().booleanValue());
        }
        if (this.getEnableJdbc4ConnectionTest() != null) {
            pds.setEnableJdbc4ConnectionTest(this.getEnableJdbc4ConnectionTest().booleanValue());
        }
        if (this.getIgnoreRecoveryFailures() != null) {
            pds.setIgnoreRecoveryFailures(this.getIgnoreRecoveryFailures().booleanValue());
        }
        if (this.getShareTransactionConnections() != null) {
            pds.setShareTransactionConnections(this.getShareTransactionConnections().booleanValue());
        }
        if (pds.getTestQuery() != null) {
            pds.setTestQuery(this.getTestQuery());
        }
        if (this.getJndiName() == null) {
            throw new UnsupportedOperationException("JTA requires JNDI name to be specified, when inheriting from AbstractDatabaseModule make sure to provide a valid value for getJndiMapping()");
        }
        pds.setUniqueName(this.getJndiName());
        if (this.getDriverClass() == null) {
            throw new UnsupportedOperationException("Please make sure to specify a driver class to use in the persistence.xml file or manually in this configuration object.");
        }
        pds.setClassName(this.getDriverClass());
        if (this.isXa()) {
            this.processXa(this, pds);
        } else {
            this.processNonXa(this, pds);
        }
        pds.init();
        return pds;
    }

    private PoolingDataSource processXa(ConnectionBaseInfo cbi, PoolingDataSource pds) {
        if (cbi.getDatabaseName() != null) {
            pds.getDriverProperties().setProperty("DatabaseName", cbi.getDatabaseName());
        }
        if (cbi.getUsername() != null) {
            pds.getDriverProperties().setProperty("User", cbi.getUsername());
        }
        if (cbi.getPassword() != null) {
            pds.getDriverProperties().setProperty("Password", cbi.getPassword());
        }
        if (cbi.getServerName() != null) {
            pds.getDriverProperties().setProperty("ServerName", cbi.getServerName());
        }
        if (cbi.getPort() != null) {
            pds.getDriverProperties().setProperty("Port", cbi.getPort());
        }
        if (cbi.getInstanceName() != null) {
            pds.getDriverProperties().setProperty(cbi.getServerInstanceNameProperty(), cbi.getInstanceName());
        }
        return pds;
    }

    private PoolingDataSource processNonXa(ConnectionBaseInfo cbi, PoolingDataSource pds) {
        if (cbi.getTransactionIsolation() != null) {
            pds.setIsolationLevel(cbi.getTransactionIsolation());
        }
        pds.setClassName("bitronix.tm.resource.jdbc.lrc.LrcXADataSource");
        if (cbi.getDriverClass() != null) {
            pds.getDriverProperties().setProperty("driverClassName", cbi.getDriverClass());
        }
        if (cbi.getUrl() != null) {
            pds.getDriverProperties().setProperty("url", cbi.getUrl());
        }
        if (cbi.getUsername() != null) {
            pds.getDriverProperties().setProperty("user", cbi.getUsername());
        }
        if (cbi.getPassword() != null) {
            pds.getDriverProperties().setProperty("password", cbi.getPassword());
        }
        return pds;
    }

    protected BTMConnectionBaseInfo clone() throws CloneNotSupportedException {
        return (BTMConnectionBaseInfo)super.clone();
    }
}

