/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.guicedpersistence.btm.implementation;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.jndi.BitronixContext;
import com.google.common.base.Strings;
import com.jwebmp.guicedpersistence.services.ITransactionHandler;
import com.jwebmp.logger.LogFactory;
import com.oracle.jaxb21.PersistenceUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;

public class BTMAutomatedTransactionHandler
implements ITransactionHandler<BTMAutomatedTransactionHandler> {
    private static final Logger log = LogFactory.getLog((String)"BTMAutomatedTransactionHandler");
    private static final BitronixContext bc = new BitronixContext();
    private static final String UserTransactionReference = "java:comp/UserTransaction";
    private static boolean active = true;

    public static boolean isActive() {
        return active;
    }

    public static void setActive(boolean active) {
        BTMAutomatedTransactionHandler.active = active;
    }

    public void beginTransacation(boolean createNew, EntityManager entityManager, PersistenceUnit persistenceUnit) {
        try {
            BitronixTransactionManager userTransaction = (BitronixTransactionManager)bc.lookup(UserTransactionReference);
            userTransaction.begin();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to being a transaction for BTM", e);
        }
    }

    public void commitTransacation(boolean createNew, EntityManager entityManager, PersistenceUnit persistenceUnit) {
        try {
            BitronixTransactionManager userTransaction = (BitronixTransactionManager)bc.lookup(UserTransactionReference);
            userTransaction.commit();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to automatically start the transaction", e);
        }
    }

    public void rollbackTransacation(boolean createNew, EntityManager entityManager, PersistenceUnit persistenceUnit) {
        try {
            BitronixTransactionManager userTransaction = (BitronixTransactionManager)bc.lookup(UserTransactionReference);
            userTransaction.rollback();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to rollback start the transaction", e);
        }
    }

    public boolean transactionExists(EntityManager entityManager, PersistenceUnit persistenceUnit) {
        try {
            BitronixTransactionManager userTransaction = (BitronixTransactionManager)bc.lookup(UserTransactionReference);
            return userTransaction.getStatus() == 0;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "BTM Cannot be fetched!", e);
            return false;
        }
    }

    public boolean active(PersistenceUnit persistenceUnit) {
        return active && !Strings.isNullOrEmpty((String)persistenceUnit.getJtaDataSource()) || !Strings.isNullOrEmpty((String)persistenceUnit.getTransactionType().value()) || !"RESOURCE_LOCAL".equals(persistenceUnit.getTransactionType().value());
    }
}

