/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.guicedpersistence.btm.implementation;

import com.google.common.base.Strings;
import com.jwebmp.guicedpersistence.services.PropertiesEntityManagerReader;
import com.oracle.jaxb21.PersistenceUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class BTMConnectionProperties
implements PropertiesEntityManagerReader {
    private static boolean factoryClass = true;
    private static boolean sessionContext = true;
    private static boolean managerLookup = true;
    private static boolean jndiClass = true;
    private static boolean transactionPlatform = true;

    public static boolean isFactoryClass() {
        return factoryClass;
    }

    public static void setFactoryClass(boolean factoryClass) {
        BTMConnectionProperties.factoryClass = factoryClass;
    }

    public static boolean isSessionContext() {
        return sessionContext;
    }

    public static void setSessionContext(boolean sessionContext) {
        BTMConnectionProperties.sessionContext = sessionContext;
    }

    public static boolean isManagerLookup() {
        return managerLookup;
    }

    public static void setManagerLookup(boolean managerLookup) {
        BTMConnectionProperties.managerLookup = managerLookup;
    }

    public static boolean isJndiClass() {
        return jndiClass;
    }

    public static void setJndiClass(boolean jndiClass) {
        BTMConnectionProperties.jndiClass = jndiClass;
    }

    public static boolean isTransactionPlatform() {
        return transactionPlatform;
    }

    public static void setTransactionPlatform(boolean transactionPlatform) {
        BTMConnectionProperties.transactionPlatform = transactionPlatform;
    }

    public Map<String, String> processProperties(PersistenceUnit persistenceUnit, Properties properties) {
        if ((persistenceUnit.getTransactionType() == null || "RESOURCE_LOCAL".equals(persistenceUnit.getTransactionType().toString())) && Strings.isNullOrEmpty((String)persistenceUnit.getJtaDataSource())) {
            Logger.getLogger("BTMConnectionProperties").warning("Persistence Unit : " + persistenceUnit.getName() + " is not a JTA resource and may skip BTM Configuration. Consider including C3P0 for these connections.");
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (!Strings.isNullOrEmpty((String)persistenceUnit.getJtaDataSource())) {
            props.put("hibernate.connection.datasource", persistenceUnit.getJtaDataSource());
        }
        if (sessionContext) {
            props.put("hibernate.current_session_context_class", "jta");
        }
        if (factoryClass) {
            props.put("hibernate.transaction.factory_class", "org.hibernate.transaction.JTATransactionFactory");
        }
        if (managerLookup) {
            props.put("hibernate.transaction.manager_lookup_class", "org.hibernate.transaction.BTMTransactionManagerLookup");
        }
        if (jndiClass) {
            props.put("hibernate.jndi.class", "bitronix.tm.jndi.BitronixInitialContextFactory");
        }
        if (transactionPlatform) {
            props.put("hibernate.transaction.jta.platform", "org.hibernate.service.jta.platform.internal.BitronixJtaPlatform");
        }
        return props;
    }
}

