/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.plugins.jqueryui.spinner;

import com.jwebmp.core.Component;
import com.jwebmp.core.base.ComponentFeatureBase;
import com.jwebmp.core.base.html.Div;
import com.jwebmp.core.base.html.attributes.NoAttributes;
import com.jwebmp.core.plugins.ComponentInformation;
import com.jwebmp.plugins.globalize.cultures.GlobalizeCultures;
import com.jwebmp.plugins.jqueryui.spinner.JQUISpinnerFeature;
import com.jwebmp.plugins.jqueryui.spinner.JQUISpinnerInput;
import com.jwebmp.plugins.jqueryui.spinner.JQUISpinnerLabel;
import com.jwebmp.plugins.jqueryui.spinner.interfaces.IJQUISpinner;
import com.jwebmp.plugins.jqueryui.spinner.interfaces.JQUISpinnerChildren;
import com.jwebmp.plugins.jqueryui.spinner.interfaces.JQUISpinnerEvents;
import com.jwebmp.plugins.jqueryui.spinner.interfaces.JQUISpinnerFeatures;
import com.jwebmp.plugins.jqueryui.spinner.options.JQUISpinnerOptions;
import javax.validation.constraints.NotNull;

@ComponentInformation(name="JQuery UI Spinner", description="The Spinner, or number stepper widget, is perfect for handling all kinds of numeric input. It allows users to type a value directly, or modify an existing value by spinning with the keyboard, mouse or scrollwheel. When combined with Globalize, you can even spin currencies and dates in a variety of locales.", url="http://jqueryui.com/spinner/", wikiUrl="https://github.com/GedMarc/JWebMP-JQueryUIPlugin/wiki")
public class JQUISpinner<J extends JQUISpinner<J>>
extends Div<JQUISpinnerChildren, NoAttributes, JQUISpinnerFeatures, JQUISpinnerEvents, J>
implements IJQUISpinner {
    private String headerText;
    private JQUISpinnerInput<?, ?> input = new JQUISpinnerInput();
    private JQUISpinnerLabel<?> label;
    private JQUISpinnerFeature<?> feature;

    public JQUISpinner() {
        this(null);
    }

    public JQUISpinner(String labelText) {
        this.input.addFeature((ComponentFeatureBase)this.getFeature());
        this.input.setID(this.getID() + "_spinnerInput");
        if (labelText != null) {
            this.label = new JQUISpinnerLabel(labelText);
            this.label.setForInputComponent((Component)this.input);
        }
    }

    public final JQUISpinnerFeature<?> getFeature() {
        if (this.feature == null) {
            this.feature = new JQUISpinnerFeature((Component)this.input);
        }
        return this.feature;
    }

    @NotNull
    public J addGlobalization(GlobalizeCultures culture) {
        this.getOptions().setCulture(culture);
        return (J)this;
    }

    @Override
    @NotNull
    public JQUISpinnerOptions<?> getOptions() {
        return this.feature.getOptions();
    }

    @Override
    public String getHeaderText() {
        return this.headerText;
    }

    @Override
    public JQUISpinnerInput<?, ?> getInput() {
        return this.input;
    }

    @Override
    public JQUISpinnerLabel<?> getLabel() {
        if (this.label == null) {
            this.label = new JQUISpinnerLabel();
        }
        return this.label;
    }

    @NotNull
    public J setLabel(JQUISpinnerLabel<?> label) {
        this.label = label;
        return (J)this;
    }

    public J setInput(JQUISpinnerInput<?, ?> input) {
        this.input = input;
        return (J)this;
    }

    @NotNull
    public J setHeaderText(String headerText) {
        this.headerText = headerText;
        return (J)this;
    }

    protected StringBuilder renderBeforeTag() {
        if (this.getLabel() != null) {
            return new StringBuilder().append((CharSequence)this.getCurrentTabIndentString()).append(this.getLabel().toString(true)).append(this.getNewLine());
        }
        return null;
    }

    public void preConfigure() {
        if (!this.isConfigured()) {
            this.add(this.getInput());
        }
        super.preConfigure();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }
}

