/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.plugins.jqueryui.tabs;

import com.jwebmp.core.base.ComponentFeatureBase;
import com.jwebmp.core.base.html.Div;
import com.jwebmp.core.base.html.ListItem;
import com.jwebmp.core.base.html.attributes.NoAttributes;
import com.jwebmp.core.base.interfaces.IComponentHierarchyBase;
import com.jwebmp.core.plugins.ComponentInformation;
import com.jwebmp.plugins.jqueryui.tabs.JQUITab;
import com.jwebmp.plugins.jqueryui.tabs.JQUITabContent;
import com.jwebmp.plugins.jqueryui.tabs.JQUITabList;
import com.jwebmp.plugins.jqueryui.tabs.JQUITabsFeature;
import com.jwebmp.plugins.jqueryui.tabs.interfaces.IJQUITabs;
import com.jwebmp.plugins.jqueryui.tabs.interfaces.JQUITabsChildren;
import com.jwebmp.plugins.jqueryui.tabs.interfaces.JQUITabsEvents;
import com.jwebmp.plugins.jqueryui.tabs.interfaces.JQUITabsFeatures;
import com.jwebmp.plugins.jqueryui.tabs.options.JQUITabOptions;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;

@ComponentInformation(name="JQuery UI Tabs", description="Tabs are generally used to break content into multiple sections that can be swapped to save space, much like an accordion", url="http://jqueryui.com/tabs/", wikiUrl="https://github.com/GedMarc/JWebMP-JQueryUIPlugin/wiki")
public class JQUITabs<J extends JQUITabs<J>>
extends Div<JQUITabsChildren, NoAttributes, JQUITabsFeatures, JQUITabsEvents, J>
implements IJQUITabs<J> {
    private JQUITabsFeature<?> feature;
    private JQUITabList<?> unorderedList;
    private List<JQUITab> tabs;

    public JQUITabs() {
        this.addFeature((ComponentFeatureBase)this.getFeature());
    }

    @NotNull
    public final JQUITabsFeature<?> getFeature() {
        if (this.feature == null) {
            this.feature = new JQUITabsFeature(this);
        }
        return this.feature;
    }

    public IJQUITabs asMe() {
        return this;
    }

    public void init() {
        if (!this.isInitialized()) {
            this.add(this.getUnorderedList());
            this.getTabs().forEach(next -> {
                this.getUnorderedList().add((IComponentHierarchyBase)next.getTabHeader());
                this.add(next.getTabDisplayComponent());
            });
        }
        super.init();
    }

    @NotNull
    protected JQUITabList getUnorderedList() {
        if (this.unorderedList == null) {
            this.unorderedList = new JQUITabList();
        }
        return this.unorderedList;
    }

    @NotNull
    protected J setUnorderedList(JQUITabList unorderedList) {
        this.unorderedList = unorderedList;
        return (J)this;
    }

    @Override
    @NotNull
    public JQUITabOptions getOptions() {
        return this.feature.getOptions();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public JQUITab addTab(JQUITab tab) {
        this.getTabs().add(tab);
        return tab;
    }

    @Override
    public JQUITab addTab(String title, JQUITabContent displayComponent) {
        return this.addTab(new JQUITab(new ListItem(title), displayComponent));
    }

    @Override
    @NotNull
    public List<JQUITab> getTabs() {
        if (this.tabs == null) {
            this.tabs = new ArrayList<JQUITab>();
        }
        return this.tabs;
    }

    @Override
    @NotNull
    public J setTabs(List<JQUITab> tabs) {
        this.tabs = tabs;
        return (J)this;
    }
}

