/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.plugins.jqplot.graphs;

import com.jwebmp.core.base.servlets.enumarations.Orientation;
import com.jwebmp.core.generics.CompassPoints;
import com.jwebmp.core.plugins.ComponentInformation;
import com.jwebmp.logger.LogFactory;
import com.jwebmp.plugins.jqplot.JQPlotGraph;
import com.jwebmp.plugins.jqplot.graphs.display.JQPlotBar;
import com.jwebmp.plugins.jqplot.options.axis.JQPlotAxisLabelRendererOptionsCategoryLabels;
import com.jwebmp.plugins.jqplot.options.axis.JQPlotAxisOptions;
import com.jwebmp.plugins.jqplot.options.series.JQPlotSeriesBarOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.NotNull;

@ComponentInformation(name="Bar Graph", description="A bar graph", url="http://www.jqplot.com/examples/barTest.php")
public class JQPlotBarGraph<J extends JQPlotBarGraph<J>>
extends JQPlotGraph<JQPlotSeriesBarOptions, J> {
    private static final Logger LOG = LogFactory.getInstance().getLogger("JQPlotBarGraph");
    protected JQPlotSeriesBarOptions<?> barGraphOptions = null;
    private boolean TwoD = false;
    private Set<String> categoryTickValues;
    private Map<String, List<JQPlotBar>> barGroups;
    private Orientation orientation;
    private boolean clustered;
    private boolean waterfall;

    public JQPlotBarGraph(Orientation orientation) {
        this.setOrientation(orientation);
        this.getOptions().getSeriesDefaults().setRendererOptions(this.getBarGraphOptions());
    }

    public JQPlotSeriesBarOptions<?> getBarGraphOptions() {
        if (this.barGraphOptions == null) {
            this.barGraphOptions = new JQPlotSeriesBarOptions(this);
        }
        return this.barGraphOptions;
    }

    public Set<String> getCategoryTickValues() {
        if (this.categoryTickValues == null) {
            this.categoryTickValues = new LinkedHashSet<String>();
        }
        return this.categoryTickValues;
    }

    public JQPlotSeriesBarOptions<?> getSeriesDefaultBarOptions() {
        if (this.getOptions().getSeriesDefaults().getRendererOptions() == null) {
            this.getOptions().getSeriesDefaults().setRendererOptions(this.getBarGraphOptions());
        }
        return (JQPlotSeriesBarOptions)this.getOptions().getSeriesDefaults().getRendererOptions();
    }

    @NotNull
    public J setCategorizedAxisRenderer() {
        this.getOptions().getAxes().getxAxis().setRendererOptions(new JQPlotAxisLabelRendererOptionsCategoryLabels(this));
        return (J)((Object)this);
    }

    public void preConfigure() {
        super.preConfigure();
        this.getBarGroups().entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            this.categoryTickValues.add(key);
        });
        this.getBarGroups().forEach((key, value) -> value.forEach(a -> {
            if (a.getyValue() != null && a.getyValue() < 0.0) {
                JQPlotSeriesBarOptions series = (JQPlotSeriesBarOptions)this.getOptions().getSeriesDefaults().getRendererOptions();
                series.setFillToZero(true);
            }
        }));
        switch (this.orientation) {
            case HORIZONTAL: {
                JQPlotAxisOptions axis = this.getOptions().getAxes().getyAxis();
                axis.setRendererOptions(new JQPlotAxisLabelRendererOptionsCategoryLabels(this));
                axis.setTicks(this.getCategoryTickValues());
                break;
            }
            case VERTICAL: {
                JQPlotAxisOptions axis = this.getOptions().getAxes().getxAxis();
                axis.setRendererOptions(new JQPlotAxisLabelRendererOptionsCategoryLabels(this));
                axis.setTicks(this.getCategoryTickValues());
                break;
            }
            default: {
                JQPlotAxisOptions axis = this.getOptions().getAxes().getxAxis();
                axis.setRendererOptions(new JQPlotAxisLabelRendererOptionsCategoryLabels(this));
                axis.setTicks(this.getCategoryTickValues());
            }
        }
    }

    public Map<String, List<JQPlotBar>> getBarGroups() {
        if (this.barGroups == null) {
            this.barGroups = new LinkedHashMap<String, List<JQPlotBar>>();
        }
        return this.barGroups;
    }

    public void addBar(String xAxisName, String BarName, Double barValue) {
        JQPlotBar bar = new JQPlotBar(xAxisName, BarName, barValue);
        this.setClustered(true);
        bar.setClustered(true);
        this.addBar(bar);
    }

    public void addBar(JQPlotBar bar) {
        List<JQPlotBar> bars = this.getBarGroup(bar.getxAxisValue());
        bars.add(bar);
    }

    protected List<JQPlotBar> getBarGroup(String xAxisValue) {
        if (!this.getBarGroups().containsKey(xAxisValue)) {
            this.getBarGroups().put(xAxisValue, new ArrayList());
        }
        return this.getBarGroups().get(xAxisValue);
    }

    public void addBar(String xAxisName, Double startingPoint, Double barValue) {
        JQPlotBar bar = new JQPlotBar(xAxisName, startingPoint, barValue);
        this.getBarGraphOptions().setWaterfall(true);
        this.setWaterfall(true);
        this.addBar(bar);
    }

    public void addBar(String xAxisName, String BarName, Double startingPoint, Double barValue) {
        JQPlotBar bar = new JQPlotBar(xAxisName, BarName, startingPoint, barValue);
        this.getBarGraphOptions().setWaterfall(true);
        this.setWaterfall(true);
        this.addBar(bar);
    }

    public void addBar(String XAxisValue, double dataValue) {
        JQPlotBar bar = new JQPlotBar(XAxisValue, dataValue);
        this.addBar(bar);
    }

    @Override
    protected StringBuilder getDataPointRender() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int clusterBarCount = this.getNumberOfClusterBars();
        int categoryCount = this.getNumberOfBarGroups();
        if (clusterBarCount > 1) {
            this.setTwoD(true);
        }
        if (!this.isTwoD()) {
            sb.append("[");
            for (Map.Entry<String, List<JQPlotBar>> entrySet : this.getBarGroups().entrySet()) {
                List<JQPlotBar> value = entrySet.getValue();
                sb.append((CharSequence)this.renderBarArrayList(value));
            }
            if (sb.indexOf(",") > -1) {
                sb = sb.deleteCharAt(sb.lastIndexOf(","));
            }
            sb.append("]");
        } else {
            Object[] rows = new Object[clusterBarCount];
            this.processDataValues(rows, clusterBarCount, categoryCount);
            sb = this.processValuesFromArray(rows, sb);
        }
        sb.append("]");
        return sb;
    }

    public Integer getNumberOfClusterBars() {
        int clusterBars = 0;
        for (Map.Entry<String, List<JQPlotBar>> entry : this.getBarGroups().entrySet()) {
            List<JQPlotBar> value = entry.getValue();
            if (value.size() <= clusterBars) continue;
            clusterBars = value.size();
        }
        return clusterBars;
    }

    public Integer getNumberOfBarGroups() {
        return this.getBarGroups().size();
    }

    public boolean isTwoD() {
        return this.TwoD;
    }

    protected StringBuilder renderBarArrayList(List<JQPlotBar> value) {
        StringBuilder sb = new StringBuilder();
        value.forEach(sb::append);
        return sb;
    }

    private void processDataValues(Object[] rows, int clusterBarCount, int categoryCount) {
        for (int i = 0; i < clusterBarCount; ++i) {
            Object[] valuesPerRow;
            rows[i] = valuesPerRow = new Object[categoryCount];
            block3: for (int j = 0; j < categoryCount; ++j) {
                Map.Entry<String, List<JQPlotBar>> entry;
                List<JQPlotBar> value;
                int mapPosition = 0;
                Iterator<Map.Entry<String, List<JQPlotBar>>> iterator = this.getBarGroups().entrySet().iterator();
                while (iterator.hasNext() && i < (value = (entry = iterator.next()).getValue()).size()) {
                    if (mapPosition == j) {
                        try {
                            JQPlotBar o = value.get(i);
                            if (o == null) continue block3;
                            if (o.getyValue() == null) {
                                valuesPerRow[j] = 0;
                                continue block3;
                            }
                            valuesPerRow[j] = o.getyValue();
                        }
                        catch (Exception e) {
                            LOG.log(Level.WARNING, "Unable to generate data", e);
                            valuesPerRow[j] = "";
                        }
                        continue block3;
                    }
                    ++mapPosition;
                }
            }
        }
    }

    private StringBuilder processValuesFromArray(Object[] rows, StringBuilder sb) {
        for (Object row1 : rows) {
            Object[] row = (Object[])row1;
            sb.append("[");
            for (Object value : row) {
                if (value == null) {
                    value = 0;
                }
                sb.append(value).append(",");
            }
            if (sb.indexOf(",") > -1) {
                sb = sb.deleteCharAt(sb.lastIndexOf(","));
            }
            sb.append("],");
        }
        if (sb.indexOf("],") > -1) {
            sb = sb.deleteCharAt(sb.lastIndexOf(","));
        }
        return sb;
    }

    public void setTwoD(boolean TwoD) {
        this.TwoD = TwoD;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JQPlotBarGraph)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JQPlotBarGraph that = (JQPlotBarGraph)((Object)o);
        if (this.isTwoD() != that.isTwoD()) {
            return false;
        }
        if (this.isClustered() != that.isClustered()) {
            return false;
        }
        if (this.isWaterfall() != that.isWaterfall()) {
            return false;
        }
        if (!this.getBarGraphOptions().equals(that.getBarGraphOptions())) {
            return false;
        }
        if (!this.getCategoryTickValues().equals(that.getCategoryTickValues())) {
            return false;
        }
        if (!this.getBarGroups().equals(that.getBarGroups())) {
            return false;
        }
        return this.getOrientation() == that.getOrientation();
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public boolean isWaterfall() {
        return this.waterfall;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        switch (orientation) {
            case HORIZONTAL: {
                JQPlotAxisOptions axis = this.getOptions().getAxes().getyAxis();
                axis.setRendererOptions(new JQPlotAxisLabelRendererOptionsCategoryLabels(this));
                axis.setTicks(this.getCategoryTickValues());
                this.getSeriesDefaultBarOptions().setBarDirection(Orientation.HORIZONTAL);
                if (this.getOptions().getSeriesDefaults().getPointLabels().getShow() == null) {
                    this.getOptions().getSeriesDefaults().getPointLabels().setLocation(CompassPoints.E);
                    this.getOptions().getSeriesDefaults().getPointLabels().setEdgeTolerance(-15);
                    this.getOptions().getSeriesDefaults().setShadowAngle(135);
                }
                this.getOptions().getAxes().setxAxis(axis);
                break;
            }
            default: {
                JQPlotAxisOptions axis = this.getOptions().getAxes().getxAxis();
                axis.setRendererOptions(new JQPlotAxisLabelRendererOptionsCategoryLabels(this));
                axis.setTicks(this.getCategoryTickValues());
                this.getOptions().getAxes().setyAxis(null);
                break;
            }
        }
    }

    public void setWaterfall(boolean waterfall) {
        this.waterfall = waterfall;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }
}

