/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.plugins.jqplot.graphs;

import com.jwebmp.core.base.servlets.enumarations.Orientation;
import com.jwebmp.core.plugins.ComponentInformation;
import com.jwebmp.plugins.jqplot.graphs.JQPlotBarGraph;
import com.jwebmp.plugins.jqplot.graphs.display.JQPlotBar;
import com.jwebmp.plugins.jqplot.options.axis.JQPlotAxisLabelRendererOptionsCategoryLabels;
import com.jwebmp.plugins.jqplot.parts.YAxisTypes;
import java.util.List;

@ComponentInformation(name="Waterfall Graph", description="A waterfall graph", url="http://www.jqplot.com/examples/waterfall.php")
public class JQPlotBarWaterFallGraph
extends JQPlotBarGraph {
    public JQPlotBarWaterFallGraph(Orientation orientation) {
        super(orientation);
        this.setOrientation(orientation);
        this.setWaterfall(true);
        this.getOptions().getSeriesDefaults().setRendererOptions(this.barGraphOptions);
        this.getBarGraphOptions().setWaterfall(true);
        this.getBarGraphOptions().setVaryBarColor(true);
        this.getOptions().getSeriesDefaults().getPointLabels().setHideZeros(true);
        this.getOptions().getSeriesDefaults().setYaxis(YAxisTypes.Y2Axis);
        this.getOptions().getAxes().getxAxis().setRendererOptions(new JQPlotAxisLabelRendererOptionsCategoryLabels(this));
    }

    @Override
    public void preConfigure() {
        super.preConfigure();
        this.getBarGraphOptions().setFillToZero(null);
    }

    @Override
    public void addBar(String xAxisName, String BarName, Double barValue) {
        JQPlotBar bar = new JQPlotBar(xAxisName, BarName, barValue);
        this.setClustered(true);
        bar.setClustered(true);
        this.addBar(bar);
    }

    @Override
    public void addBar(JQPlotBar bar) {
        List<JQPlotBar> bars = this.getBarGroup(bar.getxAxisValue());
        bars.add(bar);
        bar.setWaterfall(true);
        this.getCategoryTickValues().add(bar.getxAxisValue());
    }

    @Override
    public void addBar(String xAxisName, Double startingPoint, Double barValue) {
        JQPlotBar bar = new JQPlotBar(xAxisName, startingPoint, barValue);
        this.barGraphOptions.setWaterfall(true);
        this.setWaterfall(true);
        this.addBar(bar);
    }

    @Override
    public void addBar(String xAxisName, String BarName, Double startingPoint, Double barValue) {
        JQPlotBar bar = new JQPlotBar(xAxisName, BarName, startingPoint, barValue);
        this.barGraphOptions.setWaterfall(true);
        this.setWaterfall(true);
        this.addBar(bar);
    }

    public void addBar(String XAxisValue, Double dataValue) {
        JQPlotBar bar = new JQPlotBar(XAxisValue, dataValue);
        bar.setWaterfall(true);
        this.addBar(bar);
    }
}

