/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.plugins.jqplot.graphs;

import com.jwebmp.core.plugins.ComponentInformation;
import com.jwebmp.plugins.jqplot.JQPlotGraph;
import com.jwebmp.plugins.jqplot.graphs.display.JQPlotBubble;
import com.jwebmp.plugins.jqplot.options.JQPlotOptions;
import com.jwebmp.plugins.jqplot.options.series.JQPlotSeriesBubbleOptions;
import java.util.ArrayList;
import java.util.List;

@ComponentInformation(name="Bubble Graph", description="A bubble graph", url="http://www.jqplot.com/examples/bubbleChart.php")
public class JQPlotBubbleGraph<J extends JQPlotBubbleGraph<J>>
extends JQPlotGraph<JQPlotOptions, J> {
    private List<JQPlotBubble> bubbles;
    private JQPlotSeriesBubbleOptions bubbleOptions;

    public JQPlotBubbleGraph() {
        this.getOptions().getSeriesDefaults();
        this.getOptions().getSeriesDefaults().setRendererOptions(this.getBubbleOptions());
    }

    public final JQPlotSeriesBubbleOptions getBubbleOptions() {
        if (this.bubbleOptions == null) {
            this.bubbleOptions = new JQPlotSeriesBubbleOptions(this);
        }
        return this.bubbleOptions;
    }

    public void setBubbleOptions(JQPlotSeriesBubbleOptions bubbleOptions) {
        this.bubbleOptions = bubbleOptions;
    }

    public JQPlotBubble addBubble(double x, double y, int radius, String label) {
        JQPlotBubble bubble = new JQPlotBubble(x, y, radius, label);
        this.getBubbles().add(bubble);
        return bubble;
    }

    public List<JQPlotBubble> getBubbles() {
        if (this.bubbles == null) {
            this.bubbles = new ArrayList<JQPlotBubble>();
        }
        return this.bubbles;
    }

    public void setBubbles(List<JQPlotBubble> bubbles) {
        this.bubbles = bubbles;
    }

    @Override
    public StringBuilder getDataPointRender() {
        StringBuilder sb = new StringBuilder("[[");
        for (JQPlotBubble next : this.getBubbles()) {
            sb.append(next).append(",");
        }
        if (sb.indexOf(",") > 0) {
            sb = sb.deleteCharAt(sb.lastIndexOf(","));
        }
        sb.append("]]");
        return sb;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

