/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.plugins.jqplot.graphs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.jwebmp.core.plugins.ComponentInformation;
import com.jwebmp.plugins.jqplot.JQPlotGraph;
import com.jwebmp.plugins.jqplot.graphs.display.JQPlotDonutGroup;
import com.jwebmp.plugins.jqplot.graphs.display.JQPlotPieSlice;
import com.jwebmp.plugins.jqplot.options.JQPlotOptions;
import com.jwebmp.plugins.jqplot.options.series.JQPlotSeriesDonutOptions;
import java.util.ArrayList;
import java.util.List;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@ComponentInformation(name="Donut Graph", description="A donut graph", url="http://www.jqplot.com/examples/pie-donut-charts.php")
public class JQPlotDonutGraph<J extends JQPlotDonutGraph<J>>
extends JQPlotGraph<JQPlotOptions, J> {
    @JsonIgnore
    private JQPlotSeriesDonutOptions donutOptions = new JQPlotSeriesDonutOptions(this);
    @JsonIgnore
    private JQPlotDonutGroup donutGroup;

    public JQPlotDonutGraph() {
        this.getOptions().getSeriesDefaults().setRendererOptions(this.donutOptions);
        this.donutGroup = new JQPlotDonutGroup();
    }

    public List<JQPlotPieSlice> getPlotSlices(int donutGroup) {
        List<JQPlotPieSlice> arr = this.getDonutGroup().get(donutGroup);
        if (arr == null) {
            this.getDonutGroup().add(donutGroup, arr);
        }
        return this.getDonutGroup().get(donutGroup);
    }

    public List<List<JQPlotPieSlice>> getDonutGroup() {
        if (this.donutGroup == null) {
            this.donutGroup = new JQPlotDonutGroup();
        }
        return this.donutGroup.getDonutGroup();
    }

    public JQPlotPieSlice addSlice(int doubleGroup, String name, double values) {
        JQPlotPieSlice slice = new JQPlotPieSlice(name, values);
        this.getDonutGroupSlices(doubleGroup).add(slice);
        return slice;
    }

    public List<JQPlotPieSlice> getDonutGroupSlices(int groupNumber) {
        if (this.getDonutGroup().size() >= groupNumber) {
            ArrayList newList = new ArrayList();
            this.getDonutGroup().add(newList);
        }
        return this.getDonutGroup().get(groupNumber);
    }

    public List<JQPlotPieSlice> addSlices(int doubleGroup, double[] values) {
        List<JQPlotPieSlice> newSlices = this.getDonutGroupSlices(doubleGroup);
        for (int i = 0; i < values.length; ++i) {
            double value = values[i];
            JQPlotPieSlice slice = new JQPlotPieSlice("Slice " + i, value);
            newSlices.add(slice);
        }
        return newSlices;
    }

    public JQPlotSeriesDonutOptions getDonutOptions() {
        return this.donutOptions;
    }

    public void setDonutOptions(JQPlotSeriesDonutOptions donutOptions) {
        this.donutOptions = donutOptions;
    }

    @Override
    protected StringBuilder getDataPointRender() {
        StringBuilder sb = new StringBuilder();
        String jsonInString = this.getDonutGroupJSON().toString();
        sb.append(jsonInString);
        return sb;
    }

    @JsonRawValue
    @JsonFormat(shape=JsonFormat.Shape.ARRAY)
    public List<List<JQPlotPieSlice>> getDonutGroupJSON() {
        return this.getDonutGroup();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

