/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.plugins.jqplot.graphs;

import com.jwebmp.core.plugins.ComponentInformation;
import com.jwebmp.plugins.jqplot.JQPlotGraph;
import com.jwebmp.plugins.jqplot.graphs.display.JQPlotLine;
import com.jwebmp.plugins.jqplot.options.JQPlotOptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@ComponentInformation(name="Line Graph", description="The most basic jqPlot chart takes a series of data and plots a line. No options need to be supplied. Data is passed in as an array of series. A series can be either an array of y values or an array of [x,y] data pairs. If y values only, x values are assigned like 1, 2, 3, ... Note, for this plot you don't need any plugins.", url="http://www.jqplot.com/examples/line-charts.php")
public class JQPlotLineGraph<J extends JQPlotLineGraph<J>>
extends JQPlotGraph<JQPlotOptions, J> {
    private List<JQPlotLine> plotLines;

    public void addLine(double ... xyValues) {
        JQPlotLine newLine = new JQPlotLine(JQPlotLine.buildFromArray(new Serializable[]{xyValues}));
        this.getPlotLines().add(newLine);
    }

    public List<JQPlotLine> getPlotLines() {
        if (this.plotLines == null) {
            this.plotLines = new ArrayList<JQPlotLine>();
        }
        return this.plotLines;
    }

    public void addLine(Object[] xyValues) {
        JQPlotLine newLine = new JQPlotLine(JQPlotLine.buildFromArray(new Serializable[]{xyValues}));
        this.getPlotLines().add(newLine);
    }

    public void addLine(String xyValues) {
        JQPlotLine newLine = new JQPlotLine(JQPlotLine.buildFromDelimiteredSrting(xyValues, ","));
        this.getPlotLines().add(newLine);
    }

    public void addLine(JQPlotLine newLine) {
        this.getPlotLines().add(newLine);
    }

    @Override
    protected StringBuilder getDataPointRender() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (JQPlotLine plotLine : this.getPlotLines()) {
            sb.append(plotLine).append(",");
        }
        sb = sb.deleteCharAt(sb.lastIndexOf(","));
        sb.append("]");
        return sb;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

