/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.plugins.jqplot.graphs;

import com.jwebmp.core.plugins.ComponentInformation;
import com.jwebmp.plugins.jqplot.JQPlotGraph;
import com.jwebmp.plugins.jqplot.graphs.display.JQPlotPieSlice;
import com.jwebmp.plugins.jqplot.options.JQPlotOptions;
import com.jwebmp.plugins.jqplot.options.series.JQPlotSeriesPieOptions;
import java.util.ArrayList;
import java.util.List;

@ComponentInformation(name="Pie Graph", description="A pie graph", url="http://www.jqplot.com/examples/pieTest.php")
public class JQPlotPieGraph<J extends JQPlotPieGraph<J>>
extends JQPlotGraph<JQPlotOptions, J> {
    private List<JQPlotPieSlice> plotSlices;

    public JQPlotPieGraph() {
        this.getOptions().getSeriesDefaults().setRendererOptions(new JQPlotSeriesPieOptions(this));
    }

    public List<JQPlotPieSlice> addSlices(double[] values) {
        ArrayList<JQPlotPieSlice> output = new ArrayList<JQPlotPieSlice>();
        String s = "Slice ";
        for (int i = 0; i < values.length; ++i) {
            double value = values[i];
            JQPlotPieSlice slice = new JQPlotPieSlice(s + i + 1, value);
            this.getPlotSlices().add(slice);
        }
        return output;
    }

    public List<JQPlotPieSlice> getPlotSlices() {
        if (this.plotSlices == null) {
            this.plotSlices = new ArrayList<JQPlotPieSlice>();
        }
        return this.plotSlices;
    }

    public JQPlotPieSlice addSlice(String name, double values) {
        JQPlotPieSlice slice = new JQPlotPieSlice(name, values);
        this.getPlotSlices().add(slice);
        return slice;
    }

    @Override
    protected StringBuilder getDataPointRender() {
        StringBuilder sb = new StringBuilder();
        sb.append("[[");
        for (JQPlotPieSlice plotLine : this.getPlotSlices()) {
            sb.append((Object)plotLine).append(",");
        }
        sb = sb.deleteCharAt(sb.lastIndexOf(","));
        sb.append("]]");
        return sb;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

