/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.plugins.jqueryui.accordion;

import com.jwebmp.core.base.ComponentFeatureBase;
import com.jwebmp.core.base.html.Div;
import com.jwebmp.core.base.html.attributes.GlobalAttributes;
import com.jwebmp.core.base.html.attributes.NoAttributes;
import com.jwebmp.core.plugins.ComponentInformation;
import com.jwebmp.plugins.jqueryui.accordion.JQUIAccordionContent;
import com.jwebmp.plugins.jqueryui.accordion.JQUIAccordionFeature;
import com.jwebmp.plugins.jqueryui.accordion.JQUIAccordionHeader;
import com.jwebmp.plugins.jqueryui.accordion.JQUIAccordionTab;
import com.jwebmp.plugins.jqueryui.accordion.enumerations.JQUIAccordionHeightStyle;
import com.jwebmp.plugins.jqueryui.accordion.interfaces.JQUIAccordionChildren;
import com.jwebmp.plugins.jqueryui.accordion.interfaces.JQUIAccordionEvents;
import com.jwebmp.plugins.jqueryui.accordion.interfaces.JQUIAccordionFeatures;
import com.jwebmp.plugins.jqueryui.accordion.options.JQUIAccordionOptions;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;

@ComponentInformation(name="JQuery UI Accordion", description="Displays collapsible content panels for presenting information in a limited amount of space.", url="http://jqueryui.com/accordion/", wikiUrl="https://github.com/GedMarc/JWebSwing-JQueryUIPlugin/wiki")
public class JQUIAccordion<J extends JQUIAccordion<J>>
extends Div<JQUIAccordionChildren, NoAttributes, JQUIAccordionFeatures, JQUIAccordionEvents, J>
implements JQUIAccordionChildren<JQUIAccordionChildren, J> {
    private static final long serialVersionUID = 1L;
    private List<JQUIAccordionTab<?>> accordionTabs = new ArrayList();
    private JQUIAccordionFeature feature = new JQUIAccordionFeature(this);

    public JQUIAccordion() {
        this(null);
        this.accordionTabs = new ArrayList();
    }

    public JQUIAccordion(JQUIAccordionHeightStyle heightStyle) {
        this.addFeature((ComponentFeatureBase)this.feature);
        this.getOptions().setHeightStyle(heightStyle);
        this.addAttribute(GlobalAttributes.JWType, "accordion");
    }

    @NotNull
    public final JQUIAccordionOptions getOptions() {
        return this.getFeature().getOptions();
    }

    @NotNull
    public JQUIAccordionFeature getFeature() {
        if (this.feature == null) {
            this.feature = new JQUIAccordionFeature(this);
        }
        return this.feature;
    }

    @NotNull
    public J setFeature(JQUIAccordionFeature feature) {
        this.feature = feature;
        return (J)this;
    }

    @NotNull
    public JQUIAccordionTab addAccordianTab(String tabName, @NotNull JQUIAccordionContent tabContents) {
        if (this.getOptions().getHeader() != null) {
            return this.addAccordianTab(new JQUIAccordionHeader(tabName), tabContents);
        }
        JQUIAccordionHeader header = new JQUIAccordionHeader(tabName);
        return this.addAccordianTab(header, tabContents);
    }

    public JQUIAccordionTab addAccordianTab(JQUIAccordionHeader tabName, JQUIAccordionContent tabContents) {
        JQUIAccordionTab accTab = new JQUIAccordionTab(tabName, tabContents);
        this.addAccordianTab(accTab);
        return accTab;
    }

    @NotNull
    public JQUIAccordionTab addAccordianTab(@NotNull JQUIAccordionTab accordianTab) {
        this.getAccordionTabs().add(accordianTab);
        return accordianTab;
    }

    @NotNull
    public List<JQUIAccordionTab<?>> getAccordionTabs() {
        if (this.accordionTabs == null) {
            this.accordionTabs = new ArrayList();
        }
        return this.accordionTabs;
    }

    @NotNull
    public J setAccordionTabs(List<JQUIAccordionTab<?>> accordianTabs) {
        this.accordionTabs = accordianTabs;
        return (J)this;
    }

    public void preConfigure() {
        if (!this.isConfigured()) {
            for (JQUIAccordionTab<?> a : this.getAccordionTabs()) {
                a.getHeader().setHeaderType(this.getOptions().getHeader());
                this.add(a.getHeader());
                this.add(a.getComponent());
            }
        }
        super.preConfigure();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }
}

