
/*!
 * jQuery UI Draggable 1.12.1
 * http://jqueryui.com
 *
 * Copyright jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */
(function(a){if(typeof define==="function"&&define.amd){define(["jquery","./mouse","../data","../plugin","../safe-active-element","../safe-blur","../scroll-parent","../version","../widget"],a)}else{a(jQuery)}}(function(a){a.widget("ui.draggable",a.ui.mouse,{version:"1.12.1",widgetEventPrefix:"drag",options:{addClasses:true,appendTo:"parent",axis:false,connectToSortable:false,containment:false,cursor:"auto",cursorAt:false,grid:false,handle:false,helper:"original",iframeFix:false,opacity:false,refreshPositions:false,revert:false,revertDuration:500,scope:"default",scroll:true,scrollSensitivity:20,scrollSpeed:20,snap:false,snapMode:"both",snapTolerance:20,stack:false,zIndex:false,drag:null,start:null,stop:null},_create:function(){if(this.options.helper==="original"){this._setPositionRelative()}if(this.options.addClasses){this._addClass("ui-draggable")}this._setHandleClassName();this._mouseInit()},_setOption:function(b,c){this._super(b,c);if(b==="handle"){this._removeHandleClassName();this._setHandleClassName()}},_destroy:function(){if((this.helper||this.element).is(".ui-draggable-dragging")){this.destroyOnClear=true;return}this._removeHandleClassName();this._mouseDestroy()},_mouseCapture:function(b){var c=this.options;if(this.helper||c.disabled||a(b.target).closest(".ui-resizable-handle").length>0){return false}this.handle=this._getHandle(b);if(!this.handle){return false}this._blurActiveElement(b);this._blockFrames(c.iframeFix===true?"iframe":c.iframeFix);return true},_blockFrames:function(b){this.iframeBlocks=this.document.find(b).map(function(){var c=a(this);return a("<div>").css("position","absolute").appendTo(c.parent()).outerWidth(c.outerWidth()).outerHeight(c.outerHeight()).offset(c.offset())[0]})},_unblockFrames:function(){if(this.iframeBlocks){this.iframeBlocks.remove();delete this.iframeBlocks}},_blurActiveElement:function(c){var b=a.ui.safeActiveElement(this.document[0]),d=a(c.target);if(d.closest(b).length){return}a.ui.safeBlur(b)},_mouseStart:function(b){var c=this.options;this.helper=this._createHelper(b);this._addClass(this.helper,"ui-draggable-dragging");this._cacheHelperProportions();if(a.ui.ddmanager){a.ui.ddmanager.current=this}this._cacheMargins();this.cssPosition=this.helper.css("position");this.scrollParent=this.helper.scrollParent(true);this.offsetParent=this.helper.offsetParent();this.hasFixedAncestor=this.helper.parents().filter(function(){return a(this).css("position")==="fixed"}).length>0;this.positionAbs=this.element.offset();this._refreshOffsets(b);this.originalPosition=this.position=this._generatePosition(b,false);this.originalPageX=b.pageX;this.originalPageY=b.pageY;(c.cursorAt&&this._adjustOffsetFromHelper(c.cursorAt));this._setContainment();if(this._trigger("start",b)===false){this._clear();return false}this._cacheHelperProportions();if(a.ui.ddmanager&&!c.dropBehaviour){a.ui.ddmanager.prepareOffsets(this,b)}this._mouseDrag(b,true);if(a.ui.ddmanager){a.ui.ddmanager.dragStart(this,b)}return true},_refreshOffsets:function(b){this.offset={top:this.positionAbs.top-this.margins.top,left:this.positionAbs.left-this.margins.left,scroll:false,parent:this._getParentOffset(),relative:this._getRelativeOffset()};this.offset.click={left:b.pageX-this.offset.left,top:b.pageY-this.offset.top}},_mouseDrag:function(b,d){if(this.hasFixedAncestor){this.offset.parent=this._getParentOffset()}this.position=this._generatePosition(b,true);this.positionAbs=this._convertPositionTo("absolute");if(!d){var c=this._uiHash();if(this._trigger("drag",b,c)===false){this._mouseUp(new a.Event("mouseup",b));return false}this.position=c.position}this.helper[0].style.left=this.position.left+"px";this.helper[0].style.top=this.position.top+"px";if(a.ui.ddmanager){a.ui.ddmanager.drag(this,b)}return false},_mouseStop:function(c){var b=this,d=false;if(a.ui.ddmanager&&!this.options.dropBehaviour){d=a.ui.ddmanager.drop(this,c)}if(this.dropped){d=this.dropped;this.dropped=false}if((this.options.revert==="invalid"&&!d)||(this.options.revert==="valid"&&d)||this.options.revert===true||(a.isFunction(this.options.revert)&&this.options.revert.call(this.element,d))){a(this.helper).animate(this.originalPosition,parseInt(this.options.revertDuration,10),function(){if(b._trigger("stop",c)!==false){b._clear()}})}else{if(this._trigger("stop",c)!==false){this._clear()}}return false},_mouseUp:function(b){this._unblockFrames();if(a.ui.ddmanager){a.ui.ddmanager.dragStop(this,b)}if(this.handleElement.is(b.target)){this.element.trigger("focus")}return a.ui.mouse.prototype._mouseUp.call(this,b)},cancel:function(){if(this.helper.is(".ui-draggable-dragging")){this._mouseUp(new a.Event("mouseup",{target:this.element[0]}))}else{this._clear()}return this},_getHandle:function(b){return this.options.handle?!!a(b.target).closest(this.element.find(this.options.handle)).length:true},_setHandleClassName:function(){this.handleElement=this.options.handle?this.element.find(this.options.handle):this.element;this._addClass(this.handleElement,"ui-draggable-handle")},_removeHandleClassName:function(){this._removeClass(this.handleElement,"ui-draggable-handle")},_createHelper:function(c){var e=this.options,d=a.isFunction(e.helper),b=d?a(e.helper.apply(this.element[0],[c])):(e.helper==="clone"?this.element.clone().removeAttr("id"):this.element);if(!b.parents("body").length){b.appendTo((e.appendTo==="parent"?this.element[0].parentNode:e.appendTo))}if(d&&b[0]===this.element[0]){this._setPositionRelative()}if(b[0]!==this.element[0]&&!(/(fixed|absolute)/).test(b.css("position"))){b.css("position","absolute")}return b},_setPositionRelative:function(){if(!(/^(?:r|a|f)/).test(this.element.css("position"))){this.element[0].style.position="relative"}},_adjustOffsetFromHelper:function(b){if(typeof b==="string"){b=b.split(" ")}if(a.isArray(b)){b={left:+b[0],top:+b[1]||0}}if("left" in b){this.offset.click.left=b.left+this.margins.left}if("right" in b){this.offset.click.left=this.helperProportions.width-b.right+this.margins.left}if("top" in b){this.offset.click.top=b.top+this.margins.top}if("bottom" in b){this.offset.click.top=this.helperProportions.height-b.bottom+this.margins.top}},_isRootNode:function(b){return(/(html|body)/i).test(b.tagName)||b===this.document[0]},_getParentOffset:function(){var c=this.offsetParent.offset(),b=this.document[0];if(this.cssPosition==="absolute"&&this.scrollParent[0]!==b&&a.contains(this.scrollParent[0],this.offsetParent[0])){c.left+=this.scrollParent.scrollLeft();c.top+=this.scrollParent.scrollTop()}if(this._isRootNode(this.offsetParent[0])){c={top:0,left:0}}return{top:c.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:c.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)}},_getRelativeOffset:function(){if(this.cssPosition!=="relative"){return{top:0,left:0}}var b=this.element.position(),c=this._isRootNode(this.scrollParent[0]);return{top:b.top-(parseInt(this.helper.css("top"),10)||0)+(!c?this.scrollParent.scrollTop():0),left:b.left-(parseInt(this.helper.css("left"),10)||0)+(!c?this.scrollParent.scrollLeft():0)}},_cacheMargins:function(){this.margins={left:(parseInt(this.element.css("marginLeft"),10)||0),top:(parseInt(this.element.css("marginTop"),10)||0),right:(parseInt(this.element.css("marginRight"),10)||0),bottom:(parseInt(this.element.css("marginBottom"),10)||0)}},_cacheHelperProportions:function(){this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()}},_setContainment:function(){var d,g,e,f=this.options,b=this.document[0];this.relativeContainer=null;if(!f.containment){this.containment=null;return}if(f.containment==="window"){this.containment=[a(window).scrollLeft()-this.offset.relative.left-this.offset.parent.left,a(window).scrollTop()-this.offset.relative.top-this.offset.parent.top,a(window).scrollLeft()+a(window).width()-this.helperProportions.width-this.margins.left,a(window).scrollTop()+(a(window).height()||b.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top];return}if(f.containment==="document"){this.containment=[0,0,a(b).width()-this.helperProportions.width-this.margins.left,(a(b).height()||b.body.parentNode.scrollHeight)-this.helperProportions.height-this.margins.top];return}if(f.containment.constructor===Array){this.containment=f.containment;return}if(f.containment==="parent"){f.containment=this.helper[0].parentNode}g=a(f.containment);e=g[0];if(!e){return}d=/(scroll|auto)/.test(g.css("overflow"));this.containment=[(parseInt(g.css("borderLeftWidth"),10)||0)+(parseInt(g.css("paddingLeft"),10)||0),(parseInt(g.css("borderTopWidth"),10)||0)+(parseInt(g.css("paddingTop"),10)||0),(d?Math.max(e.scrollWidth,e.offsetWidth):e.offsetWidth)-(parseInt(g.css("borderRightWidth"),10)||0)-(parseInt(g.css("paddingRight"),10)||0)-this.helperProportions.width-this.margins.left-this.margins.right,(d?Math.max(e.scrollHeight,e.offsetHeight):e.offsetHeight)-(parseInt(g.css("borderBottomWidth"),10)||0)-(parseInt(g.css("paddingBottom"),10)||0)-this.helperProportions.height-this.margins.top-this.margins.bottom];this.relativeContainer=g},_convertPositionTo:function(c,f){if(!f){f=this.position}var b=c==="absolute"?1:-1,e=this._isRootNode(this.scrollParent[0]);return{top:(f.top+this.offset.relative.top*b+this.offset.parent.top*b-((this.cssPosition==="fixed"?-this.offset.scroll.top:(e?0:this.offset.scroll.top))*b)),left:(f.left+this.offset.relative.left*b+this.offset.parent.left*b-((this.cssPosition==="fixed"?-this.offset.scroll.left:(e?0:this.offset.scroll.left))*b))}},_generatePosition:function(c,i){var b,j,k,e,d=this.options,h=this._isRootNode(this.scrollParent[0]),g=c.pageX,f=c.pageY;if(!h||!this.offset.scroll){this.offset.scroll={top:this.scrollParent.scrollTop(),left:this.scrollParent.scrollLeft()}}if(i){if(this.containment){if(this.relativeContainer){j=this.relativeContainer.offset();b=[this.containment[0]+j.left,this.containment[1]+j.top,this.containment[2]+j.left,this.containment[3]+j.top]}else{b=this.containment}if(c.pageX-this.offset.click.left<b[0]){g=b[0]+this.offset.click.left}if(c.pageY-this.offset.click.top<b[1]){f=b[1]+this.offset.click.top}if(c.pageX-this.offset.click.left>b[2]){g=b[2]+this.offset.click.left}if(c.pageY-this.offset.click.top>b[3]){f=b[3]+this.offset.click.top}}if(d.grid){k=d.grid[1]?this.originalPageY+Math.round((f-this.originalPageY)/d.grid[1])*d.grid[1]:this.originalPageY;f=b?((k-this.offset.click.top>=b[1]||k-this.offset.click.top>b[3])?k:((k-this.offset.click.top>=b[1])?k-d.grid[1]:k+d.grid[1])):k;e=d.grid[0]?this.originalPageX+Math.round((g-this.originalPageX)/d.grid[0])*d.grid[0]:this.originalPageX;g=b?((e-this.offset.click.left>=b[0]||e-this.offset.click.left>b[2])?e:((e-this.offset.click.left>=b[0])?e-d.grid[0]:e+d.grid[0])):e}if(d.axis==="y"){g=this.originalPageX}if(d.axis==="x"){f=this.originalPageY}}return{top:(f-this.offset.click.top-this.offset.relative.top-this.offset.parent.top+(this.cssPosition==="fixed"?-this.offset.scroll.top:(h?0:this.offset.scroll.top))),left:(g-this.offset.click.left-this.offset.relative.left-this.offset.parent.left+(this.cssPosition==="fixed"?-this.offset.scroll.left:(h?0:this.offset.scroll.left)))}},_clear:function(){this._removeClass(this.helper,"ui-draggable-dragging");if(this.helper[0]!==this.element[0]&&!this.cancelHelperRemoval){this.helper.remove()}this.helper=null;this.cancelHelperRemoval=false;if(this.destroyOnClear){this.destroy()}},_trigger:function(b,c,d){d=d||this._uiHash();a.ui.plugin.call(this,b,[c,d,this],true);if(/^(drag|start|stop)/.test(b)){this.positionAbs=this._convertPositionTo("absolute");d.offset=this.positionAbs}return a.Widget.prototype._trigger.call(this,b,c,d)},plugins:{},_uiHash:function(){return{helper:this.helper,position:this.position,originalPosition:this.originalPosition,offset:this.positionAbs}}});a.ui.plugin.add("draggable","connectToSortable",{start:function(d,e,b){var c=a.extend({},e,{item:b.element});b.sortables=[];a(b.options.connectToSortable).each(function(){var f=a(this).sortable("instance");if(f&&!f.options.disabled){b.sortables.push(f);f.refreshPositions();f._trigger("activate",d,c)}})},stop:function(d,e,b){var c=a.extend({},e,{item:b.element});b.cancelHelperRemoval=false;a.each(b.sortables,function(){var f=this;if(f.isOver){f.isOver=0;b.cancelHelperRemoval=true;f.cancelHelperRemoval=false;f._storedCSS={position:f.placeholder.css("position"),top:f.placeholder.css("top"),left:f.placeholder.css("left")};f._mouseStop(d);f.options.helper=f.options._helper}else{f.cancelHelperRemoval=true;f._trigger("deactivate",d,c)}})},drag:function(c,d,b){a.each(b.sortables,function(){var e=false,f=this;f.positionAbs=b.positionAbs;f.helperProportions=b.helperProportions;f.offset.click=b.offset.click;if(f._intersectsWith(f.containerCache)){e=true;a.each(b.sortables,function(){this.positionAbs=b.positionAbs;this.helperProportions=b.helperProportions;this.offset.click=b.offset.click;if(this!==f&&this._intersectsWith(this.containerCache)&&a.contains(f.element[0],this.element[0])){e=false}return e})}if(e){if(!f.isOver){f.isOver=1;b._parent=d.helper.parent();f.currentItem=d.helper.appendTo(f.element).data("ui-sortable-item",true);f.options._helper=f.options.helper;f.options.helper=function(){return d.helper[0]};c.target=f.currentItem[0];f._mouseCapture(c,true);f._mouseStart(c,true,true);f.offset.click.top=b.offset.click.top;f.offset.click.left=b.offset.click.left;f.offset.parent.left-=b.offset.parent.left-f.offset.parent.left;f.offset.parent.top-=b.offset.parent.top-f.offset.parent.top;b._trigger("toSortable",c);b.dropped=f.element;a.each(b.sortables,function(){this.refreshPositions()});b.currentItem=b.element;f.fromOutside=b}if(f.currentItem){f._mouseDrag(c);d.position=f.position}}else{if(f.isOver){f.isOver=0;f.cancelHelperRemoval=true;f.options._revert=f.options.revert;f.options.revert=false;f._trigger("out",c,f._uiHash(f));f._mouseStop(c,true);f.options.revert=f.options._revert;f.options.helper=f.options._helper;if(f.placeholder){f.placeholder.remove()}d.helper.appendTo(b._parent);b._refreshOffsets(c);d.position=b._generatePosition(c,true);b._trigger("fromSortable",c);b.dropped=false;a.each(b.sortables,function(){this.refreshPositions()})}}})}});a.ui.plugin.add("draggable","cursor",{start:function(d,e,b){var c=a("body"),f=b.options;if(c.css("cursor")){f._cursor=c.css("cursor")}c.css("cursor",f.cursor)},stop:function(c,d,b){var e=b.options;if(e._cursor){a("body").css("cursor",e._cursor)}}});a.ui.plugin.add("draggable","opacity",{start:function(d,e,b){var c=a(e.helper),f=b.options;if(c.css("opacity")){f._opacity=c.css("opacity")}c.css("opacity",f.opacity)},stop:function(c,d,b){var e=b.options;if(e._opacity){a(d.helper).css("opacity",e._opacity)}}});a.ui.plugin.add("draggable","scroll",{start:function(c,d,b){if(!b.scrollParentNotHidden){b.scrollParentNotHidden=b.helper.scrollParent(false)}if(b.scrollParentNotHidden[0]!==b.document[0]&&b.scrollParentNotHidden[0].tagName!=="HTML"){b.overflowOffset=b.scrollParentNotHidden.offset()}},drag:function(e,f,d){var g=d.options,c=false,h=d.scrollParentNotHidden[0],b=d.document[0];if(h!==b&&h.tagName!=="HTML"){if(!g.axis||g.axis!=="x"){if((d.overflowOffset.top+h.offsetHeight)-e.pageY<g.scrollSensitivity){h.scrollTop=c=h.scrollTop+g.scrollSpeed}else{if(e.pageY-d.overflowOffset.top<g.scrollSensitivity){h.scrollTop=c=h.scrollTop-g.scrollSpeed}}}if(!g.axis||g.axis!=="y"){if((d.overflowOffset.left+h.offsetWidth)-e.pageX<g.scrollSensitivity){h.scrollLeft=c=h.scrollLeft+g.scrollSpeed}else{if(e.pageX-d.overflowOffset.left<g.scrollSensitivity){h.scrollLeft=c=h.scrollLeft-g.scrollSpeed}}}}else{if(!g.axis||g.axis!=="x"){if(e.pageY-a(b).scrollTop()<g.scrollSensitivity){c=a(b).scrollTop(a(b).scrollTop()-g.scrollSpeed)}else{if(a(window).height()-(e.pageY-a(b).scrollTop())<g.scrollSensitivity){c=a(b).scrollTop(a(b).scrollTop()+g.scrollSpeed)}}}if(!g.axis||g.axis!=="y"){if(e.pageX-a(b).scrollLeft()<g.scrollSensitivity){c=a(b).scrollLeft(a(b).scrollLeft()-g.scrollSpeed)}else{if(a(window).width()-(e.pageX-a(b).scrollLeft())<g.scrollSensitivity){c=a(b).scrollLeft(a(b).scrollLeft()+g.scrollSpeed)}}}}if(c!==false&&a.ui.ddmanager&&!g.dropBehaviour){a.ui.ddmanager.prepareOffsets(d,e)}}});a.ui.plugin.add("draggable","snap",{start:function(c,d,b){var e=b.options;b.snapElements=[];a(e.snap.constructor!==String?(e.snap.items||":data(ui-draggable)"):e.snap).each(function(){var g=a(this),f=g.offset();if(this!==b.element[0]){b.snapElements.push({item:this,width:g.outerWidth(),height:g.outerHeight(),top:f.top,left:f.left})}})},drag:function(u,p,g){var c,z,j,k,s,n,m,A,v,h,q=g.options,y=q.snapTolerance,x=p.offset.left,w=x+g.helperProportions.width,f=p.offset.top,e=f+g.helperProportions.height;for(v=g.snapElements.length-1;v>=0;v--){s=g.snapElements[v].left-g.margins.left;n=s+g.snapElements[v].width;m=g.snapElements[v].top-g.margins.top;A=m+g.snapElements[v].height;if(w<s-y||x>n+y||e<m-y||f>A+y||!a.contains(g.snapElements[v].item.ownerDocument,g.snapElements[v].item)){if(g.snapElements[v].snapping){(g.options.snap.release&&g.options.snap.release.call(g.element,u,a.extend(g._uiHash(),{snapItem:g.snapElements[v].item})))}g.snapElements[v].snapping=false;continue}if(q.snapMode!=="inner"){c=Math.abs(m-e)<=y;z=Math.abs(A-f)<=y;j=Math.abs(s-w)<=y;k=Math.abs(n-x)<=y;if(c){p.position.top=g._convertPositionTo("relative",{top:m-g.helperProportions.height,left:0}).top}if(z){p.position.top=g._convertPositionTo("relative",{top:A,left:0}).top}if(j){p.position.left=g._convertPositionTo("relative",{top:0,left:s-g.helperProportions.width}).left}if(k){p.position.left=g._convertPositionTo("relative",{top:0,left:n}).left}}h=(c||z||j||k);if(q.snapMode!=="outer"){c=Math.abs(m-f)<=y;z=Math.abs(A-e)<=y;j=Math.abs(s-x)<=y;k=Math.abs(n-w)<=y;if(c){p.position.top=g._convertPositionTo("relative",{top:m,left:0}).top}if(z){p.position.top=g._convertPositionTo("relative",{top:A-g.helperProportions.height,left:0}).top}if(j){p.position.left=g._convertPositionTo("relative",{top:0,left:s}).left}if(k){p.position.left=g._convertPositionTo("relative",{top:0,left:n-g.helperProportions.width}).left}}if(!g.snapElements[v].snapping&&(c||z||j||k||h)){(g.options.snap.snap&&g.options.snap.snap.call(g.element,u,a.extend(g._uiHash(),{snapItem:g.snapElements[v].item})))}g.snapElements[v].snapping=(c||z||j||k||h)}}});a.ui.plugin.add("draggable","stack",{start:function(d,e,b){var c,g=b.options,f=a.makeArray(a(g.stack)).sort(function(i,h){return(parseInt(a(i).css("zIndex"),10)||0)-(parseInt(a(h).css("zIndex"),10)||0)});if(!f.length){return}c=parseInt(a(f[0]).css("zIndex"),10)||0;a(f).each(function(h){a(this).css("zIndex",c+h)});this.css("zIndex",(c+f.length))}});a.ui.plugin.add("draggable","zIndex",{start:function(d,e,b){var c=a(e.helper),f=b.options;if(c.css("zIndex")){f._zIndex=c.css("zIndex")}c.css("zIndex",f.zIndex)},stop:function(c,d,b){var e=b.options;if(e._zIndex){a(d.helper).css("zIndex",e._zIndex)}}});return a.ui.draggable}));

 
