/*
 * Copyright (C) 2017 Marc Magon
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.jwebmp.plugins.jqueryui.draggable.interfaces;

import com.jwebmp.plugins.jqueryui.draggable.JQUIDraggableFeature;
import com.jwebmp.plugins.jqueryui.draggable.options.JQUIDraggableOptions;

/**
 * @author GedMarc
 * @since 27 Feb 2017
 */
public interface IJQUIDraggable
{

	JQUIDraggableFeature getFeature();

	/**
	 * Gets this features available options
	 * <p>
	 *
	 * @return
	 */
	JQUIDraggableOptions getOptions();

	/**
	 * Gets the scope of this Draggable object
	 * <p>
	 *
	 * @return
	 */
	String getScope();

	/**
	 * Sets the scope of this objects
	 * <p>
	 *
	 * @param scope
	 */
	void setScope(String scope);

}
