/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.logger.logging;

import com.jwebmp.logger.logging.LogFormatter;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogSingleLineFormatter
extends LogFormatter {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    @Override
    public String format(LogRecord record) {
        if (record.getMessage() == null || record.getMessage().trim().isEmpty()) {
            return "";
        }
        if (record.getMessage().contains("visiting unvisited references")) {
            return "";
        }
        String output = "";
        output = output + "[" + this.sdf.format(record.getMillis()) + "]-";
        String message = "";
        if (record.getLevel().getLocalizedName().equals(Level.FINEST.getLocalizedName())) {
            message = message + record.getMessage();
        } else if (record.getLevel().getLocalizedName().equals(Level.FINER.getLocalizedName())) {
            message = message + record.getMessage();
        } else if (record.getLevel().getLocalizedName().equals(Level.FINE.getLocalizedName())) {
            message = message + record.getMessage();
        } else if (record.getLevel().getLocalizedName().equals(Level.CONFIG.getLocalizedName())) {
            message = message + record.getMessage();
        } else if (record.getLevel().getLocalizedName().equals(Level.INFO.getLocalizedName())) {
            message = message + record.getMessage();
        } else if (record.getLevel().getLocalizedName().equals(Level.WARNING.getLocalizedName())) {
            message = message + record.getMessage();
        } else if (record.getLevel().getLocalizedName().equals(Level.SEVERE.getLocalizedName())) {
            message = message + record.getMessage();
        }
        if (message.trim().isEmpty()) {
            return "";
        }
        output = output + message;
        output = output + this.printException(record).toString();
        output = this.processParameters(output, record);
        output = output + " - ";
        output = output + "[" + record.getLevel().getLocalizedName() + "]";
        return output + System.getProperty("line.separator");
    }
}

