/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.logger;

import com.jwebmp.logger.handlers.ConsoleSTDOutputHandler;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LogFactory {
    private static ConsoleSTDOutputHandler consoleLogger = ConsoleSTDOutputHandler.getInstance();
    private static LogFactory instance = new LogFactory();
    private static boolean LogToConsole;
    private static Level DefaultLevel;

    private LogFactory() {
    }

    public static ConsoleSTDOutputHandler configureConsoleColourOutput(Level outputLevel) {
        LogFactory.setDefaultLevel(outputLevel);
        ConsoleSTDOutputHandler.getInstance().setColoured(true).setLevel(outputLevel);
        LogManager.getLogManager().getLogger("").addHandler(ConsoleSTDOutputHandler.getInstance());
        return ConsoleSTDOutputHandler.getInstance();
    }

    public static ConsoleSTDOutputHandler configureConsoleSingleLineOutput(Level outputLevel) {
        LogFactory.setDefaultLevel(outputLevel);
        ConsoleSTDOutputHandler.getInstance().setColoured(false).setLevel(outputLevel);
        LogManager.getLogManager().getLogger("").addHandler(ConsoleSTDOutputHandler.getInstance());
        return ConsoleSTDOutputHandler.getInstance();
    }

    public static Logger getLog(String name) {
        return LogFactory.getInstance().getLogger(name);
    }

    public Logger getLogger(String name) {
        Logger newLog = Logger.getLogger("com.jwebmp." + name);
        newLog.setUseParentHandlers(true);
        newLog.setLevel(DefaultLevel);
        return newLog;
    }

    public static LogFactory getInstance() {
        return instance;
    }

    public static Level getDefaultLevel() {
        return DefaultLevel == null ? Level.FINE : DefaultLevel;
    }

    public static void setDefaultLevel(Level DefaultLevel) {
        LogFactory.DefaultLevel = DefaultLevel;
        Enumeration<String> enums = LogManager.getLogManager().getLoggerNames();
        LinkedHashSet<String> newSet = new LinkedHashSet<String>();
        newSet.add("");
        while (enums.hasMoreElements()) {
            newSet.add(enums.nextElement());
        }
        for (String nextElement : newSet) {
            Logger logger = LogManager.getLogManager().getLogger(nextElement);
            if (logger == null) continue;
            for (Handler handler : logger.getHandlers()) {
                if (handler == null) continue;
                handler.setLevel(DefaultLevel);
            }
        }
    }

    public static Logger getLog(Class name) {
        return LogFactory.getInstance().getLogger(name.toString());
    }

    public static boolean isLogToConsole() {
        return LogToConsole;
    }

    public static void setLogToConsole(boolean LogToConsole) {
        LogFactory.LogToConsole = LogToConsole;
    }

    public ConsoleSTDOutputHandler getConsoleLogger() {
        return consoleLogger;
    }

    static {
        DefaultLevel = Level.FINE;
    }
}

