/*
 * Decompiled with CFR 0.152.
 */
package com.jwebmp.logger.model;

import com.jwebmp.logger.model.LogProperties;
import com.jwebmp.logger.model.LogProperty;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;

public class LogEntry {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\[(.*?)]-\\[(.*?)];");
    private static final Map<LogProperties, Boolean> displayedProperties;
    private static final List<String> exceptionHighlightedPackages;
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private Date date;
    private Level level;
    private String message;
    private List<LogProperty> properties;
    private Object data;
    private String originalSourceSystemID;

    private LogEntry(String entry, Level level) {
        this();
        this.setDate(new Date());
        this.setLevel(level);
        LogProperty props = LogProperty.newProperty("message", entry);
        this.getProperties().add(props);
    }

    private LogEntry() {
    }

    @NotNull
    public List<LogProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<LogProperty>();
        }
        return this.properties;
    }

    @NotNull
    public LogEntry setProperties(@NotNull List<LogProperty> properties) {
        this.properties = properties;
        return this;
    }

    public static LogEntry newEntry(LogRecord record) {
        LogEntry le = LogEntry.newEntry();
        le.setLevel(record.getLevel());
        Date d = new Date();
        d.setTime(record.getMillis());
        le.setDate(d);
        le.getProperties().add(LogProperty.newProperty(LogProperties.Level, LogEntry.padRight(record.getLevel().getName(), 7)));
        le.getProperties().add(LogProperty.newProperty(LogProperties.Date, le.dateFormatter.format(d)));
        le.getProperties().add(LogProperty.newProperty(LogProperties.Message, record.getMessage()));
        le.getProperties().add(LogProperty.newProperty(LogProperties.Name, record.getLoggerName()));
        le.getProperties().add(LogProperty.newProperty(LogProperties.Class, record.getSourceClassName()));
        le.getProperties().add(LogProperty.newProperty(LogProperties.Method, record.getSourceMethodName()));
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                thrown.printStackTrace(pw);
                pw.flush();
                String exceptionString = sw.toString();
                le.getProperties().add(LogProperty.newProperty(LogProperties.Exception, exceptionString));
            }
            try {
                sw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(LogEntry.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        le.setMessage(record.getMessage());
        return le;
    }

    public static LogEntry newEntry() {
        LogEntry entry = new LogEntry();
        entry.setDate(new Date());
        entry.setLevel(Level.INFO);
        return entry;
    }

    public static String padRight(String s, int n) {
        return String.format("%-" + n + "s", s);
    }

    public Map<String, String> getPropertiesFromMessage(String message) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (!this.isParameterMessage()) {
            return props;
        }
        Matcher m = PROPERTY_PATTERN.matcher(message);
        while (m.find()) {
            props.put(m.group(1), m.group(2));
        }
        return props;
    }

    private boolean isParameterMessage() {
        Matcher m = PROPERTY_PATTERN.matcher(this.message);
        return m.groupCount() > 0;
    }

    public static String padLeft(String s, int n) {
        return String.format("%1$" + n + "s", s);
    }

    public static Pattern getPropertyPattern() {
        return PROPERTY_PATTERN;
    }

    public static Map<LogProperties, Boolean> getDisplayedProperties() {
        return displayedProperties;
    }

    public static List<String> getExceptionHighlightedPackages() {
        return exceptionHighlightedPackages;
    }

    public SimpleDateFormat getDateFormatter() {
        return this.dateFormatter;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getProperties().isEmpty() && !this.getMessage().isEmpty()) {
            sb.append("[").append(LogEntry.padRight(this.getLevel().getName(), 7)).append("];[").append(this.dateFormatter.format(this.getDate())).append("];");
            if (this.getData() != null) {
                sb.append(";[Data]-[").append(this.getData()).append("];");
            }
            sb.append("[").append(this.getMessage()).append("];");
        } else if (!this.getProperties().isEmpty()) {
            this.getProperties().forEach(sb::append);
        }
        return sb.toString();
    }

    public String getMessage() {
        if (this.message == null) {
            this.message = "";
        }
        return this.message;
    }

    public Level getLevel() {
        return this.level;
    }

    public LogEntry setLevel(Level level) {
        this.level = level;
        return this;
    }

    public Date getDate() {
        return this.date;
    }

    public Object getData() {
        return this.data;
    }

    public LogEntry setData(Object data) {
        this.data = data;
        return this;
    }

    public LogEntry setDate(Date date) {
        this.date = date;
        return this;
    }

    public LogEntry setMessage(String message) {
        this.message = message;
        this.getPropertiesFromMessage(this.message).forEach((key, value) -> this.getProperties().add(LogProperty.newProperty(key, value)));
        return this;
    }

    @NotNull
    public String getOriginalSourceSystemID() {
        if (this.originalSourceSystemID == null) {
            this.originalSourceSystemID = "";
        }
        return this.originalSourceSystemID;
    }

    public LogEntry setOriginalSourceSystemID(String originalSourceSystemID) {
        this.originalSourceSystemID = originalSourceSystemID;
        return this;
    }

    public LogProperty getProperty(String name) {
        for (LogProperty next : this.properties) {
            if (!next.getPropertyName().equalsIgnoreCase(name)) continue;
            return next;
        }
        return null;
    }

    static {
        exceptionHighlightedPackages = new ArrayList<String>();
        displayedProperties = new EnumMap<LogProperties, Boolean>(LogProperties.class);
    }
}

