package com.kyleu.projectile.models.web

import com.kyleu.projectile.util.Logging
import javax.inject.Inject
import play.api.OptionalDevContext
import play.api.http._
import play.api.mvc.RequestHeader
import play.api.routing.Router
import play.core.{DefaultWebCommands, WebCommands}

class RequestHandler @Inject() (
    webCommands: WebCommands,
    optionalDevContext: OptionalDevContext,
    errorHandler: HttpErrorHandler,
    configuration: HttpConfiguration,
    router: Router,
    filters: HttpFilters
) extends DefaultHttpRequestHandler(new DefaultWebCommands, None, router, errorHandler, configuration, filters.filters) with Logging {

  override def routeRequest(request: RequestHeader) = {
    if (!Option(request.path).exists(LoggingFilter.skipPath)) {
      // log.info(s"Request from [${request.remoteAddress}]: ${request.toString()}")(TraceData.noop)
    }
    super.routeRequest(request)
  }
}
