/*
 * Decompiled with CFR 0.152.
 */
package com.kyleu.projectile.services.database;

import com.kyleu.projectile.models.database.DatabaseConfig;
import com.kyleu.projectile.models.database.DatabaseConfig$;
import com.kyleu.projectile.models.database.Query;
import com.kyleu.projectile.models.database.RawQuery;
import com.kyleu.projectile.models.database.Statement;
import com.kyleu.projectile.models.database.jdbc.Queryable;
import com.kyleu.projectile.services.database.Database;
import com.kyleu.projectile.util.Logging;
import com.kyleu.projectile.util.tracing.TraceData;
import com.kyleu.projectile.util.tracing.TracingService;
import com.typesafe.config.Config;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Connection;
import java.util.Properties;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005=e!\u0002\t\u0012\u0003\u0003a\u0002\u0002\u0003\u001d\u0001\u0005\u000b\u0007I\u0011I\u001d\t\u0011\u0015\u0003!\u0011!Q\u0001\niB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0006\u000f\u0002!\t\u0001\u0013\u0005\b\u0019\u0002\u0011\r\u0011\"\u0005:\u0011\u0019i\u0005\u0001)A\u0005u!1a\n\u0001Q\u0005\n=CaA\u001a\u0001!B\u00139\u0007\"\u0002:\u0001\t\u0003\u0019\b\"\u0002;\u0001\t\u0003)\bbBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003s\u0001A\u0011IA\u001e\u0011\u001d\tI\u0006\u0001C!\u00037Bq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002\u0006\u0002!\t%a\"\u0003\u0019)#'m\u0019#bi\u0006\u0014\u0017m]3\u000b\u0005I\u0019\u0012\u0001\u00033bi\u0006\u0014\u0017m]3\u000b\u0005Q)\u0012\u0001C:feZL7-Z:\u000b\u0005Y9\u0012A\u00039s_*,7\r^5mK*\u0011\u0001$G\u0001\u0006WfdW-\u001e\u0006\u00025\u0005\u00191m\\7\u0004\u0001M!\u0001!H\u00120!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fMB\u0019A%J\u0014\u000e\u0003EI!AJ\t\u0003\u0011\u0011\u000bG/\u00192bg\u0016\u0004\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\u0007M\fHNC\u0001-\u0003\u0011Q\u0017M^1\n\u00059J#AC\"p]:,7\r^5p]B\u0011\u0001GN\u0007\u0002c)\u0011!gM\u0001\u0005U\u0012\u00147M\u0003\u0002\u0013i)\u0011Q'F\u0001\u0007[>$W\r\\:\n\u0005]\n$!C)vKJL\u0018M\u00197f\u0003\rYW-_\u000b\u0002uA\u00111H\u0011\b\u0003y\u0001\u0003\"!P\u0010\u000e\u0003yR!aP\u000e\u0002\rq\u0012xn\u001c;?\u0013\t\tu$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u0013aa\u0015;sS:<'BA! \u0003\u0011YW-\u001f\u0011\u0002\u0019\r|gNZ5h!J,g-\u001b=\u0002\rqJg.\u001b;?)\rI%j\u0013\t\u0003I\u0001AQ\u0001\u000f\u0003A\u0002iBQA\u0012\u0003A\u0002i\n\u0011\"\\3ue&\u001c7/\u00133\u0002\u00155,GO]5dg&#\u0007%\u0001\u0003uS6,WC\u0001)U)\r\t&\r\u001a\u000b\u0003%v\u0003\"a\u0015+\r\u0001\u0011)Qk\u0002b\u0001-\n\t\u0011)\u0005\u0002X5B\u0011a\u0004W\u0005\u00033~\u0011qAT8uQ&tw\r\u0005\u0002\u001f7&\u0011Al\b\u0002\u0004\u0003:L\bB\u00020\b\t\u0003\u0007q,A\u0001g!\rq\u0002MU\u0005\u0003C~\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\u0006G\u001e\u0001\rAO\u0001\u0007[\u0016$\bn\u001c3\t\u000b\u0015<\u0001\u0019\u0001\u001e\u0002\t9\fW.Z\u0001\u0003IN\u00042A\b5k\u0013\tIwD\u0001\u0004PaRLwN\u001c\t\u0003WBl\u0011\u0001\u001c\u0006\u0003[:\fa\u0001[5lCJL'BA8\u001a\u0003\u0019Q\u0018\r\u001f=fe&\u0011\u0011\u000f\u001c\u0002\u0011\u0011&\\\u0017M]5ECR\f7k\\;sG\u0016\faa]8ve\u000e,W#\u00016\u0002\t=\u0004XM\u001c\u000b\u0005mf\f9\u0001\u0005\u0002\u001fo&\u0011\u0001p\b\u0002\u0005+:LG\u000fC\u0003{\u0015\u0001\u000710A\u0002dM\u001e\u00042\u0001`A\u0002\u001b\u0005i(B\u0001@\u0000\u0003\u0019\u0019wN\u001c4jO*\u0019\u0011\u0011A\r\u0002\u0011QL\b/Z:bM\u0016L1!!\u0002~\u0005\u0019\u0019uN\u001c4jO\"9\u0011\u0011\u0002\u0006A\u0002\u0005-\u0011aA:wGB!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011a\u0002;sC\u000eLgn\u001a\u0006\u0004\u0003+)\u0012\u0001B;uS2LA!!\u0007\u0002\u0010\tqAK]1dS:<7+\u001a:wS\u000e,\u0017a\u0003;sC:\u001c\u0018m\u0019;j_:,B!a\b\u0002&Q!\u0011\u0011EA\u0019)\u0011\t\u0019#a\n\u0011\u0007M\u000b)\u0003B\u0003V\u0017\t\u0007a\u000bC\u0004\u0002*-\u0001\u001d!a\u000b\u0002\u0013Q\u0014\u0018mY3ECR\f\u0007\u0003BA\u0007\u0003[IA!a\f\u0002\u0010\tIAK]1dK\u0012\u000bG/\u0019\u0005\u0007=.\u0001\r!a\r\u0011\u0011y\t)$a\u000b(\u0003GI1!a\u000e \u0005%1UO\\2uS>t''A\u0004fq\u0016\u001cW\u000f^3\u0015\r\u0005u\u0012qIA*)\u0011\ty$!\u0012\u0011\u0007y\t\t%C\u0002\u0002D}\u00111!\u00138u\u0011\u001d\tI\u0003\u0004a\u0002\u0003WAq!!\u0013\r\u0001\u0004\tY%A\u0005ti\u0006$X-\\3oiB!\u0011QJA(\u001b\u0005\u0019\u0014bAA)g\tI1\u000b^1uK6,g\u000e\u001e\u0005\n\u0003+b\u0001\u0013!a\u0001\u0003/\nAaY8o]B\u0019a\u0004[\u0014\u0002\u000bE,XM]=\u0016\t\u0005u\u00131\r\u000b\u0007\u0003?\n9'a\u001c\u0015\t\u0005\u0005\u0014Q\r\t\u0004'\u0006\rD!B+\u000e\u0005\u00041\u0006bBA\u0015\u001b\u0001\u000f\u00111\u0006\u0005\b\u00033j\u0001\u0019AA5!\u0019\ti%a\u001b\u0002b%\u0019\u0011QN\u001a\u0003\u0011I\u000bw/U;fefD\u0011\"!\u0016\u000e!\u0003\u0005\r!a\u0016\u0002\u001d]LG\u000f[\"p]:,7\r^5p]V!\u0011QOA=)\u0011\t9(! \u0011\u0007M\u000bI\b\u0002\u0004\u0002|9\u0011\rA\u0016\u0002\u0002)\"1aL\u0004a\u0001\u0003\u007f\u0002bAHAAO\u0005]\u0014bAAB?\tIa)\u001e8di&|g.M\u0001\u0006G2|7/\u001a\u000b\u0003\u0003\u0013\u00032AHAF\u0013\r\tii\b\u0002\b\u0005>|G.Z1o\u0001")
public abstract class JdbcDatabase
implements Database<Connection>,
Queryable {
    private final String key;
    private final String configPrefix;
    private final String metricsId;
    private Option<HikariDataSource> ds;
    private Option<TracingService> com$kyleu$projectile$services$database$Database$$tracingServiceOpt;
    private Option<DatabaseConfig> com$kyleu$projectile$services$database$Database$$config;
    private Logging.TraceLogger log;
    private volatile boolean bitmap$0;
    private volatile byte bitmap$init$0;

    @Override
    public Object valForJdbc(Connection conn, Object v) {
        return Queryable.valForJdbc$(this, conn, v);
    }

    @Override
    public IndexedSeq<Object> valsForJdbc(Connection conn, Seq<Object> vals) {
        return Queryable.valsForJdbc$(this, conn, vals);
    }

    @Override
    public <A> A apply(Connection connection, RawQuery<A> query) {
        return (A)Queryable.apply$(this, connection, query);
    }

    @Override
    public int executeUpdate(Connection connection, Statement statement) {
        return Queryable.executeUpdate$(this, connection, statement);
    }

    @Override
    public <A> Either<A, Object> executeUnknown(Connection connection, Query<A> query, Option<UUID> resultId) {
        return Queryable.executeUnknown$(this, connection, query, resultId);
    }

    @Override
    public Option<Connection> execute$default$2() {
        return Database.execute$default$2$(this);
    }

    @Override
    public Future<Object> executeF(Statement statement, Option<Connection> conn, TraceData traceData) {
        return Database.executeF$(this, statement, conn, traceData);
    }

    @Override
    public Option<Connection> executeF$default$2() {
        return Database.executeF$default$2$(this);
    }

    @Override
    public <A> Option<Connection> query$default$2() {
        return Database.query$default$2$(this);
    }

    @Override
    public <A> Future<A> queryF(RawQuery<A> q, Option<Connection> conn, TraceData traceData) {
        return Database.queryF$(this, q, conn, traceData);
    }

    @Override
    public <A> Option<Connection> queryF$default$2() {
        return Database.queryF$default$2$(this);
    }

    @Override
    public TracingService tracing() {
        return Database.tracing$(this);
    }

    @Override
    public DatabaseConfig getConfig() {
        return Database.getConfig$(this);
    }

    @Override
    public void start(DatabaseConfig cfg, TracingService svc) {
        Database.start$(this, cfg, svc);
    }

    @Override
    public String prependComment(Object obj, String sql) {
        return Database.prependComment$(this, obj, sql);
    }

    @Override
    public <A> A trace(String traceName, Function1<TraceData, A> f, TraceData traceData) {
        return (A)Database.trace$(this, traceName, f, traceData);
    }

    @Override
    public Option<TracingService> com$kyleu$projectile$services$database$Database$$tracingServiceOpt() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/kyle/Projects/Personal/projectile/libraries/projectile-lib-jdbc/src/main/scala/com/kyleu/projectile/services/database/JdbcDatabase.scala: 13");
        }
        return this.com$kyleu$projectile$services$database$Database$$tracingServiceOpt;
    }

    @Override
    public void com$kyleu$projectile$services$database$Database$$tracingServiceOpt_$eq(Option<TracingService> x$1) {
        this.com$kyleu$projectile$services$database$Database$$tracingServiceOpt = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    @Override
    public Option<DatabaseConfig> com$kyleu$projectile$services$database$Database$$config() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/kyle/Projects/Personal/projectile/libraries/projectile-lib-jdbc/src/main/scala/com/kyleu/projectile/services/database/JdbcDatabase.scala: 13");
        }
        return this.com$kyleu$projectile$services$database$Database$$config;
    }

    @Override
    public void com$kyleu$projectile$services$database$Database$$config_$eq(Option<DatabaseConfig> x$1) {
        this.com$kyleu$projectile$services$database$Database$$config = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    private Logging.TraceLogger log$lzycompute() {
        JdbcDatabase jdbcDatabase = this;
        synchronized (jdbcDatabase) {
            if (!this.bitmap$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.log;
    }

    public Logging.TraceLogger log() {
        return !this.bitmap$0 ? this.log$lzycompute() : this.log;
    }

    @Override
    public String key() {
        return this.key;
    }

    public String metricsId() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/kyle/Projects/Personal/projectile/libraries/projectile-lib-jdbc/src/main/scala/com/kyleu/projectile/services/database/JdbcDatabase.scala: 14");
        }
        return this.metricsId;
    }

    private <A> A time(String method, String name, Function0<A> f) {
        return (A)f.apply();
    }

    public HikariDataSource source() {
        return (HikariDataSource)this.ds.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Database not initialized");
        });
    }

    public void open(Config cfg, TracingService svc) {
        this.ds.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            throw new IllegalStateException("Database already initialized");
        });
        Class.forName("org.postgresql.Driver");
        DatabaseConfig config = DatabaseConfig$.MODULE$.fromConfig(cfg, this.configPrefix);
        Properties properties = new Properties();
        int maxPoolSize = 32;
        HikariConfig poolConfig = new HikariConfig(this, properties, config, maxPoolSize){
            {
                this.setPoolName($outer.key());
                this.setJdbcUrl(config$1.url());
                this.setUsername(config$1.username());
                this.setPassword((String)config$1.password().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
                this.setConnectionTimeout(10000L);
                this.setMinimumIdle(1);
                this.setMaximumPoolSize(maxPoolSize$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1()}, serializedLambda);
            }
        };
        HikariDataSource poolDataSource = new HikariDataSource(poolConfig);
        this.ds = new Some((Object)poolDataSource);
        this.start(config, svc);
    }

    @Override
    public <A> A transaction(Function2<TraceData, Connection, A> f, TraceData traceData) {
        return this.trace("transaction", (Function1 & Serializable & scala.Serializable)td -> {
            Object object;
            connection.setAutoCommit(false);
            try (Connection connection = this.source().getConnection();){
                try {
                    Object result = f.apply(td, (Object)connection);
                    connection.commit();
                    object = result;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable x = (Throwable)option.get();
                        connection.rollback();
                        throw x;
                    }
                    throw throwable;
                }
            }
            return object;
        }, traceData);
    }

    @Override
    public int execute(Statement statement, Option<Connection> conn, TraceData traceData) {
        return BoxesRunTime.unboxToInt(this.trace(new StringBuilder(8).append("execute.").append(statement.name()).toString(), (Function1 & Serializable & scala.Serializable)td -> BoxesRunTime.boxToInteger((int)JdbcDatabase.$anonfun$execute$1(this, statement, conn, traceData, td)), traceData));
    }

    @Override
    public <A> A query(RawQuery<A> query, Option<Connection> conn, TraceData traceData) {
        return this.trace(new StringBuilder(6).append("query.").append(query.name()).toString(), (Function1 & Serializable & scala.Serializable)td -> {
            Object a;
            td.tag("SQL", query.sql());
            Connection connection = (Connection)conn.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.source().getConnection());
            try {
                try {
                    a = this.time("query", query.getClass().getName(), (Function0 & Serializable & scala.Serializable)() -> this.apply(connection, query));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable x = (Throwable)option.get();
                        String v = query.values().mkString(", ");
                        this.log().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Error running query [").append(query.name()).append("] with [").append(query.values().size()).append("] values and sql [").append(query.sql()).append("] (Values: ").append(v).append(")").toString(), (Function0 & Serializable & scala.Serializable)() -> x, traceData);
                        throw x;
                    }
                    throw throwable;
                }
            }
            finally {
                if (conn.isEmpty()) {
                    connection.close();
                }
            }
            return a;
        }, traceData);
    }

    public <T> T withConnection(Function1<Connection, T> f) {
        Object object;
        try (Connection conn = this.source().getConnection();){
            object = f.apply((Object)conn);
        }
        return (T)object;
    }

    @Override
    public boolean close() {
        this.ds.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.ds = None$.MODULE$;
        return true;
    }

    public static final /* synthetic */ int $anonfun$execute$1(JdbcDatabase $this, Statement statement$1, Option conn$1, TraceData traceData$1, TraceData td) {
        int n;
        td.tag("SQL", statement$1.sql());
        Connection connection = (Connection)conn$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.source().getConnection());
        try {
            try {
                n = BoxesRunTime.unboxToInt($this.time("execute", statement$1.getClass().getName(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.executeUpdate(connection, statement$1)));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable x = (Throwable)option.get();
                    String v = statement$1.values().mkString(", ");
                    $this.log().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Error executing [").append(statement$1.name()).append("] with [").append(statement$1.values().size()).append("] values and sql [").append(statement$1.sql()).append("] (Values: ").append(v).append(")").toString(), (Function0 & Serializable & scala.Serializable)() -> x, traceData$1);
                    throw x;
                }
                throw throwable;
            }
        }
        finally {
            if (conn$1.isEmpty()) {
                connection.close();
            }
        }
        return n;
    }

    public JdbcDatabase(String key, String configPrefix) {
        this.key = key;
        this.configPrefix = configPrefix;
        Logging.$init$((Logging)this);
        Database.$init$(this);
        Queryable.$init$(this);
        this.metricsId = new StringBuilder(9).append(key).append("_database").toString();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.ds = None$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

