/*
 * Decompiled with CFR 0.152.
 */
package com.kyleu.projectile.services.socket;

import boopickle.Pickler;
import com.kyleu.projectile.services.socket.EventHandler;
import com.kyleu.projectile.util.ArrayBufferOps$;
import com.kyleu.projectile.util.BinarySerializers$;
import com.kyleu.projectile.util.JsonSerializers$;
import io.circe.Decoder;
import io.circe.Error;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.scalajs.dom.raw.Blob;
import org.scalajs.dom.raw.Event;
import org.scalajs.dom.raw.FileReader;
import org.scalajs.dom.raw.MessageEvent;
import org.scalajs.dom.raw.ProgressEvent;
import org.scalajs.dom.raw.WebSocket;
import org.scalajs.dom.raw.WebSocket$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.scalajs.js.Any;
import scala.scalajs.js.Function1;
import scala.scalajs.js.typedarray.ArrayBuffer;
import scala.scalajs.js.typedarray.TypedArrayBuffer$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001\u0002\f\u0018\u0001\tB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tu\u0001\u0011\u0019\u0011)A\u0006w!Aq\n\u0001B\u0002B\u0003-\u0001\u000bC\u0003[\u0001\u0011\u00051\f\u0003\u0004b\u0001\u0001\u0006KA\u0019\u0005\u0007K\u0002\u0001\u000b\u0015\u00022\t\r\u0019\u0004\u0001\u0015)\u0003h\u0011\u00191\b\u0001)Q\u0005o\"1!\u0010\u0001Q!\n]Daa\u001f\u0001!B\u00139\bB\u0002?\u0001A\u0003&q\u000fC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002\u0002CA\u001d\u0001\u0001&I!a\u000f\t\u0011\u0005}\u0002\u0001)C\u0005\u0003\u0003B\u0001\"!\u0014\u0001A\u0013%\u0011q\n\u0005\t\u0003'\u0002\u0001\u0015\"\u0003\u0002V!A\u00111\f\u0001!\n\u0013\ti\u0006\u0003\u0005\u0002h\u0001\u0001K\u0011BA5\u00055qU\r^<pe.\u001cvnY6fi*\u0011\u0001$G\u0001\u0007g>\u001c7.\u001a;\u000b\u0005iY\u0012\u0001C:feZL7-Z:\u000b\u0005qi\u0012A\u00039s_*,7\r^5mK*\u0011adH\u0001\u0006WfdW-\u001e\u0006\u0002A\u0005\u00191m\\7\u0004\u0001U\u00111%M\n\u0003\u0001\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0017a\u00025b]\u0012dWM\u001d\t\u0004Y5zS\"A\f\n\u00059:\"\u0001D#wK:$\b*\u00198eY\u0016\u0014\bC\u0001\u00192\u0019\u0001!QA\r\u0001C\u0002M\u0012\u0011\u0001V\t\u0003i]\u0002\"!J\u001b\n\u0005Y2#a\u0002(pi\"Lgn\u001a\t\u0003KaJ!!\u000f\u0014\u0003\u0007\u0005s\u00170\u0001\u0006fm&$WM\\2fIE\u00022\u0001\u0010'0\u001d\ti\u0014J\u0004\u0002?\u000f:\u0011qH\u0012\b\u0003\u0001\u0016s!!\u0011#\u000e\u0003\tS!aQ\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0013B\u0001\u0010 \u0013\taR$\u0003\u0002I7\u0005!Q\u000f^5m\u0013\tQ5*A\bKg>t7+\u001a:jC2L'0\u001a:t\u0015\tA5$\u0003\u0002N\u001d\n9A)Z2pI\u0016\u0014(B\u0001&L\u0003))g/\u001b3f]\u000e,GE\r\t\u0004#R{cBA\u001fS\u0013\t\u00196*A\tCS:\f'/_*fe&\fG.\u001b>feNL!!\u0016,\u0003\u000fAK7m\u001b7fe&\u0011q\u000b\u0017\u0002\u0005\u0005\u0006\u001cXMC\u0001Z\u0003%\u0011wn\u001c9jG.dW-\u0001\u0004=S:LGO\u0010\u000b\u00039\u0002$2!\u00180`!\ra\u0003a\f\u0005\u0006u\u0011\u0001\u001da\u000f\u0005\u0006\u001f\u0012\u0001\u001d\u0001\u0015\u0005\u0006U\u0011\u0001\raK\u0001\u000bG>tg.Z2uS:<\u0007CA\u0013d\u0013\t!gEA\u0004C_>dW-\u00198\u0002\u0013\r|gN\\3di\u0016$\u0017AA<t!\r)\u0003N[\u0005\u0003S\u001a\u0012aa\u00149uS>t\u0007CA6u\u001b\u0005a'BA7o\u0003\r\u0011\u0018m\u001e\u0006\u0003_B\f1\u0001Z8n\u0015\t\t(/A\u0004tG\u0006d\u0017M[:\u000b\u0003M\f1a\u001c:h\u0013\t)HNA\u0005XK\n\u001cvnY6fi\u0006\u00012/\u001a8u\u001b\u0016\u001c8/Y4f\u0007>,h\u000e\u001e\t\u0003KaL!!\u001f\u0014\u0003\u0007%sG/A\u0005tK:$()\u001f;fg\u0006!\"/Z2fSZ,G-T3tg\u0006<WmQ8v]R\fQB]3dK&4X\r\u001a\"zi\u0016\u001c\u0018\u0001B8qK:$2a`A\u0003!\r)\u0013\u0011A\u0005\u0004\u0003\u00071#\u0001B+oSRDq!a\u0002\r\u0001\u0004\tI!A\u0002ve2\u0004B!a\u0003\u0002\u00149!\u0011QBA\b!\t\te%C\u0002\u0002\u0012\u0019\na\u0001\u0015:fI\u00164\u0017\u0002BA\u000b\u0003/\u0011aa\u0015;sS:<'bAA\tM\u0005Q1/\u001a8e'R\u0014\u0018N\\4\u0015\u0007}\fi\u0002C\u0004\u0002 5\u0001\r!!\u0003\u0002\u0003M\f!b]3oI\nKg.\u0019:z)\ry\u0018Q\u0005\u0005\b\u0003Oq\u0001\u0019AA\u0015\u0003\u0011!\u0017\r^1\u0011\u000b\u0015\nY#a\f\n\u0007\u00055bEA\u0003BeJ\f\u0017\u0010E\u0002&\u0003cI1!a\r'\u0005\u0011\u0011\u0015\u0010^3\u0002\u0017%\u001c8i\u001c8oK\u000e$X\rZ\u000b\u0002E\u0006Qq\u000e]3o'>\u001c7.\u001a;\u0015\u0007}\fi\u0004C\u0004\u0002\bA\u0001\r!!\u0003\u0002\u001d=t7i\u001c8oK\u000e$XI^3oiR!\u00111IA%!\rY\u0017QI\u0005\u0004\u0003\u000fb'!B#wK:$\bbBA&#\u0001\u0007\u00111I\u0001\u0006KZ,g\u000e^\u0001\r_:,%O]8s\u000bZ,g\u000e\u001e\u000b\u0005\u0003\u0007\n\t\u0006C\u0004\u0002LI\u0001\r!a\u0011\u0002\u000fA\u0014xnY3tgR\u0019q0a\u0016\t\r\u0005e3\u00031\u00010\u0003\ri7oZ\u0001\u000f_:lUm]:bO\u0016,e/\u001a8u)\ry\u0018q\f\u0005\b\u0003\u0017\"\u0002\u0019AA1!\rY\u00171M\u0005\u0004\u0003Kb'\u0001D'fgN\fw-Z#wK:$\u0018\u0001D8o\u00072|7/Z#wK:$H\u0003BA\"\u0003WBq!a\u0013\u0016\u0001\u0004\t\u0019\u0005")
public class NetworkSocket<T> {
    private final EventHandler<T> handler;
    private final Decoder<T> evidence$1;
    private final Pickler<T> evidence$2;
    private boolean connecting;
    private boolean connected;
    private Option<WebSocket> ws;
    private int sentMessageCount;
    private int sentBytes;
    private int receivedMessageCount;
    private int receivedBytes;
    private volatile byte bitmap$init$0;

    public void open(String url) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (this.connecting) {
            throw new IllegalStateException("Already connecting");
        }
        this.openSocket(url);
    }

    public void sendString(String s) {
        WebSocket socket = (WebSocket)this.ws.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("No available socket connection");
        });
        ++this.sentMessageCount;
        this.sentBytes += s.getBytes().length;
        socket.send(s);
    }

    public void sendBinary(byte[] data) {
        WebSocket socket = (WebSocket)this.ws.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("No available socket connection");
        });
        ++this.sentMessageCount;
        this.sentBytes += data.length;
        socket.send(ArrayBufferOps$.MODULE$.convertBuffer(ByteBuffer.wrap(data)));
    }

    public boolean isConnected() {
        return this.connected;
    }

    private void openSocket(String url) {
        this.connecting = true;
        WebSocket socket = new WebSocket(url, WebSocket$.MODULE$.$lessinit$greater$default$2());
        socket.onopen_$eq((Function1)new Function1<Event, Event>(this){
            private final /* synthetic */ NetworkSocket $outer;

            public final Event apply(Event arg1) {
                return this.$outer.com$kyleu$projectile$services$socket$NetworkSocket$$$anonfun$openSocket$1(arg1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super((Seq)Nil$.MODULE$);
            }
        });
        socket.onerror_$eq((Function1)new Function1<Event, Event>(this){
            private final /* synthetic */ NetworkSocket $outer;

            public final Event apply(Event arg1) {
                return this.$outer.com$kyleu$projectile$services$socket$NetworkSocket$$$anonfun$openSocket$3(arg1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super((Seq)Nil$.MODULE$);
            }
        });
        socket.onmessage_$eq((Function1)new Function1<MessageEvent, BoxedUnit>(this){
            private final /* synthetic */ NetworkSocket $outer;

            public final void apply(MessageEvent arg1) {
                this.$outer.com$kyleu$projectile$services$socket$NetworkSocket$$$anonfun$openSocket$5(arg1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super((Seq)Nil$.MODULE$);
            }
        });
        socket.onclose_$eq((Function1)new Function1<Event, Event>(this){
            private final /* synthetic */ NetworkSocket $outer;

            public final Event apply(Event arg1) {
                return this.$outer.com$kyleu$projectile$services$socket$NetworkSocket$$$anonfun$openSocket$7(arg1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super((Seq)Nil$.MODULE$);
            }
        });
        this.ws = new Some((Object)socket);
    }

    private Event onConnectEvent(Event event) {
        this.connecting = false;
        this.connected = true;
        this.handler.onConnect();
        return event;
    }

    private Event onErrorEvent(Event event) {
        this.handler.onError(event);
        return event;
    }

    private void process(T msg) {
        ++this.receivedMessageCount;
        this.handler.onMessage(msg);
    }

    private void onMessageEvent(MessageEvent event) {
        Object object = event.data();
        if (object instanceof String) {
            Object x;
            String string = (String)object;
            this.receivedBytes += string.getBytes().length;
            Either either = JsonSerializers$.MODULE$.decodeJson(string, this.evidence$1);
            if (!(either instanceof Right)) {
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Error err = (Error)left.value();
                    throw err;
                }
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            Object object2 = x = right.value();
            this.process(object2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Blob) {
            Blob blob = (Blob)object;
            FileReader reader = new FileReader();
            reader.onloadend_$eq((Function1)new Function1<ProgressEvent, BoxedUnit>(this, reader){
                private final /* synthetic */ NetworkSocket $outer;
                private final FileReader reader$1;

                public final void apply(ProgressEvent arg1) {
                    this.$outer.com$kyleu$projectile$services$socket$NetworkSocket$$$anonfun$onMessageEvent$1(arg1, this.reader$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.reader$1 = reader$1;
                    super((Seq)Nil$.MODULE$);
                }
            });
            reader.readAsArrayBuffer(blob);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof ArrayBuffer) {
            ArrayBuffer arrayBuffer = (ArrayBuffer)object;
            ByteBuffer data = TypedArrayBuffer$.MODULE$.wrap(arrayBuffer);
            this.process(BinarySerializers$.MODULE$.read(data, this.evidence$2));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalStateException(new StringBuilder(33).append("Unhandled message data of type [").append(object).append("]").toString());
        }
    }

    private Event onCloseEvent(Event event) {
        this.connecting = false;
        this.connected = false;
        this.handler.onClose();
        return event;
    }

    public final /* synthetic */ Event com$kyleu$projectile$services$socket$NetworkSocket$$$anonfun$openSocket$1(Event event) {
        return this.onConnectEvent(event);
    }

    public final /* synthetic */ Event com$kyleu$projectile$services$socket$NetworkSocket$$$anonfun$openSocket$3(Event event) {
        return this.onErrorEvent(event);
    }

    public final /* synthetic */ void com$kyleu$projectile$services$socket$NetworkSocket$$$anonfun$openSocket$5(MessageEvent event) {
        this.onMessageEvent(event);
    }

    public final /* synthetic */ Event com$kyleu$projectile$services$socket$NetworkSocket$$$anonfun$openSocket$7(Event event) {
        return this.onCloseEvent(event);
    }

    private final void onLoadEnd$1(ProgressEvent ev, FileReader reader$1) {
        Any buff = reader$1.result();
        ArrayBuffer ab = (ArrayBuffer)buff;
        ByteBuffer data = TypedArrayBuffer$.MODULE$.wrap(ab);
        this.receivedBytes += ab.byteLength();
        Object msg = BinarySerializers$.MODULE$.read(data, this.evidence$2);
        this.process(msg);
    }

    public final /* synthetic */ void com$kyleu$projectile$services$socket$NetworkSocket$$$anonfun$onMessageEvent$1(ProgressEvent ev, FileReader reader$1) {
        this.onLoadEnd$1(ev, reader$1);
    }

    public NetworkSocket(EventHandler<T> handler, Decoder<T> evidence$1, Pickler<T> evidence$2) {
        this.handler = handler;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.connecting = false;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.connected = false;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.ws = None$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.sentMessageCount = 0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.sentBytes = 0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
        this.receivedMessageCount = 0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x20);
        this.receivedBytes = 0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x40);
    }
}

