/*
 * Decompiled with CFR 0.152.
 */
package com.kyleu.projectile.util.metrics;

import com.kyleu.projectile.util.Logging;
import com.kyleu.projectile.util.NullUtils$;
import com.kyleu.projectile.util.tracing.TraceData;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.statsd.StatsdConfig;
import io.micrometer.statsd.StatsdFlavor;
import io.micrometer.statsd.StatsdMeterRegistry;
import io.micrometer.statsd.StatsdProtocol;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class Instrumented$
implements Logging {
    public static final Instrumented$ MODULE$ = new Instrumented$();
    private static Option<MeterRegistry> registry;
    private static Logging.TraceLogger log;
    private static volatile boolean bitmap$0;
    private static volatile boolean bitmap$init$0;

    static {
        Logging.$init$((Logging)MODULE$);
        registry = None$.MODULE$;
        bitmap$init$0 = true;
    }

    private Logging.TraceLogger log$lzycompute() {
        Instrumented$ instrumented$ = this;
        synchronized (instrumented$) {
            if (!bitmap$0) {
                log = Logging.log$((Logging)this);
                bitmap$0 = true;
            }
        }
        return log;
    }

    public Logging.TraceLogger log() {
        return !bitmap$0 ? this.log$lzycompute() : log;
    }

    private String cn(Object x) {
        return StringOps$.MODULE$.replaceAllLiterally$extension(Predef$.MODULE$.augmentString(x.getClass().getSimpleName()), "$", "");
    }

    public MeterRegistry reg() {
        return (MeterRegistry)registry.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Not started");
        });
    }

    public Option<MeterRegistry> regOpt() {
        return registry;
    }

    public void start(String engine, String serviceName, String hostAddress, TraceData td) {
        PrometheusMeterRegistry prometheusMeterRegistry;
        String string = engine;
        boolean bl = "datadog".equals(string) ? true : "statsd".equals(string);
        if (bl) {
            StatsdConfig config = new StatsdConfig(hostAddress){
                private final String hostAddress$1;

                public String prefix() {
                    return super.prefix();
                }

                public boolean enabled() {
                    return super.enabled();
                }

                public int port() {
                    return super.port();
                }

                public StatsdProtocol protocol() {
                    return super.protocol();
                }

                public int maxPacketLength() {
                    return super.maxPacketLength();
                }

                public Duration pollingFrequency() {
                    return super.pollingFrequency();
                }

                @Deprecated
                public int queueSize() {
                    return super.queueSize();
                }

                public Duration step() {
                    return super.step();
                }

                public boolean publishUnchangedMeters() {
                    return super.publishUnchangedMeters();
                }

                public boolean buffered() {
                    return super.buffered();
                }

                public String get(String k) {
                    String string;
                    String string2 = k;
                    if ("statsd.host".equals(string2)) {
                        string = this.hostAddress$1;
                    } else {
                        NullUtils$.MODULE$.inst();
                        string = null;
                    }
                    return string;
                }

                public String host() {
                    return this.hostAddress$1;
                }

                public StatsdFlavor flavor() {
                    return StatsdFlavor.DATADOG;
                }
                {
                    this.hostAddress$1 = hostAddress$1;
                }
            };
            StatsdMeterRegistry registry = new StatsdMeterRegistry(config, Clock.SYSTEM);
            registry.config().commonTags(new String[]{"service", new StringBuilder(5).append("coco-").append(serviceName).toString()});
            this.log().info((Function0 & Serializable)() -> new StringBuilder(37).append("Datadog metrics started using host [").append(hostAddress).append("]").toString(), td);
            prometheusMeterRegistry = registry;
        } else if ("prometheus".equals(string)) {
            this.log().info((Function0 & Serializable)() -> "Prometheus metrics started", td);
            prometheusMeterRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        } else {
            throw new IllegalStateException(new StringBuilder(25).append("Invalid metrics engine [").append(engine).append("]").toString());
        }
        PrometheusMeterRegistry r = prometheusMeterRegistry;
        registry = new Some((Object)r);
        new ClassLoaderMetrics().bindTo((MeterRegistry)r);
        new JvmMemoryMetrics().bindTo((MeterRegistry)r);
        new JvmGcMetrics().bindTo((MeterRegistry)r);
        new ProcessorMetrics().bindTo((MeterRegistry)r);
        new JvmThreadMetrics().bindTo((MeterRegistry)r);
        Metrics.addRegistry((MeterRegistry)r);
    }

    public void stop() {
        registry.foreach((Function1 & Serializable)x0$1 -> {
            Instrumented$.$anonfun$stop$1(x0$1);
            return BoxedUnit.UNIT;
        });
        registry.foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        registry = None$.MODULE$;
    }

    public <A> A timeReceive(Object msg, String key, Seq<String> tags, Function0<A> f) {
        return (A)registry.map((Function1 & Serializable)r -> {
            Object object;
            long startNanos = System.nanoTime();
            try {
                Object ret = f.apply();
                String string = MODULE$.cn(msg);
                r.timer(key, (String[])((IterableOnceOps)Nil$.MODULE$.$colon$colon((Object)string).$colon$colon((Object)"class").$plus$plus((IterableOnce)tags)).toArray(ClassTag$.MODULE$.apply(String.class))).record(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
                object = ret;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable x = (Throwable)option.get();
                    String string = MODULE$.cn(msg);
                    String string2 = MODULE$.cn(x);
                    r.timer(key, (String[])((IterableOnceOps)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)"error").$colon$colon((Object)string).$colon$colon((Object)"class").$plus$plus((IterableOnce)tags)).toArray(ClassTag$.MODULE$.apply(String.class))).record(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
                    throw x;
                }
                throw throwable;
            }
            return object;
        }).getOrElse(f);
    }

    public <A> Future<A> timeFuture(String key, Seq<String> tags, Function0<Future<A>> future, ExecutionContext context) {
        return (Future)registry.map((Function1 & Serializable)r -> {
            Future future;
            long startNanos = System.nanoTime();
            try {
                future = (Future)future.apply();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable ex = (Throwable)option.get();
                    throw ex;
                }
                throw throwable;
            }
            Future f = future;
            f.onComplete((Function1 & Serializable)x0$1 -> {
                Instrumented$.$anonfun$timeFuture$2(r, key, tags, startNanos, x0$1);
                return BoxedUnit.UNIT;
            }, context);
            return f;
        }).getOrElse(future);
    }

    public static final /* synthetic */ void $anonfun$stop$1(MeterRegistry x0$1) {
        MeterRegistry meterRegistry = x0$1;
        if (meterRegistry instanceof PrometheusMeterRegistry) {
            PrometheusMeterRegistry prometheusMeterRegistry = (PrometheusMeterRegistry)meterRegistry;
            prometheusMeterRegistry.getPrometheusRegistry().clear();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (meterRegistry instanceof StatsdMeterRegistry) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)meterRegistry);
        }
    }

    public static final /* synthetic */ void $anonfun$timeFuture$2(MeterRegistry r$1, String key$2, Seq tags$2, long startNanos$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object s = success.value();
            String string = MODULE$.cn(s);
            r$1.timer(key$2, (String[])((IterableOnceOps)Nil$.MODULE$.$colon$colon((Object)string).$colon$colon((Object)"class").$plus$plus((IterableOnce)tags$2)).toArray(ClassTag$.MODULE$.apply(String.class))).record(System.nanoTime() - startNanos$1, TimeUnit.NANOSECONDS);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable x = failure.exception();
            String string = MODULE$.cn(x);
            r$1.timer(key$2, (String[])((IterableOnceOps)Nil$.MODULE$.$colon$colon((Object)string).$colon$colon((Object)"error").$plus$plus((IterableOnce)tags$2)).toArray(ClassTag$.MODULE$.apply(String.class))).record(System.nanoTime() - startNanos$1, TimeUnit.NANOSECONDS);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    private Instrumented$() {
    }
}

