/*
 * Decompiled with CFR 0.152.
 */
package com.kyleu.projectile.util.tracing;

import com.kyleu.projectile.util.Logging;
import com.kyleu.projectile.util.metrics.MetricsConfig;
import com.kyleu.projectile.util.tracing.TraceData;
import com.kyleu.projectile.util.tracing.TraceData$;
import com.kyleu.projectile.util.tracing.TraceDataOpenTracing;
import com.kyleu.projectile.util.tracing.TracingService;
import io.jaegertracing.Configuration;
import io.jaegertracing.micrometer.MicrometerMetricsFactory;
import io.jaegertracing.spi.MetricsFactory;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracer;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.propagation.TextMapInjectAdapter;
import java.io.Serializable;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u00055h\u0001B\t\u0013\u0001uA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0006a!)a\u0007\u0001C\u0001o!1Q\t\u0001Q!\n\u0019CQ!\u0015\u0001\u0005BICQ\u0001\u001f\u0001\u0005BeDq!!\u0002\u0001\t\u0003\n9\u0001\u0003\u0005\u0002\u0018\u0001\u0001\u000b\u0011BA\r\u0011!\t)\u0003\u0001Q\u0005\n\u0005\u001d\u0002bBA&\u0001\u0011\u0005\u0013Q\n\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\ti\b\u0001C\u0001\u0003\u007fBq!!#\u0001\t\u0003\tY\tC\u0004\u0002\u0012\u0002!\t!a%\t\u000f\u0005E\u0006\u0001\"\u0001\u00024\"9\u00111\u001c\u0001\u0005B\u0005u'AE(qK:$&/Y2j]\u001e\u001cVM\u001d<jG\u0016T!a\u0005\u000b\u0002\u000fQ\u0014\u0018mY5oO*\u0011QCF\u0001\u0005kRLGN\u0003\u0002\u00181\u0005Q\u0001O]8kK\u000e$\u0018\u000e\\3\u000b\u0005eQ\u0012!B6zY\u0016,(\"A\u000e\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001qB\u0005\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VM\u001a\t\u0003K\u0019j\u0011AE\u0005\u0003OI\u0011a\u0002\u0016:bG&twmU3sm&\u001cW-A\u0002d]\u001a\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\u000b\u0002\u000f5,GO]5dg&\u0011af\u000b\u0002\u000e\u001b\u0016$(/[2t\u0007>tg-[4\u0002\u0005\u0015\u001c\u0007CA\u00195\u001b\u0005\u0011$BA\u001a!\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003kI\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\tA4\b\u0006\u0002:uA\u0011Q\u0005\u0001\u0005\u0006_\r\u0001\u001d\u0001\r\u0005\u0006Q\r\u0001\r!\u000b\u0015\u0003\u0007u\u0002\"AP\"\u000e\u0003}R!\u0001Q!\u0002\r%t'.Z2u\u0015\u0005\u0011\u0015!\u00026bm\u0006D\u0018B\u0001#@\u0005\u0019IeN[3di\u0006\u00191MZ4\u0011\u0007}9\u0015*\u0003\u0002IA\t1q\n\u001d;j_:\u0004\"AS(\u000e\u0003-S!\u0001T'\u0002\u001b)\fWmZ3siJ\f7-\u001b8h\u0015\u0005q\u0015AA5p\u0013\t\u00016JA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\n]>|\u0007\u000f\u0016:bG\u0016,\"a\u0015.\u0015\u0005Q[GCA+d!\r\td\u000bW\u0005\u0003/J\u0012aAR;ukJ,\u0007CA-[\u0019\u0001!QaW\u0003C\u0002q\u0013\u0011!Q\t\u0003;\u0002\u0004\"a\b0\n\u0005}\u0003#a\u0002(pi\"Lgn\u001a\t\u0003?\u0005L!A\u0019\u0011\u0003\u0007\u0005s\u0017\u0010C\u0003e\u000b\u0001\u0007Q-A\u0001g!\u0011yb\r[+\n\u0005\u001d\u0004#!\u0003$v]\u000e$\u0018n\u001c82!\t)\u0013.\u0003\u0002k%\tIAK]1dK\u0012\u000bG/\u0019\u0005\u0006Y\u0016\u0001\r!\\\u0001\u0005]\u0006lW\r\u0005\u0002ok:\u0011qn\u001d\t\u0003a\u0002j\u0011!\u001d\u0006\u0003er\ta\u0001\u0010:p_Rt\u0014B\u0001;!\u0003\u0019\u0001&/\u001a3fM&\u0011ao\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\u0004\u0013!\u0004;pa2+g/\u001a7Ue\u0006\u001cW-\u0006\u0002{}R\u001910a\u0001\u0015\u0005q|\bcA\u0019W{B\u0011\u0011L \u0003\u00067\u001a\u0011\r\u0001\u0018\u0005\u0007I\u001a\u0001\r!!\u0001\u0011\t}1\u0007\u000e \u0005\u0006Y\u001a\u0001\r!\\\u0001\u0016i>\u0004H*\u001a<fYR\u0013\u0018mY3CY>\u001c7.\u001b8h+\u0011\tI!a\u0004\u0015\t\u0005-\u0011Q\u0003\u000b\u0005\u0003\u001b\t\t\u0002E\u0002Z\u0003\u001f!QaW\u0004C\u0002qCa\u0001Z\u0004A\u0002\u0005M\u0001#B\u0010gQ\u00065\u0001\"\u00027\b\u0001\u0004i\u0017A\u0002;sC\u000e,'\u000f\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\"T\u0001\f_B,g\u000e\u001e:bG&tw-\u0003\u0003\u0002$\u0005u!A\u0002+sC\u000e,'/A\u0007oK^\u001cVM\u001d<feN\u0003\u0018M\u001c\u000b\u0007\u0003S\t9$a\u000f\u0015\t\u0005-\u00121\u0007\t\u0005?\u001d\u000bi\u0003\u0005\u0003\u0002\u001c\u0005=\u0012\u0002BA\u0019\u0003;\u0011Aa\u00159b]\"1\u0011QG\u0005A\u0004!\f!\u0002]1sK:$H)\u0019;b\u0011\u0019\tI$\u0003a\u0001[\u0006IAO]1dK:\u000bW.\u001a\u0005\b\u0003{I\u0001\u0019AA \u0003\u0011!\u0018mZ:\u0011\u000b}\t\t%!\u0012\n\u0007\u0005\r\u0003E\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u0002RaHA$[6L1!!\u0013!\u0005\u0019!V\u000f\u001d7fe\u0005iAO]1dK\ncwnY6j]\u001e,B!a\u0014\u0002XQ1\u0011\u0011KA0\u0003C\"B!a\u0015\u0002\\Q!\u0011QKA-!\rI\u0016q\u000b\u0003\u00067*\u0011\r\u0001\u0018\u0005\u0007\u0003kQ\u00019\u00015\t\r\u0011T\u0001\u0019AA/!\u0015yb\r[A+\u0011\u0019\tID\u0003a\u0001[\"9\u0011Q\b\u0006A\u0002\u0005}\u0012!\u0002;sC\u000e,W\u0003BA4\u0003c\"b!!\u001b\u0002z\u0005mD\u0003BA6\u0003k\"B!!\u001c\u0002tA!\u0011GVA8!\rI\u0016\u0011\u000f\u0003\u00067.\u0011\r\u0001\u0018\u0005\u0007\u0003kY\u00019\u00015\t\r\u0011\\\u0001\u0019AA<!\u0015yb\r[A7\u0011\u0019\tId\u0003a\u0001[\"9\u0011QH\u0006A\u0002\u0005}\u0012AD:feZ,'OU3dK&4X\r\u001a\u000b\u0007\u0003[\t\t)!\"\t\r\u0005\rE\u00021\u0001n\u0003!\u0019\b/\u00198OC6,\u0007bBAD\u0019\u0001\u0007\u0011QF\u0001\u0005gB\fg.\u0001\u0006tKJ4XM]*f]\u0012$b!!\f\u0002\u000e\u0006=\u0005bBAD\u001b\u0001\u0007\u0011Q\u0006\u0005\b\u0003{i\u0001\u0019AA \u0003\u001dqWm^*qC:,B!!&\u00020R1\u0011qSAR\u0003K\u0003B!!'\u0002 6\u0011\u00111\u0014\u0006\u0005\u0003;\u000bi\"\u0001\u0004Ue\u0006\u001cWM]\u0005\u0005\u0003C\u000bYJA\u0006Ta\u0006t')^5mI\u0016\u0014\b\"\u00027\u000f\u0001\u0004i\u0007bBAT\u001d\u0001\u0007\u0011\u0011V\u0001\bQ\u0016\fG-\u001a:t!\u0015q\u00171V7n\u0013\r\tik\u001e\u0002\u0004\u001b\u0006\u0004H!B.\u000f\u0005\u0004a\u0016!\u0002;p\u001b\u0006\u0004H\u0003BA[\u0003/\u0004D!a.\u0002DBA\u0011\u0011XA`\u0003\u0003\fI-\u0004\u0002\u0002<*\u0019\u0011Q\u0018\u0011\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002.\u0006m\u0006cA-\u0002D\u0012Y\u0011QY\b\u0002\u0002\u0003\u0005)\u0011AAd\u0005\ty\u0016'\u0005\u0002^[B!\u00111ZAk\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017\u0001\u00027b]\u001eT!!a5\u0002\t)\fg/Y\u0005\u0004m\u00065\u0007BBAm\u001f\u0001\u0007\u0001.\u0001\u0002uI\u0006)1\r\\8tKR\u0011\u0011q\u001c\t\u0004?\u0005\u0005\u0018bAArA\t!QK\\5uQ\r\u0001\u0011q\u001d\t\u0004}\u0005%\u0018bAAv\u007f\tI1+\u001b8hY\u0016$xN\u001c")
public class OpenTracingService
implements TracingService {
    private final MetricsConfig cnf;
    private final ExecutionContext ec;
    private Option<Configuration> cfg;
    private final Tracer tracer;
    private Logging.TraceLogger log;
    private volatile boolean bitmap$0;
    private volatile byte bitmap$init$0;

    private Logging.TraceLogger log$lzycompute() {
        OpenTracingService openTracingService = this;
        synchronized (openTracingService) {
            if (!this.bitmap$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.log;
    }

    public Logging.TraceLogger log() {
        return !this.bitmap$0 ? this.log$lzycompute() : this.log;
    }

    public <A> Future<A> noopTrace(String name, Function1<TraceData, Future<A>> f) {
        return (Future)f.apply((Object)TraceData$.MODULE$.noop());
    }

    public <A> Future<A> topLevelTrace(String name, Function1<TraceData, Future<A>> f) {
        Span span = this.tracer.buildSpan(name).start();
        span.setTag("top.level", "true");
        Future result = (Future)f.apply((Object)new TraceDataOpenTracing(span));
        result.onComplete((Function1 & Serializable)x0$1 -> {
            Span span;
            Try try_ = x0$1;
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                span = this.serverSend(span, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failed"), (Object)new StringBuilder(25).append("Finished with exception: ").append(t.getMessage()).toString())}));
            } else if (try_ instanceof Success) {
                span = this.serverSend(span, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            } else {
                throw new MatchError((Object)try_);
            }
            return span;
        }, this.ec);
        return result;
    }

    public <A> A topLevelTraceBlocking(String name, Function1<TraceData, A> f) {
        Object object;
        Span span = this.tracer.buildSpan(name).start();
        span.setTag("top.level", "true");
        try {
            Object result = f.apply((Object)new TraceDataOpenTracing(span));
            this.serverSend(span, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            object = result;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable x = (Throwable)option.get();
                this.serverSend(span, (Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failed"), (Object)new StringBuilder(25).append("Finished with exception: ").append(x.getMessage()).toString())}));
                throw x;
            }
            throw throwable;
        }
        return (A)object;
    }

    private Option<Span> newServerSpan(String traceName, Seq<Tuple2<String, String>> tags, TraceData parentData) {
        None$ none$;
        TraceData traceData = parentData;
        if (traceData instanceof TraceDataOpenTracing) {
            TraceDataOpenTracing traceDataOpenTracing = (TraceDataOpenTracing)traceData;
            Span childSpan = this.tracer.buildSpan(traceName).asChildOf(traceDataOpenTracing.span()).start();
            tags.foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                Span span = childSpan.setTag(key, value);
                return span;
            });
            none$ = new Some((Object)childSpan.setTag("thread.id", Thread.currentThread().getName()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public <A> A traceBlocking(String traceName, Seq<Tuple2<String, String>> tags, Function1<TraceData, A> f, TraceData parentData) {
        TraceData traceData = parentData;
        Object object = traceData instanceof TraceDataOpenTracing ? this.newServerSpan(traceName, tags, parentData).map((Function1 & Serializable)childSpan -> {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> f.apply((Object)new TraceDataOpenTracing((Span)childSpan)));
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable t = failure.exception();
                    childSpan.setTag("error.type", StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(t.getClass().getSimpleName()), "$"));
                    childSpan.setTag("error.message", t.getMessage());
                    childSpan.finish();
                    throw t;
                }
                throw new MatchError((Object)try_);
            }
            Success success = (Success)try_;
            Object result = success.value();
            childSpan.finish();
            Object object = result;
            return object;
        }).getOrElse((Function0 & Serializable)() -> f.apply((Object)parentData)) : f.apply((Object)parentData);
        return (A)object;
    }

    public <A> Future<A> trace(String traceName, Seq<Tuple2<String, String>> tags, Function1<TraceData, Future<A>> f, TraceData parentData) {
        Option<Span> childSpan = this.newServerSpan(traceName, tags, parentData);
        Future result = (Future)f.apply(childSpan.map((Function1 & Serializable)span -> new TraceDataOpenTracing((Span)span)).getOrElse((Function0 & Serializable)() -> parentData));
        result.onComplete((Function1 & Serializable)x0$1 -> {
            OpenTracingService.$anonfun$trace$3(childSpan, x0$1);
            return BoxedUnit.UNIT;
        }, this.ec);
        return result;
    }

    public Span serverReceived(String spanName, Span span) {
        return this.tracer.buildSpan(spanName).asChildOf(span).start();
    }

    public Span serverSend(Span span, Seq<Tuple2<String, String>> tags) {
        tags.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            Span span = span.setTag(key, value);
            return span;
        });
        span.finish();
        return span;
    }

    public <A> Tracer.SpanBuilder newSpan(String name, scala.collection.immutable.Map<String, String> headers) {
        Tracer.SpanBuilder spanBuilder;
        Option option = Option$.MODULE$.apply((Object)this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapExtractAdapter(CollectionConverters$.MODULE$.MapHasAsJava(headers).asJava())));
        if (option instanceof Some) {
            Some some = (Some)option;
            SpanContext extracted = (SpanContext)some.value();
            spanBuilder = this.tracer.buildSpan(name).asChildOf(extracted);
        } else if (None$.MODULE$.equals(option)) {
            spanBuilder = this.tracer.buildSpan(name);
        } else {
            throw new MatchError((Object)option);
        }
        return spanBuilder;
    }

    public Map<? extends String, String> toMap(TraceData td) {
        scala.collection.immutable.Map map;
        TraceData traceData = td;
        if (traceData instanceof TraceDataOpenTracing) {
            TraceDataOpenTracing traceDataOpenTracing = (TraceDataOpenTracing)traceData;
            HashMap data = new HashMap();
            this.tracer.inject(traceDataOpenTracing.span().context(), Format.Builtin.HTTP_HEADERS, (Object)new TextMapInjectAdapter(data));
            map = CollectionConverters$.MODULE$.MapHasAsScala(data).asScala();
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public void close() {
        this.cfg.foreach((Function1 & Serializable)x$4 -> {
            x$4.closeTracer();
            return BoxedUnit.UNIT;
        });
        this.cfg = None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$trace$3(Option childSpan$3, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            childSpan$3.foreach((Function1 & Serializable)x$1 -> x$1.setTag("error.type", StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(t.getClass().getSimpleName()), "$")));
            childSpan$3.foreach((Function1 & Serializable)x$2 -> x$2.setTag("error.message", t.getMessage()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            childSpan$3.foreach((Function1 & Serializable)x$3 -> {
                x$3.finish();
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Inject
    public OpenTracingService(MetricsConfig cnf, ExecutionContext ec) {
        NoopTracer noopTracer;
        this.cnf = cnf;
        this.ec = ec;
        Logging.$init$((Logging)this);
        TracingService.$init$((TracingService)this);
        this.cfg = None$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        if (cnf.tracingEnabled()) {
            Configuration.SamplerConfiguration sampler = new Configuration.SamplerConfiguration().withType("const").withParam((Number)Predef$.MODULE$.int2Integer(1));
            Configuration.SenderConfiguration sender = new Configuration.SenderConfiguration().withAgentHost(cnf.tracingServer()).withAgentPort(Predef$.MODULE$.int2Integer(cnf.tracingPort()));
            Configuration.ReporterConfiguration reporter = new Configuration.ReporterConfiguration().withLogSpans(Predef$.MODULE$.boolean2Boolean(false)).withSender(sender).withFlushInterval(Predef$.MODULE$.int2Integer(1000)).withMaxQueueSize(Predef$.MODULE$.int2Integer(10000));
            MicrometerMetricsFactory metrics = new MicrometerMetricsFactory();
            String loc = new StringBuilder(1).append(cnf.tracingServer()).append(":").append(cnf.tracingPort()).toString();
            this.log().info((Function0 & Serializable)() -> new StringBuilder(59).append("Tracing enabled, sending results to [").append(loc).append("] using sample rate [").append($this.cnf.tracingSampleRate()).append("]").toString(), TraceData$.MODULE$.noop());
            Configuration c = new Configuration("project").withSampler(sampler).withReporter(reporter).withMetricsFactory((MetricsFactory)metrics);
            this.cfg = new Some((Object)c);
            this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
            noopTracer = c.getTracer();
        } else {
            noopTracer = NoopTracerFactory.create();
        }
        this.tracer = noopTracer;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

