/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.mvc;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.DefaultFriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class AlloyFriendlyURLMapper
extends DefaultFriendlyURLMapper {
    private static final Log _log = LogFactoryUtil.getLog(AlloyFriendlyURLMapper.class);

    public String buildPath(LiferayPortletURL liferayPortletURL) {
        HashMap<String, String> routeParameters = new HashMap<String, String>();
        this.buildRouteParameters(liferayPortletURL, routeParameters);
        String lifecycle = liferayPortletURL.getLifecycle();
        String delta = (String)routeParameters.get("delta");
        if (lifecycle.equals("ACTION_PHASE") || delta != null) {
            routeParameters.put("method", "POST");
        } else {
            routeParameters.put("method", "GET");
        }
        String friendlyURLPath = this.router.parametersToUrl(routeParameters);
        if (friendlyURLPath == null) {
            return null;
        }
        this.addParametersIncludedInPath(liferayPortletURL, routeParameters);
        int pos = friendlyURLPath.indexOf(47);
        friendlyURLPath = pos != -1 ? friendlyURLPath.substring(pos) : "";
        friendlyURLPath = "/".concat(this.getMapping()).concat(friendlyURLPath);
        return friendlyURLPath;
    }

    public void populateParams(String friendlyURLPath, Map<String, String[]> parameterMap, Map<String, Object> requestContext) {
        HashMap routeParameters;
        HttpServletRequest request = (HttpServletRequest)requestContext.get("request");
        friendlyURLPath = request.getMethod() + friendlyURLPath.substring(this.getMapping().length() + 1);
        if (friendlyURLPath.endsWith("/")) {
            friendlyURLPath = friendlyURLPath.substring(0, friendlyURLPath.length() - 1);
        }
        if (!this.router.urlToParameters(friendlyURLPath, routeParameters = new HashMap())) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No route could be found to match URL " + friendlyURLPath));
            }
            return;
        }
        String portletId = this.getPortletId(routeParameters);
        if (portletId == null) {
            return;
        }
        String namespace = PortalUtil.getPortletNamespace((String)portletId);
        this.addParameter(namespace, parameterMap, "p_p_id", portletId);
        this.addParameter(parameterMap, "p_p_lifecycle", this.getLifecycle(request));
        String format = (String)routeParameters.get("format");
        if (Validator.isNotNull((String)format)) {
            this.addParameter(parameterMap, "p_p_state", "exclusive");
        }
        this.populateParams(parameterMap, namespace, routeParameters);
    }

    protected String getLifecycle(HttpServletRequest request) {
        if (PortalUtil.isMultipartRequest((HttpServletRequest)request)) {
            return "1";
        }
        return ParamUtil.getString((HttpServletRequest)request, (String)"p_p_lifecycle", (String)"0");
    }
}

