/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.mvc;

import com.liferay.alloy.mvc.AlloyServiceInvoker;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.exception.NoSuchResourceActionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringUtil;

public class AlloyPermission {
    private static final Log _log = LogFactoryUtil.getLog(AlloyPermission.class);

    public static void check(PermissionChecker permissionChecker, long groupId, String name, long primKey, String actionId) throws PortalException {
        if (!AlloyPermission.contains(permissionChecker, groupId, name, primKey, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(ThemeDisplay themeDisplay, BaseModel<?> baseModel, String action) throws PortalException {
        if (!AlloyPermission.contains(themeDisplay, baseModel, action)) {
            throw new PrincipalException();
        }
    }

    public static void check(ThemeDisplay themeDisplay, String controller, String action) throws PortalException {
        if (!AlloyPermission.contains(themeDisplay, controller, action)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String name, long primKey, String actionId) {
        return AlloyPermission.contains(permissionChecker, groupId, name, primKey, actionId, 0L);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String name, long primKey, String actionId, long ownerId) {
        try {
            ResourceActionsUtil.checkAction((String)name, (String)actionId);
        }
        catch (NoSuchResourceActionException nsrae) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nsrae, (Throwable)nsrae);
            }
            return true;
        }
        if (name.indexOf(46) != -1) {
            if (ownerId <= 0L) {
                ownerId = AlloyPermission.getOwnerId(name, primKey);
            }
            if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), name, primKey, ownerId, actionId)) {
                return true;
            }
        }
        return permissionChecker.hasPermission(groupId, name, primKey, actionId);
    }

    public static boolean contains(ThemeDisplay themeDisplay, BaseModel<?> baseModel, String action) {
        return AlloyPermission.contains(PermissionThreadLocal.getPermissionChecker(), themeDisplay.getScopeGroupId(), BeanPropertiesUtil.getString(baseModel, (String)"modelClassName"), (Long)baseModel.getPrimaryKeyObj(), StringUtil.toUpperCase((String)action));
    }

    public static boolean contains(ThemeDisplay themeDisplay, String controller, String action) {
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        String actionId = AlloyPermission.formatActionId(controller, action);
        return AlloyPermission.contains(PermissionThreadLocal.getPermissionChecker(), themeDisplay.getScopeGroupId(), portletDisplay.getRootPortletId(), themeDisplay.getScopeGroupId(), actionId);
    }

    public static boolean contains(ThemeDisplay themeDisplay, String rootPortletId, String controller, String action) {
        String actionId = AlloyPermission.formatActionId(controller, action);
        return AlloyPermission.contains(PermissionThreadLocal.getPermissionChecker(), themeDisplay.getScopeGroupId(), rootPortletId, themeDisplay.getScopeGroupId(), actionId);
    }

    protected static String formatAction(String action) {
        StringBuilder sb = new StringBuilder(StringUtil.toUpperCase((String)action));
        for (int i = 0; i < action.length(); ++i) {
            char c = action.charAt(i);
            if (!Character.isUpperCase(c) || i <= 0) continue;
            int delta = sb.length() - action.length();
            sb.insert(i + delta, '_');
            if (i + 1 >= action.length() || Character.isLowerCase(action.charAt(i + 1))) continue;
            while (i < action.length() && !Character.isLowerCase(c = action.charAt(i))) {
                ++i;
            }
            if (i == action.length()) continue;
            sb.insert(i + delta, '_');
        }
        return sb.toString();
    }

    protected static String formatActionId(String controller, String action) {
        StringBuilder sb = new StringBuilder(AlloyPermission.formatAction(action));
        sb.append("#");
        sb.append(StringUtil.toUpperCase((String)controller));
        return sb.toString();
    }

    protected static long getOwnerId(String className, long classPK) {
        BaseModel<?> baseModel = null;
        try {
            AlloyServiceInvoker alloyServiceInvoker = new AlloyServiceInvoker(className);
            baseModel = alloyServiceInvoker.fetchModel(classPK);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return BeanPropertiesUtil.getLongSilent(baseModel, (String)"userId");
    }
}

