/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.settings.internal.security.auth.verifier;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.security.service.access.policy.ServiceAccessPolicy;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"auth.verifier.AnalyticsSecurityAuthVerifier.urls.includes=/o/segments-asah/v1.0/experiments/*"}, service={AuthVerifier.class})
public class AnalyticsSecurityAuthVerifier
implements AuthVerifier {
    private static final long _EXPIRATION = 600000L;
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsSecurityAuthVerifier.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public String getAuthType() {
        Class<?> clazz = this.getClass();
        return clazz.getSimpleName();
    }

    public AuthVerifierResult verify(AccessControlContext accessControlContext, Properties properties) throws AuthException {
        AuthVerifierResult authVerifierResult = new AuthVerifierResult();
        HttpServletRequest httpServletRequest = accessControlContext.getRequest();
        String signature = httpServletRequest.getHeader("Liferay-Analytics-Cloud-Security-Signature");
        if (signature == null) {
            return authVerifierResult;
        }
        try {
            AnalyticsConfiguration analyticsConfiguration = (AnalyticsConfiguration)this._configurationProvider.getCompanyConfiguration(AnalyticsConfiguration.class, this._portal.getCompanyId(httpServletRequest));
            if (analyticsConfiguration.token() == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Missing security configuration");
                }
                return authVerifierResult;
            }
            Set hostsAllowed = JSONUtil.toStringSet((JSONArray)JSONFactoryUtil.createJSONArray((String)analyticsConfiguration.hostsAllowed()));
            if (!hostsAllowed.isEmpty() && !hostsAllowed.contains(httpServletRequest.getRemoteAddr())) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Access denied for " + httpServletRequest.getRemoteAddr()));
                }
                return authVerifierResult;
            }
            String timestamp = httpServletRequest.getHeader("Liferay-Analytics-Cloud-Security-Timestamp");
            if (System.currentTimeMillis() - GetterUtil.getLong((String)timestamp) > 600000L) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Signature timestamp expired " + timestamp));
                }
                return authVerifierResult;
            }
            if (!this._validateSignature(httpServletRequest, analyticsConfiguration.publicKey(), signature, timestamp)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Invalid signature " + signature));
                }
                return authVerifierResult;
            }
            Map settings = authVerifierResult.getSettings();
            List serviceAccessPolicyNames = (List)settings.computeIfAbsent(ServiceAccessPolicy.SERVICE_ACCESS_POLICY_NAMES, value -> new ArrayList());
            serviceAccessPolicyNames.add("ANALYTICS_CLOUD_TOKEN");
            authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
            authVerifierResult.setUserId(this._getAnalyticsAdminUserId(this._portal.getCompanyId(httpServletRequest)));
            return authVerifierResult;
        }
        catch (Exception exception) {
            throw new AuthException((Throwable)exception);
        }
    }

    private long _getAnalyticsAdminUserId(long companyId) {
        User user = this._userLocalService.fetchUserByScreenName(companyId, "analytics.administrator");
        return user.getUserId();
    }

    private boolean _validateSignature(HttpServletRequest httpServletRequest, String publicKey, String signatureString, String timestamp) throws Exception {
        Signature signature = Signature.getInstance("DSA");
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        signature.initVerify(keyFactory.generatePublic(new X509EncodedKeySpec(Base64.decode((String)publicKey))));
        TreeMap sortedParameters = new TreeMap();
        Map parameters = httpServletRequest.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            sortedParameters.put(entry.getKey(), ((String[])entry.getValue())[0]);
        }
        sortedParameters.put("Liferay-Analytics-Cloud-Security-Timestamp", timestamp);
        StringBundler sb = new StringBundler(2 * sortedParameters.size() + 3);
        sb.append(httpServletRequest.getContextPath());
        sb.append(httpServletRequest.getServletPath());
        sb.append(httpServletRequest.getPathInfo());
        for (Map.Entry entry : sortedParameters.entrySet()) {
            sb.append((String)entry.getKey());
            sb.append((String)entry.getValue());
        }
        String string = sb.toString();
        signature.update(string.getBytes(Charset.defaultCharset()));
        return signature.verify(Base64.decode((String)signatureString));
    }
}

