Liferay.Loader.define("app-builder-web@1.0.18/js/components/table/EmptyState.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../utils/lang.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.withEmpty = void 0;

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _lang = _interopRequireDefault(require("../../utils/lang.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
      }
    }return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
    }return target;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var EmptyState = function EmptyState(_ref) {
    var emptyState = _ref.emptyState,
        _ref$keywords = _ref.keywords,
        keywords = _ref$keywords === void 0 ? '' : _ref$keywords;
    var defaultEmpty = {
      description: null,
      title: Liferay.Language.get('there-are-no-entries')
    };
    var defaultSearch = {
      description: _lang["default"].sub(Liferay.Language.get('there-are-no-results-for-x'), [keywords]),
      title: Liferay.Language.get('no-results-were-found')
    };
    emptyState = _objectSpread({}, defaultEmpty, {}, emptyState);

    var search = _objectSpread({}, defaultSearch, {}, emptyState.search);

    var isSearch = keywords !== '';

    var _ref2 = isSearch ? search : emptyState,
        button = _ref2.button,
        description = _ref2.description,
        title = _ref2.title;

    var className = isSearch ? 'taglib-search-state' : 'taglib-empty-state';
    return _react["default"].createElement("div", {
      className: "taglib-empty-result-message"
    }, _react["default"].createElement("div", {
      className: "text-center"
    }, _react["default"].createElement("div", {
      className: className
    }), title && _react["default"].createElement("h1", {
      className: "taglib-empty-result-message-title"
    }, title), description && _react["default"].createElement("p", {
      className: "empty-message-color taglib-empty-result-message-description"
    }, description), button && button()));
  };

  var withEmpty = function withEmpty(Component) {

    return function Wrapper(_ref3) {
      var emptyState = _ref3.emptyState,
          isEmpty = _ref3.isEmpty,
          keywords = _ref3.keywords,
          restProps = _objectWithoutProperties(_ref3, ["emptyState", "isEmpty", "keywords"]);

      if (isEmpty) {
        return _react["default"].createElement(EmptyState, {
          emptyState: emptyState,
          keywords: keywords
        });
      }

      return _react["default"].createElement(Component, restProps);
    };
  };

  exports.withEmpty = withEmpty;
  var _default = EmptyState;
  exports["default"] = _default;
  //# sourceMappingURL=EmptyState.es.js.map
});
//# sourceMappingURL=EmptyState.es.js.map