Liferay.Loader.define("app-builder-web@1.0.18/js/pages/app/ListApps.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/label', '@frontend-taglib-clay$clayui/list', '@frontend-taglib-clay$clayui/modal', 'app-builder-web$moment', 'frontend-js-react-web$react', 'app-builder-web$react-router-dom', '../../AppContext.es', '../../components/button/Button.es', '../../components/list-view/ListView.es', '../../utils/client.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _label = _interopRequireDefault(require("@frontend-taglib-clay$clayui/label"));

  var _list = _interopRequireDefault(require("@frontend-taglib-clay$clayui/list"));

  var _modal = require("@frontend-taglib-clay$clayui/modal");

  var _moment = _interopRequireDefault(require("app-builder-web$moment"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactRouterDom = require("app-builder-web$react-router-dom");

  var _AppContext = require("../../AppContext.es");

  var _Button = _interopRequireDefault(require("../../components/button/Button.es"));

  var _ListView = _interopRequireDefault(require("../../components/list-view/ListView.es"));

  var _client = require("../../utils/client.es");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var DEPLOYMENT_ACTION = {
    deploy: Liferay.Language.get('deploy'),
    undeploy: Liferay.Language.get('undeploy')
  };
  var DEPLOYMENT_STATUS = {
    deployed: Liferay.Language.get('deployed'),
    undeployed: Liferay.Language.get('undeployed')
  };
  var DEPLOYMENT_TYPES = {
    productMenu: Liferay.Language.get('product-menu'),
    standalone: Liferay.Language.get('standalone'),
    widget: Liferay.Language.get('widget')
  };

  var concatTypes = function concatTypes(types) {
    return types.reduce(function (acc, cur, index) {
      if (index < types.length - 2) {
        return "".concat(acc + DEPLOYMENT_TYPES[cur], ", ");
      }

      if (index == types.length - 2) {
        return "".concat(acc + DEPLOYMENT_TYPES[cur], " ").concat(Liferay.Language.get('and').toLowerCase(), " ");
      }

      return acc + DEPLOYMENT_TYPES[cur];
    }, '');
  };

  var deploy = function deploy(item, _deploy, resolve, reject) {
    (0, _client.updateItem)("/o/app-builder/v1.0/apps/".concat(item.id, "/deployment"), {}, {
      deploymentAction: _deploy ? 'deploy' : 'undeploy'
    }).then(function () {
      return resolve(true);
    })["catch"](function (error) {
      return reject(error);
    });
  };

  var isDeployed = function isDeployed(status) {
    return status === 'deployed';
  };

  var showUndeployModal = function showUndeployModal(item, resolve, reject, undeployModalContext) {
    var _undeployModalContext = _slicedToArray(undeployModalContext, 2),
        state = _undeployModalContext[0],
        dispatch = _undeployModalContext[1];

    dispatch({
      payload: {
        body: _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement("p", null, Liferay.Language.get('undeploy-warning')), _react["default"].createElement(_list["default"], null, _react["default"].createElement(_list["default"].Header, null, Liferay.Language.get('app')), _react["default"].createElement(_list["default"].Item, {
          flex: true
        }, _react["default"].createElement(_list["default"].ItemField, {
          expand: true
        }, _react["default"].createElement("span", null, _react["default"].createElement("b", null, Liferay.Language.get('name'), ":"), ' ', item.nameText), _react["default"].createElement("span", null, _react["default"].createElement("b", null, Liferay.Language.get('deployed-as'), ":"), ' ', concatTypes(item.appDeployments.map(function (deployment) {
          return deployment.type;
        }))), _react["default"].createElement("span", null, _react["default"].createElement("b", null, Liferay.Language.get('modified-date'), ":"), ' ', item.dateModified))))),
        footer: [_react["default"].createElement(_react["default"].Fragment, null), _react["default"].createElement(_react["default"].Fragment, null), _react["default"].createElement(_button["default"].Group, {
          key: 0,
          spaced: true
        }, _react["default"].createElement(_button["default"], {
          displayType: "secondary",
          key: 1,
          onClick: state.onClose
        }, Liferay.Language.get('cancel')), _react["default"].createElement(_button["default"], {
          key: 2,
          onClick: function onClick() {
            state.onClose();
            deploy(item, false, resolve, reject);
          }
        }, DEPLOYMENT_ACTION.undeploy))],
        header: DEPLOYMENT_ACTION.undeploy,
        size: 'lg',
        status: 'warning'
      },
      type: 1
    });
  };

  var COLUMNS = [{
    key: 'name',
    sortable: true,
    value: Liferay.Language.get('name')
  }, {
    key: 'type',
    value: Liferay.Language.get('deployed-as')
  }, {
    key: 'dateCreated',
    sortable: true,
    value: Liferay.Language.get('create-date')
  }, {
    asc: false,
    key: 'dateModified',
    sortable: true,
    value: Liferay.Language.get('modified-date')
  }, {
    key: 'status',
    value: Liferay.Language.get('status')
  }];

  var _default = function _default(_ref) {
    var _ref$match = _ref.match,
        dataDefinitionId = _ref$match.params.dataDefinitionId,
        url = _ref$match.url;

    var _useContext = (0, _react.useContext)(_AppContext.AppContext),
        getStandaloneURL = _useContext.getStandaloneURL;

    var undeployModalContext = (0, _react.useContext)(_modal.Context);
    var ACTIONS = [{
      action: function action(item) {
        return new Promise(function (resolve, reject) {
          if (isDeployed(item.statusText)) {
            showUndeployModal(item, resolve, reject, undeployModalContext);
          } else {
            deploy(item, true, resolve, reject);
          }
        });
      },
      name: function name(item) {
        return isDeployed(item.statusText) ? DEPLOYMENT_ACTION.undeploy : DEPLOYMENT_ACTION.deploy;
      }
    }, {
      action: function action(item) {
        return Promise.resolve(window.open(getStandaloneURL(item.id), '_blank'));
      },
      name: Liferay.Language.get('open-standalone-app'),
      show: function show(item) {
        return item.appDeployments.some(function (deployment) {
          return deployment.type === 'standalone';
        });
      }
    }, {
      action: (0, _client.confirmDelete)('/o/app-builder/v1.0/apps/'),
      name: Liferay.Language.get('delete')
    }];
    var EMPTY_STATE = {
      button: function button() {
        return _react["default"].createElement(_Button["default"], {
          displayType: "secondary",
          href: "".concat(url, "/deploy")
        }, Liferay.Language.get('new-app'));
      },
      description: Liferay.Language.get('select-the-form-and-table-view-you-want-and-deploy-your-app-as-a-widget-standalone-or-place-it-in-the-product-menu'),
      title: Liferay.Language.get('there-are-no-apps-yet')
    };
    return _react["default"].createElement(_ListView["default"], {
      actions: ACTIONS,
      addButton: function addButton() {
        return _react["default"].createElement(_Button["default"], {
          className: "nav-btn nav-btn-monospaced navbar-breakpoint-down-d-none",
          href: "".concat(url, "/deploy"),
          symbol: "plus",
          tooltip: Liferay.Language.get('new-app')
        });
      },
      columns: COLUMNS,
      emptyState: EMPTY_STATE,
      endpoint: "/o/app-builder/v1.0/data-definitions/".concat(dataDefinitionId, "/apps")
    }, function (item) {
      return _objectSpread({}, item, {
        dateCreated: (0, _moment["default"])(item.dateCreated).fromNow(),
        dateModified: (0, _moment["default"])(item.dateModified).fromNow(),
        name: _react["default"].createElement(_reactRouterDom.Link, {
          to: "/custom-object/".concat(dataDefinitionId, "/apps/").concat(item.id)
        }, item.name.en_US),
        nameText: item.name.en_US,
        status: _react["default"].createElement(_label["default"], {
          displayType: isDeployed(item.status.toLowerCase()) ? 'success' : 'secondary'
        }, DEPLOYMENT_STATUS[item.status.toLowerCase()]),
        statusText: item.status.toLowerCase(),
        type: concatTypes(item.appDeployments.map(function (deployment) {
          return deployment.type;
        }))
      });
    });
  };

  exports["default"] = _default;
  //# sourceMappingURL=ListApps.es.js.map
});
//# sourceMappingURL=ListApps.es.js.map