Liferay.Loader.define("app-builder-web@1.0.18/js/pages/custom-object/CustomObjectPopover.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$react', '../../components/button/Button.es', '../../components/popover/Popover.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _Button = _interopRequireDefault(require("../../components/button/Button.es"));

  var _Popover = _interopRequireDefault(require("../../components/popover/Popover.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }return target;
    };return _extends.apply(this, arguments);
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var CustomObjectPopover = function CustomObjectPopover(_ref) {
    var alignElement = _ref.alignElement,
        className = _ref.className,
        forwardRef = _ref.forwardRef,
        onCancel = _ref.onCancel,
        onSubmit = _ref.onSubmit,
        visible = _ref.visible;
    var nameInputRef = (0, _react.useRef)();

    var _useState = (0, _react.useState)(true),
        _useState2 = _slicedToArray(_useState, 2),
        isAddFormView = _useState2[0],
        setAddFormView = _useState2[1];

    var _useState3 = (0, _react.useState)(false),
        _useState4 = _slicedToArray(_useState3, 2),
        hasError = _useState4[0],
        setHasError = _useState4[1];

    var handleSubmit = function handleSubmit() {
      var name = nameInputRef.current.value;

      if (validate(name)) {
        onSubmit({
          isAddFormView: isAddFormView,
          name: name
        });
      } else {
        nameInputRef.current.focus();
      }
    };

    var validate = function validate(value) {
      var invalid = value.trim() === '';
      setHasError(invalid);
      return !invalid;
    };

    var resetForm = function resetForm() {
      nameInputRef.current.value = '';
      setAddFormView(true);
    };

    (0, _react.useEffect)(function () {
      if (visible) {
        nameInputRef.current.focus();
      } else {
        resetForm();
      }
    }, [alignElement, nameInputRef, visible]);
    return _react["default"].createElement(_Popover["default"], {
      alignElement: alignElement,
      className: "".concat(className, " mw-100"),
      content: function content() {
        return _react["default"].createElement(_form["default"], {
          onSubmit: function onSubmit(event) {
            event.preventDefault();
            handleSubmit();
          }
        }, _react["default"].createElement("div", {
          className: "form-group ".concat(hasError ? 'has-error' : '', " mb-2")
        }, _react["default"].createElement("label", {
          htmlFor: "customObjectNameInput"
        }, Liferay.Language.get('name'), _react["default"].createElement("span", {
          className: "reference-mark"
        }, _react["default"].createElement(_icon["default"], {
          symbol: "asterisk"
        }))), _react["default"].createElement(_form.ClayInput, {
          className: "form-control",
          id: "customObjectNameInput",
          onInput: function onInput(_ref2) {
            var currentTarget = _ref2.currentTarget;
            return validate(currentTarget.value);
          },
          ref: nameInputRef,
          type: "text"
        }), hasError && _react["default"].createElement(_form["default"].FeedbackGroup, null, _react["default"].createElement(_form["default"].FeedbackItem, null, _react["default"].createElement("strong", null, _react["default"].createElement(_form["default"].FeedbackIndicator, {
          className: "mr-1",
          symbol: "exclamation-full"
        }), Liferay.Language.get('this-field-is-required'))))), _react["default"].createElement(_form.ClayCheckbox, {
          "aria-label": Liferay.Language.get('continue-and-create-form-view'),
          checked: isAddFormView,
          label: Liferay.Language.get('continue-and-create-form-view'),
          onChange: function onChange() {
            return setAddFormView(!isAddFormView);
          }
        }));
      },
      footer: function footer() {
        return _react["default"].createElement("div", {
          className: "border-top p-3",
          style: {
            width: 450
          }
        }, _react["default"].createElement("div", {
          className: "d-flex justify-content-end"
        }, _react["default"].createElement(_Button["default"], {
          className: "mr-3",
          displayType: "secondary",
          onClick: function onClick() {
            resetForm();
            onCancel();
          },
          small: true
        }, Liferay.Language.get('cancel')), _react["default"].createElement(_Button["default"], {
          onClick: function onClick() {
            return handleSubmit();
          },
          small: true
        }, Liferay.Language.get('continue'))));
      },
      ref: forwardRef,
      showArrow: false,
      suggestedPosition: "bottom",
      title: function title() {
        return _react["default"].createElement("h4", {
          className: "m-0"
        }, Liferay.Language.get('new-custom-object'));
      },
      visible: visible
    });
  };

  var _default = _react["default"].forwardRef(function (props, ref) {
    return _react["default"].createElement(CustomObjectPopover, _extends({}, props, {
      forwardRef: ref
    }));
  });

  exports["default"] = _default;
  //# sourceMappingURL=CustomObjectPopover.es.js.map
});
//# sourceMappingURL=CustomObjectPopover.es.js.map