Liferay.Loader.define("app-builder-web@1.0.18/js/pages/custom-object/ListCustomObjects.es", ['module', 'exports', 'require', 'app-builder-web$moment', 'frontend-js-react-web$react', 'app-builder-web$react-router-dom', '../../AppContext.es', '../../components/button/Button.es', '../../components/control-menu/ControlMenu.es', '../../components/list-view/ListView.es', '../../components/permissions/PermissionsModal.es', '../../hooks/index.es', '../../utils/clickOutside.es', '../../utils/client.es', '../entry/PermissionsContext.es', './CustomObjectPopover.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _moment = _interopRequireDefault(require("app-builder-web$moment"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactRouterDom = require("app-builder-web$react-router-dom");

  var _AppContext = require("../../AppContext.es");

  var _Button = _interopRequireDefault(require("../../components/button/Button.es"));

  var _ControlMenu = _interopRequireDefault(require("../../components/control-menu/ControlMenu.es"));

  var _ListView = _interopRequireDefault(require("../../components/list-view/ListView.es"));

  var _PermissionsModal = _interopRequireDefault(require("../../components/permissions/PermissionsModal.es"));

  var _index = require("../../hooks/index.es");

  var _clickOutside = _interopRequireDefault(require("../../utils/clickOutside.es"));

  var _client = require("../../utils/client.es");

  var _PermissionsContext = require("../entry/PermissionsContext.es");

  var _CustomObjectPopover = _interopRequireDefault(require("./CustomObjectPopover.es"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var COLUMNS = [{
    key: 'name',
    sortable: true,
    value: Liferay.Language.get('name')
  }, {
    key: 'dateCreated',
    sortable: true,
    value: Liferay.Language.get('create-date')
  }, {
    asc: false,
    key: 'dateModified',
    sortable: true,
    value: Liferay.Language.get('modified-date')
  }];

  var _default = function _default(_ref) {
    var history = _ref.history;

    var _useContext = (0, _react.useContext)(_AppContext.AppContext),
        basePortletURL = _useContext.basePortletURL;

    var addButtonRef = (0, _react.useRef)();
    var emptyStateButtonRef = (0, _react.useRef)();
    var popoverRef = (0, _react.useRef)();

    var _useState = (0, _react.useState)(addButtonRef.current),
        _useState2 = _slicedToArray(_useState, 2),
        alignElement = _useState2[0],
        setAlignElement = _useState2[1];

    var _useState3 = (0, _react.useState)(false),
        _useState4 = _slicedToArray(_useState3, 2),
        isPopoverVisible = _useState4[0],
        setPopoverVisible = _useState4[1];

    var _useState5 = (0, _react.useState)({
      dataDefinitionId: null,
      endpoint: null
    }),
        _useState6 = _slicedToArray(_useState5, 2),
        customObjectPermissionsModalState = _useState6[0],
        setCustomObjectPermissionsModalState = _useState6[1];

    var onClickAddButton = function onClickAddButton(_ref2) {
      var currentTarget = _ref2.currentTarget;
      setAlignElement(currentTarget);

      if (isPopoverVisible && alignElement !== currentTarget) {
        return;
      }

      setPopoverVisible(!isPopoverVisible);
    };

    var dataDefinitionId = customObjectPermissionsModalState.dataDefinitionId;
    (0, _react.useEffect)(function () {
      if (!dataDefinitionId) {
        return;
      }

      (0, _client.getItem)("/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId, "/data-record-collection")).then(function (_ref6) {
        var dataRecordCollectionId = _ref6.id;
        setCustomObjectPermissionsModalState(function (prevState) {
          return _objectSpread({}, prevState, {
            endpoint: "/o/data-engine/v2.0/data-record-collections/".concat(dataRecordCollectionId, "/permissions")
          });
        });
      });
    }, [dataDefinitionId]);
    (0, _react.useEffect)(function () {
      var handler = function handler(_ref7) {
        var target = _ref7.target;
        var isOutside = (0, _clickOutside["default"])(target, addButtonRef.current, emptyStateButtonRef.current, popoverRef.current);

        if (isOutside) {
          setPopoverVisible(false);
        }
      };

      window.addEventListener('click', handler);
      return function () {
        return window.removeEventListener('click', handler);
      };
    }, [addButtonRef, emptyStateButtonRef, popoverRef]);
    (0, _index.useKeyDown)(function () {
      if (isPopoverVisible) {
        setPopoverVisible(false);
      }
    }, 27);
    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_ControlMenu["default"], {
      title: Liferay.Language.get('javax.portlet.title.com_liferay_app_builder_web_internal_portlet_CustomObjectsPortlet'),
      tooltip: Liferay.Language.get('javax.portlet.description.com_liferay_app_builder_web_internal_portlet_CustomObjectsPortlet')
    }), _react["default"].createElement(_ListView["default"], {
      actions: [{
        action: function action(_ref8) {
          var id = _ref8.id;
          return Promise.resolve(history.push("/custom-object/".concat(id, "/form-views")));
        },
        name: Liferay.Language.get('form-views')
      }, {
        action: function action(_ref9) {
          var id = _ref9.id;
          return Promise.resolve(history.push("/custom-object/".concat(id, "/table-views")));
        },
        name: Liferay.Language.get('table-views')
      }, {
        action: function action(_ref10) {
          var id = _ref10.id;
          return Promise.resolve(history.push("/custom-object/".concat(id, "/apps")));
        },
        name: Liferay.Language.get('apps')
      }, {
        name: 'divider'
      }, {
        action: function action(_ref11) {
          var id = _ref11.id;
          return Promise.resolve(setCustomObjectPermissionsModalState(function (prevState) {
            return _objectSpread({}, prevState, {
              dataDefinitionId: id
            });
          }));
        },
        name: Liferay.Language.get('app-permissions')
      }, {
        name: 'divider'
      }, {
        action: (0, _client.confirmDelete)('/o/data-engine/v2.0/data-definitions/'),
        name: Liferay.Language.get('delete')
      }],
      addButton: function addButton() {
        return _react["default"].createElement("div", {
          ref: addButtonRef
        }, _react["default"].createElement(_Button["default"], {
          className: "nav-btn nav-btn-monospaced navbar-breakpoint-down-d-none",
          onClick: onClickAddButton,
          symbol: "plus",
          tooltip: Liferay.Language.get('new-custom-object')
        }));
      },
      columns: COLUMNS,
      emptyState: {
        button: function button() {
          return _react["default"].createElement(_Button["default"], {
            displayType: "secondary",
            onClick: onClickAddButton,
            ref: emptyStateButtonRef
          }, Liferay.Language.get('new-custom-object'));
        },
        description: Liferay.Language.get('custom-objects-define-the-types-of-data-your-business-application-needs'),
        title: Liferay.Language.get('there-are-no-custom-objects-yet')
      },
      endpoint: "/o/data-engine/v2.0/data-definitions/by-content-type/app-builder"
    }, function (item) {
      return _objectSpread({}, item, {
        dateCreated: (0, _moment["default"])(item.dateCreated).fromNow(),
        dateModified: (0, _moment["default"])(item.dateModified).fromNow(),
        name: _react["default"].createElement(_reactRouterDom.Link, {
          to: "/custom-object/".concat(item.id, "/form-views")
        }, item.name.en_US)
      });
    }), _react["default"].createElement(_CustomObjectPopover["default"], {
      alignElement: alignElement,
      onCancel: function onCancel() {
        return setPopoverVisible(false);
      },
      onSubmit: function onSubmit(_ref3) {
        var isAddFormView = _ref3.isAddFormView,
            name = _ref3.name;

        (0, _client.addItem)("/o/data-engine/v2.0/data-definitions/by-content-type/app-builder", {
          availableLanguageIds: ['en_US'],
          dataDefinitionFields: [],
          name: {
            value: name
          }
        }).then(function (_ref4) {
          var id = _ref4.id;

          if (isAddFormView) {
            Liferay.Util.navigate(Liferay.Util.PortletURL.createRenderURL(basePortletURL, {
              dataDefinitionId: id,
              mvcRenderCommandName: '/edit_form_view',
              newCustomObject: true
            }));
          } else {
            history.push("/custom-object/".concat(id, "/form-views/"));
          }
        });
      },
      ref: popoverRef,
      visible: isPopoverVisible
    }), _react["default"].createElement(_PermissionsModal["default"], {
      actions: [{
        key: _PermissionsContext.ACTIONS.ADD_DATA_RECORD,
        sortable: false,
        value: Liferay.Language.get('add-entry')
      }, {
        key: _PermissionsContext.ACTIONS.DELETE_DATA_RECORD,
        sortable: false,
        value: Liferay.Language.get('delete-entry')
      }, {
        key: _PermissionsContext.ACTIONS.UPDATE_DATA_RECORD,
        sortable: false,
        value: Liferay.Language.get('update-entry')
      }, {
        key: _PermissionsContext.ACTIONS.VIEW_DATA_RECORD,
        sortable: false,
        value: Liferay.Language.get('view-entries')
      }],
      endpoint: customObjectPermissionsModalState.endpoint,
      isOpen: dataDefinitionId !== null,
      onClose: function onClose() {
        return setCustomObjectPermissionsModalState({
          dataDefinitionId: null,
          endpoint: null
        });
      },
      onSave: function onSave(permissions) {
        var dataDefinitionPermissions = [];
        Object.values(permissions).forEach(function (_ref12) {
          var actionIds = _ref12.actionIds,
              roleName = _ref12.roleName;

          if (actionIds.length > 0) {
            dataDefinitionPermissions.push({
              actionIds: [_PermissionsContext.ACTIONS.VIEW],
              roleName: roleName
            });
          }
        });
        return (0, _client.updateItem)("/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId, "/permissions"), dataDefinitionPermissions);
      },
      rolesFilter: function rolesFilter(_ref5) {
        var name = _ref5.name,
            roleType = _ref5.roleType;
        return name !== 'Administrator' && name !== 'Guest' && name !== 'Owner' && roleType !== 'organization' && roleType !== 'site';
      },
      title: Liferay.Language.get('app-permissions')
    }));
  };

  exports["default"] = _default;
  //# sourceMappingURL=ListCustomObjects.es.js.map
});
//# sourceMappingURL=ListCustomObjects.es.js.map