Liferay.Loader.define("app-builder-web@1.0.18/js/pages/form-view/CustomObjectFieldsList.es", ['module', 'exports', 'require', 'data-engine-taglib', 'frontend-js-react-web$react', '../../hooks/useDoubleClick.es', './DataLayoutBuilderInstanceContext.es', './FormViewContext.es', './useDeleteDefinitionField.es', './useDeleteDefinitionFieldModal.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _dataEngineTaglib = require("data-engine-taglib");

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _useDoubleClick3 = _interopRequireDefault(require("../../hooks/useDoubleClick.es"));

  var _DataLayoutBuilderInstanceContext = _interopRequireDefault(require("./DataLayoutBuilderInstanceContext.es"));

  var _FormViewContext = _interopRequireDefault(require("./FormViewContext.es"));

  var _useDeleteDefinitionField = _interopRequireDefault(require("./useDeleteDefinitionField.es"));

  var _useDeleteDefinitionFieldModal = _interopRequireDefault(require("./useDeleteDefinitionFieldModal.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var getFieldTypes = function getFieldTypes(_ref) {
    var dataDefinition = _ref.dataDefinition,
        dataLayout = _ref.dataLayout,
        fieldTypes = _ref.fieldTypes,
        focusedCustomObjectField = _ref.focusedCustomObjectField;
    var dataDefinitionFields = [];
    var dataLayoutPages = dataLayout.dataLayoutPages;

    _dataEngineTaglib.DataDefinitionUtils.forEachDataDefinitionField(dataDefinition, function (_ref2) {
      var fieldType = _ref2.fieldType,
          label = _ref2.label,
          name = _ref2.name;

      if (fieldType === 'section') {
        return;
      }

      var fieldTypeSettings = fieldTypes.find(function (_ref3) {
        var name = _ref3.name;
        return name === fieldType;
      });
      dataDefinitionFields.push({
        active: name === focusedCustomObjectField.name,
        className: 'custom-object-field',
        description: fieldTypeSettings.label,
        disabled: _dataEngineTaglib.DataLayoutVisitor.containsField(dataLayoutPages, name),
        dragAlignment: 'right',
        dragType: _dataEngineTaglib.DragTypes.DRAG_DATA_DEFINITION_FIELD,
        icon: fieldTypeSettings.icon,
        label: label.en_US,
        name: name
      });
    });

    return dataDefinitionFields;
  };

  var _default = function _default(_ref4) {
    var keywords = _ref4.keywords;

    var _useContext = (0, _react.useContext)(_DataLayoutBuilderInstanceContext["default"]),
        _useContext2 = _slicedToArray(_useContext, 1),
        dataLayoutBuilder = _useContext2[0];

    var _useContext3 = (0, _react.useContext)(_FormViewContext["default"]),
        _useContext4 = _slicedToArray(_useContext3, 2),
        state = _useContext4[0],
        dispatch = _useContext4[1];

    var dataDefinition = state.dataDefinition;
    var dataDefinitionFields = dataDefinition.dataDefinitionFields;
    var fieldTypes = getFieldTypes(state);

    var _useDoubleClick = (0, _useDoubleClick3["default"])(function onClick(_ref5) {
      var name = _ref5.name;
      var dataDefinitionField = dataDefinitionFields.find(function (_ref6) {
        var currentName = _ref6.name;
        return currentName === name;
      });
      dispatch({
        payload: {
          dataDefinitionField: dataDefinitionField
        },
        type: _dataEngineTaglib.DataLayoutBuilderActions.UPDATE_FOCUSED_CUSTOM_OBJECT_FIELD
      });
    }, function onDoubleClick(_ref7) {
      var name = _ref7.name;

      var _dataLayoutBuilder$ge = dataLayoutBuilder.getStore(),
          activePage = _dataLayoutBuilder$ge.activePage,
          pages = _dataLayoutBuilder$ge.pages;

      dataLayoutBuilder.dispatch('fieldAdded', _dataEngineTaglib.DataLayoutBuilderActions.dropCustomObjectField({
        addedToPlaceholder: true,
        dataDefinition: dataDefinition,
        dataDefinitionFieldName: name,
        dataLayoutBuilder: dataLayoutBuilder,
        indexes: {
          columnIndex: 0,
          pageIndex: activePage,
          rowIndex: pages[activePage].rows.length
        }
      }));
    }),
        _useDoubleClick2 = _slicedToArray(_useDoubleClick, 2),
        handleOnClick = _useDoubleClick2[0],
        handleOnDoubleClick = _useDoubleClick2[1];

    var deleteField = (0, _useDeleteDefinitionField["default"])({
      dataLayoutBuilder: dataLayoutBuilder
    });
    var onDeleteDefinitionField = (0, _useDeleteDefinitionFieldModal["default"])(function (fieldName) {
      return deleteField(fieldName);
    });
    return _react["default"].createElement(_dataEngineTaglib.FieldTypeList, {
      deleteLabel: Liferay.Language.get('delete-from-object'),
      fieldTypes: fieldTypes,
      keywords: keywords,
      onClick: handleOnClick,
      onDelete: onDeleteDefinitionField,
      onDoubleClick: handleOnDoubleClick
    });
  };

  exports["default"] = _default;
  //# sourceMappingURL=CustomObjectFieldsList.es.js.map
});
//# sourceMappingURL=CustomObjectFieldsList.es.js.map