Liferay.Loader.define("app-builder-web@1.0.18/js/pages/table-view/ColumnOverlay.es", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web', 'frontend-js-metal-web$metal-dom', 'frontend-js-react-web$react', '../../components/button/Button.es', '../../hooks/index.es', '../../utils/clickOutside.es', './EditTableViewContext.es', './utils.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _Button = _interopRequireDefault(require("../../components/button/Button.es"));

  var _index = require("../../hooks/index.es");

  var _clickOutside = _interopRequireDefault(require("../../utils/clickOutside.es"));

  var _EditTableViewContext = _interopRequireWildcard(require("./EditTableViewContext.es"));

  var _utils = require("./utils.es");

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var getStyle = function getStyle(container, index) {
    var columnNode = (0, _utils.getColumnNode)(container, index);
    return {
      height: container.offsetHeight,
      left: columnNode.offsetLeft,
      position: 'absolute',
      top: container.offsetTop,
      width: columnNode.offsetWidth
    };
  };

  var Overlay = function Overlay(_ref) {
    var container = _ref.container,
        fieldType = _ref.fieldType,
        index = _ref.index,
        name = _ref.name,
        onRemoveFieldName = _ref.onRemoveFieldName,
        selected = _ref.selected,
        total = _ref.total;

    var _useContext = (0, _react.useContext)(_EditTableViewContext["default"]),
        _useContext2 = _slicedToArray(_useContext, 1),
        fieldTypes = _useContext2[0].fieldTypes;

    var _useState = (0, _react.useState)({}),
        _useState2 = _slicedToArray(_useState, 2),
        style = _useState2[0],
        setStyle = _useState2[1];

    var fieldTypeLabel = (0, _utils.getFieldTypeLabel)(fieldTypes, fieldType);
    (0, _frontendJsReactWeb.useEventListener)('resize', function () {
      setStyle(getStyle(container, index));
    }, true, window);
    (0, _react.useLayoutEffect)(function () {
      setStyle(getStyle(container, index));
    }, [container, index, total]);
    return _react["default"].createElement("div", {
      className: (0, _classnames["default"])('column-overlay', {
        selected: selected
      }),
      style: style
    }, _react["default"].createElement("header", null, _react["default"].createElement("label", null, fieldTypeLabel), _react["default"].createElement(_Button["default"], {
      borderless: true,
      displayType: "secondary",
      onClick: function onClick() {
        return onRemoveFieldName(name);
      },
      symbol: "times-circle",
      tooltip: Liferay.Language.get('remove')
    })));
  };

  var _default = function _default(_ref2) {
    var container = _ref2.container,
        fields = _ref2.fields,
        onRemoveFieldName = _ref2.onRemoveFieldName;

    var _useContext3 = (0, _react.useContext)(_EditTableViewContext["default"]),
        _useContext4 = _slicedToArray(_useContext3, 2),
        focusedColumn = _useContext4[0].focusedColumn,
        dispatch = _useContext4[1];

    var _useState3 = (0, _react.useState)(null),
        _useState4 = _slicedToArray(_useState3, 2),
        hoveredFieldName = _useState4[0],
        setHoveredFieldName = _useState4[1];

    (0, _frontendJsReactWeb.useEventListener)('click', function (_ref3) {
      var target = _ref3.target;
      var columnIndex = (0, _utils.getColumnIndex)(target);

      if (columnIndex > -1 && columnIndex < fields.length) {
        var _fields$find = fields.find(function (field, index) {
          return index === columnIndex;
        }),
            name = _fields$find.name;

        dispatch({
          payload: {
            fieldName: name
          },
          type: _EditTableViewContext.UPDATE_FOCUSED_COLUMN
        });
      }
    }, true, container);
    (0, _frontendJsReactWeb.useEventListener)('click', function (_ref4) {
      var target = _ref4.target;

      if ((0, _clickOutside["default"])(target, container, '.data-layout-builder-sidebar', '.dropdown-menu')) {
        dispatch({
          payload: {
            fieldName: null
          },
          type: _EditTableViewContext.UPDATE_FOCUSED_COLUMN
        });
      }
    }, true, window);
    (0, _frontendJsReactWeb.useEventListener)('mouseleave', function (_ref5) {
      var relatedTarget = _ref5.relatedTarget;
      var columnIndex = (0, _utils.getColumnIndex)(relatedTarget);
      var outsideOverlay = !_metalDom["default"].closest(relatedTarget, '.column-overlay');

      if (columnIndex === -1 && outsideOverlay) {
        setHoveredFieldName(null);
      }
    }, true, container);
    (0, _frontendJsReactWeb.useEventListener)('mouseenter', function (_ref6) {
      var target = _ref6.target;
      var columnIndex = (0, _utils.getColumnIndex)(target);

      if (columnIndex > -1 && columnIndex < fields.length) {
        var _fields$find2 = fields.find(function (field, index) {
          return index === columnIndex;
        }),
            name = _fields$find2.name;

        setHoveredFieldName(name);
      }
    }, true, container);
    (0, _index.useKeyDown)(function () {
      if (focusedColumn) {
        dispatch({
          payload: {
            fieldName: null
          },
          type: _EditTableViewContext.UPDATE_FOCUSED_COLUMN
        });
      }
    }, 27);
    return fields.map(function (_ref7, index) {
      var fieldType = _ref7.fieldType,
          name = _ref7.name;
      return (name === hoveredFieldName || name === focusedColumn) && _react["default"].createElement(Overlay, {
        container: container,
        fieldType: fieldType,
        index: index,
        key: name,
        name: name,
        onRemoveFieldName: onRemoveFieldName,
        selected: name === focusedColumn,
        total: fields.length
      });
    });
  };

  exports["default"] = _default;
  //# sourceMappingURL=ColumnOverlay.es.js.map
});
//# sourceMappingURL=ColumnOverlay.es.js.map