Liferay.Loader.define("app-builder-web@1.0.18/js/pages/table-view/utils.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-dom'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.getFieldTypeLabel = exports.getColumns = exports.getColumnNode = exports.getColumnIndex = void 0;

  var _metalDom = _interopRequireDefault(require("frontend-js-metal-web$metal-dom"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var getColumnIndex = function getColumnIndex(node) {
    var rowNode = _metalDom["default"].closest(node, 'tr');

    if (!rowNode) {
      return -1;
    }

    var columnNode = _metalDom["default"].closest(node, 'td,th');

    if (!columnNode) {
      return -1;
    }

    var scopeId = "".concat(Date.now());
    rowNode.setAttribute('data-scope-uuid', scopeId);
    var columns = rowNode.querySelectorAll("[data-scope-uuid=\"".concat(scopeId, "\"] > ").concat(columnNode.tagName));
    rowNode.removeAttribute('data-scope-uuid');
    return Array.prototype.indexOf.call(columns, columnNode) - 1;
  };

  exports.getColumnIndex = getColumnIndex;

  var getColumnNode = function getColumnNode(container, index) {
    return container.querySelector("table tbody > tr:first-of-type > td:nth-of-type(".concat(index + 2, ")"));
  };

  exports.getColumnNode = getColumnNode;

  var getColumns = function getColumns(container) {
    return container.querySelectorAll("table tbody > tr:first-of-type > td");
  };

  exports.getColumns = getColumns;

  var getFieldTypeLabel = function getFieldTypeLabel(fieldTypes, fieldType) {
    var fieldTypeObject = fieldTypes.find(function (_ref) {
      var name = _ref.name;
      return name === fieldType;
    });

    if (fieldTypeObject) {
      return fieldTypeObject.label;
    }

    return fieldType;
  };

  exports.getFieldTypeLabel = getFieldTypeLabel;
  //# sourceMappingURL=utils.es.js.map
});
//# sourceMappingURL=utils.es.js.map