Liferay.Loader.define('app-builder-web$dnd-core@10.0.1/lib/utils/dirtiness', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    import { intersection } from './js_utils';
    export const NONE = [];
    export const ALL = [];
    NONE.__IS_NONE__ = true;
    ALL.__IS_ALL__ = true;
    /**
     * Determines if the given handler IDs are dirty or not.
     *
     * @param dirtyIds The set of dirty handler ids
     * @param handlerIds The set of handler ids to check
     */
    export function areDirty(dirtyIds, handlerIds) {
        if (dirtyIds === NONE) {
            return false;
        }
        if (dirtyIds === ALL || typeof handlerIds === 'undefined') {
            return true;
        }
        const commonIds = intersection(handlerIds, dirtyIds);
        return commonIds.length > 0;
    }
});
//# sourceMappingURL=dirtiness.js.map