/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @typechecks
 */

'use strict';

Liferay.Loader.define('app-builder-web$fbjs@0.8.17/lib/camelizeStyleName', ['module', 'exports', 'require', './camelize'], function (module, exports, require) {
  var define = undefined;
  var camelize = require('./camelize');

  var msPattern = /^-ms-/;

  /**
   * Camelcases a hyphenated CSS property name, for example:
   *
   *   > camelizeStyleName('background-color')
   *   < "backgroundColor"
   *   > camelizeStyleName('-moz-transition')
   *   < "MozTransition"
   *   > camelizeStyleName('-ms-transition')
   *   < "msTransition"
   *
   * As Andi Smith suggests
   * (http://www.andismith.com/blog/2012/02/modernizr-prefixed/), an `-ms` prefix
   * is converted to lowercase `ms`.
   *
   * @param {string} string
   * @return {string}
   */
  function camelizeStyleName(string) {
    return camelize(string.replace(msPattern, 'ms-'));
  }

  module.exports = camelizeStyleName;
});
//# sourceMappingURL=camelizeStyleName.js.map