/**
 * Copyright 2015-present Facebook. All Rights Reserved.
 *
 * @typechecks
 * 
 */

'use strict';

/**
 * Returns a new Array containing all the element of the source array except
 * `null` and `undefined` ones. This brings the benefit of strong typing over
 * `Array.prototype.filter`.
 */

Liferay.Loader.define('app-builder-web$fbjs@0.8.17/lib/compactArray', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  function compactArray(array) {
    var result = [];
    for (var i = 0; i < array.length; ++i) {
      var elem = array[i];
      if (elem != null) {
        result.push(elem);
      }
    }
    return result;
  }

  module.exports = compactArray;
});
//# sourceMappingURL=compactArray.js.map