Liferay.Loader.define('app-builder-web$lodash-es@4.17.11/_baseWrapperValue', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import LazyWrapper from './_LazyWrapper.js';
  import arrayPush from './_arrayPush.js';
  import arrayReduce from './_arrayReduce.js';

  /**
   * The base implementation of `wrapperValue` which returns the result of
   * performing a sequence of actions on the unwrapped `value`, where each
   * successive action is supplied the return value of the previous.
   *
   * @private
   * @param {*} value The unwrapped value.
   * @param {Array} actions Actions to perform to resolve the unwrapped value.
   * @returns {*} Returns the resolved value.
   */
  function baseWrapperValue(value, actions) {
    var result = value;
    if (result instanceof LazyWrapper) {
      result = result.value();
    }
    return arrayReduce(actions, function (result, action) {
      return action.func.apply(action.thisArg, arrayPush([result], action.args));
    }, result);
  }

  export default baseWrapperValue;
});
//# sourceMappingURL=_baseWrapperValue.js.map