Liferay.Loader.define('app-builder-web$moment@2.24.0/locale/ro', ['module', 'exports', 'require', '../moment'], function (module, exports, require) {
    var define = undefined;
    (function (global, factory) {
        typeof exports === 'object' && typeof module !== 'undefined' && typeof require === 'function' ? factory(require('../moment')) : typeof define === 'function' && define.amd ? define(['../moment'], factory) : factory(global.moment);
    })(this, function (moment) {
        'use strict';

        function relativeTimeWithPlural(number, withoutSuffix, key) {
            var separator = ' ';
            if (number % 100 >= 20 || number >= 100 && number % 100 === 0) {
                separator = ' de ';
            }
            return number + separator + {
                'ss': 'secunde',
                'mm': 'minute',
                'hh': 'ore',
                'dd': 'zile',
                'MM': 'luni',
                'yy': 'ani'
            }[key];
        }

        var ro = moment.defineLocale('ro', {
            months: 'ianuarie_februarie_martie_aprilie_mai_iunie_iulie_august_septembrie_octombrie_noiembrie_decembrie'.split('_'),
            monthsShort: 'ian._febr._mart._apr._mai_iun._iul._aug._sept._oct._nov._dec.'.split('_'),
            monthsParseExact: true,
            weekdays: 'duminică_luni_marți_miercuri_joi_vineri_sâmbătă'.split('_'),
            weekdaysShort: 'Dum_Lun_Mar_Mie_Joi_Vin_Sâm'.split('_'),
            weekdaysMin: 'Du_Lu_Ma_Mi_Jo_Vi_Sâ'.split('_'),
            longDateFormat: {
                LT: 'H:mm',
                LTS: 'H:mm:ss',
                L: 'DD.MM.YYYY',
                LL: 'D MMMM YYYY',
                LLL: 'D MMMM YYYY H:mm',
                LLLL: 'dddd, D MMMM YYYY H:mm'
            },
            calendar: {
                sameDay: '[azi la] LT',
                nextDay: '[mâine la] LT',
                nextWeek: 'dddd [la] LT',
                lastDay: '[ieri la] LT',
                lastWeek: '[fosta] dddd [la] LT',
                sameElse: 'L'
            },
            relativeTime: {
                future: 'peste %s',
                past: '%s în urmă',
                s: 'câteva secunde',
                ss: relativeTimeWithPlural,
                m: 'un minut',
                mm: relativeTimeWithPlural,
                h: 'o oră',
                hh: relativeTimeWithPlural,
                d: 'o zi',
                dd: relativeTimeWithPlural,
                M: 'o lună',
                MM: relativeTimeWithPlural,
                y: 'un an',
                yy: relativeTimeWithPlural
            },
            week: {
                dow: 1, // Monday is the first day of the week.
                doy: 7 // The week that contains Jan 7th is the first week of the year.
            }
        });

        return ro;
    }); //! moment.js locale configuration
});
//# sourceMappingURL=ro.js.map