Liferay.Loader.define("app-builder-web@1.0.2/js/components/control-menu/ControlMenu.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', 'frontend-js-react-web$react-dom', 'app-builder-web$react-router-dom', '../../AppContext.es', '../button/Button.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.ControlMenuBase = exports.PortalControlMenu = exports.InlineControlMenu = void 0;

  var _dropDown = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/drop-down"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactDom = require("frontend-js-react-web$react-dom");

  var _reactRouterDom = require("app-builder-web$react-router-dom");

  var _AppContext = require("../../AppContext.es");

  var _Button = _interopRequireDefault(require("../button/Button.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }return target;
    };return _extends.apply(this, arguments);
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
      }
    }return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
    }return target;
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var Item = _dropDown["default"].Item,
      ItemList = _dropDown["default"].ItemList;

  var ActionsMenu = function ActionsMenu(_ref) {
    var actions = _ref.actions;

    var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        active = _useState2[0],
        setActive = _useState2[1];

    if (!actions || actions.length === 0) {
      return _react["default"].createElement(_react["default"].Fragment, null);
    }

    return (0, _reactDom.createPortal)(_react["default"].createElement(_dropDown["default"], {
      active: active,
      alignmentPosition: _dropDown.Align.TopLeft,
      className: "lfr-icon-menu portlet-options",
      onActiveChange: function onActiveChange(newActive) {
        return setActive(newActive);
      },
      trigger: _react["default"].createElement(_Button["default"], {
        displayType: "unstyled"
      }, _react["default"].createElement("span", {
        className: "icon-monospaced"
      }, _react["default"].createElement(_icon["default"], {
        symbol: "ellipsis-v"
      })))
    }, _react["default"].createElement(ItemList, null, actions.map(function (_ref2, index) {
      var action = _ref2.action,
          name = _ref2.name;
      return _react["default"].createElement(Item, {
        key: index,
        onClick: function onClick(event) {
          event.preventDefault();
          setActive(false);

          if (action) {
            action();
          }
        }
      }, name);
    }))), document.querySelector('li.control-menu-nav-category.user-control-group > ul > li > div.control-menu-icon'));
  };

  var BackButton = function BackButton(_ref3) {
    var backURL = _ref3.backURL;
    var Link = backURL && backURL.startsWith('http') ? ExternalLink : _reactRouterDom.Link;
    return (0, _reactDom.createPortal)(_react["default"].createElement("li", {
      className: "control-menu-nav-item"
    }, _react["default"].createElement(Link, {
      className: "control-menu-icon lfr-icon-item",
      tabIndex: 1,
      to: backURL
    }, _react["default"].createElement("span", {
      className: "icon-monospaced"
    }, _react["default"].createElement(_icon["default"], {
      symbol: "angle-left"
    })))), document.querySelector('.sites-control-group .control-menu-nav'));
  };

  var ExternalLink = function ExternalLink(_ref4) {
    var children = _ref4.children,
        to = _ref4.to,
        props = _objectWithoutProperties(_ref4, ["children", "to"]);

    return _react["default"].createElement("a", _extends({
      href: to
    }, props), children);
  };

  var resolveBackURL = function resolveBackURL(backURL, url) {
    if (backURL === '../') {
      var paths = url.split('/');
      paths.pop();
      backURL = paths.join('/');
    }

    return backURL;
  };

  var setDocumentTitle = function setDocumentTitle(title) {
    if (title) {
      var titles = document.title.split(' - ');
      titles[0] = title;
      document.title = titles.join(' - ');
    }
  };

  var InlineControlMenu = function InlineControlMenu(_ref5) {
    var backURL = _ref5.backURL,
        title = _ref5.title,
        tooltip = _ref5.tooltip,
        url = _ref5.url;

    var _useContext = (0, _react.useContext)(_AppContext.AppContext),
        appDeploymentType = _useContext.appDeploymentType,
        controlMenuElementId = _useContext.controlMenuElementId;

    backURL = resolveBackURL(backURL, url);
    var Link = backURL && backURL.startsWith('http') ? ExternalLink : _reactRouterDom.Link;
    var controlMenuElement = document.getElementById(controlMenuElementId);

    var ControlMenu = function ControlMenu() {
      return _react["default"].createElement("div", {
        className: (0, _classnames["default"])('app-builder-control-menu', appDeploymentType)
      }, backURL && _react["default"].createElement(Link, {
        className: (0, _classnames["default"])('control-menu-back-button', appDeploymentType),
        tabIndex: 1,
        to: backURL
      }, _react["default"].createElement("span", {
        className: "icon-monospaced"
      }, _react["default"].createElement(_icon["default"], {
        symbol: "angle-left"
      }))), title && _react["default"].createElement("span", {
        className: (0, _classnames["default"])('control-menu-title', appDeploymentType)
      }, title), tooltip && _react["default"].createElement("span", {
        className: "lfr-portal-tooltip taglib-icon-help",
        "data-title": tooltip
      }, _react["default"].createElement(_icon["default"], {
        symbol: "question-circle-full"
      })));
    };

    return controlMenuElement ? (0, _reactDom.createPortal)(_react["default"].createElement(ControlMenu, null), controlMenuElement) : _react["default"].createElement(ControlMenu, null);
  };

  exports.InlineControlMenu = InlineControlMenu;

  var PortalControlMenu = function PortalControlMenu(_ref6) {
    var actions = _ref6.actions,
        backURL = _ref6.backURL,
        title = _ref6.title,
        tooltip = _ref6.tooltip,
        url = _ref6.url;
    backURL = resolveBackURL(backURL, url);
    (0, _react.useEffect)(function () {
      document.querySelector('.tools-control-group .control-menu-level-1-heading').innerHTML = title;
    }, [title]);
    (0, _react.useEffect)(function () {
      var tooltipNode = document.querySelector('.tools-control-group .taglib-icon-help');

      if (!tooltipNode) {
        return;
      }

      if (tooltip) {
        tooltipNode.classList.remove('hide');
        tooltipNode.setAttribute('title', tooltip);
      } else {
        tooltipNode.classList.add('hide');
      }
    }, [tooltip]);
    return _react["default"].createElement(_react["default"].Fragment, null, backURL && _react["default"].createElement(BackButton, {
      backURL: backURL
    }), actions && _react["default"].createElement(ActionsMenu, {
      actions: actions
    }));
  };

  exports.PortalControlMenu = PortalControlMenu;

  var ControlMenuBase = function ControlMenuBase(props) {
    (0, _react.useEffect)(function () {
      setDocumentTitle(props.title);
    }, [props.title]);

    var _useContext2 = (0, _react.useContext)(_AppContext.AppContext),
        appDeploymentType = _useContext2.appDeploymentType;

    if (appDeploymentType && (appDeploymentType === 'standalone' || appDeploymentType === 'widget')) {
      return _react["default"].createElement(InlineControlMenu, props);
    } else {
      return _react["default"].createElement(PortalControlMenu, props);
    }
  };

  exports.ControlMenuBase = ControlMenuBase;

  var _default = (0, _reactRouterDom.withRouter)(function (_ref7) {
    var url = _ref7.match.url,
        props = _objectWithoutProperties(_ref7, ["match"]);

    return _react["default"].createElement(ControlMenuBase, _extends({}, props, {
      url: url
    }));
  });

  exports["default"] = _default;
  //# sourceMappingURL=ControlMenu.es.js.map
});
//# sourceMappingURL=ControlMenu.es.js.map