Liferay.Loader.define("app-builder-web@1.0.2/js/components/sidebar/Sidebar.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/form', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../button/Button.es', '../management-toolbar/search/SearchInput.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.SidebarTabContent = exports.SidebarTab = exports.SidebarSearchInput = exports.SidebarHeader = exports.SidebarFooter = exports.SidebarBody = exports["default"] = void 0;

  var _button = require("@frontend-taglib-clay$clayui/button");

  var _form = _interopRequireDefault(require("@frontend-taglib-clay$clayui/form"));

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _Button = _interopRequireDefault(require("../button/Button.es"));

  var _SearchInput = _interopRequireDefault(require("../management-toolbar/search/SearchInput.es"));

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var Sidebar = _react["default"].forwardRef(function (_ref, ref) {
    var children = _ref.children,
        _ref$closeable = _ref.closeable,
        closeable = _ref$closeable === void 0 ? true : _ref$closeable,
        _ref$closed = _ref.closed,
        closed = _ref$closed === void 0 ? false : _ref$closed,
        _ref$onSearch = _ref.onSearch,
        onSearch = _ref$onSearch === void 0 ? null : _ref$onSearch,
        _ref$onToggle = _ref.onToggle,
        onToggle = _ref$onToggle === void 0 ? function () {} : _ref$onToggle;

    var _useState = (0, _react.useState)(closed),
        _useState2 = _slicedToArray(_useState, 2),
        isClosed = _useState2[0],
        setClosed = _useState2[1];

    var handleToggle = function handleToggle() {
      var closed = !isClosed;
      setClosed(closed);
      onToggle(closed);
    };

    (0, _react.useEffect)(function () {
      setClosed(closed);
    }, [closed]);
    return _react["default"].createElement("div", {
      ref: ref
    }, _react["default"].createElement("div", {
      className: (0, _classnames["default"])('app-builder-sidebar', 'main', {
        closed: isClosed
      })
    }, _react["default"].createElement("div", {
      className: "sidebar sidebar-light"
    }, (closeable || onSearch) && _react["default"].createElement(_form["default"], {
      onSubmit: function onSubmit(event) {
        return event.preventDefault();
      }
    }, _react["default"].createElement(SidebarSearchInput, {
      closeable: closeable,
      onSearch: onSearch,
      onToggle: handleToggle
    })), children)), closeable && _react["default"].createElement("div", {
      className: (0, _classnames["default"])('app-builder-sidebar', 'mini', {
        closed: !isClosed
      })
    }, _react["default"].createElement(_Button["default"], {
      displayType: "secondary",
      onClick: handleToggle,
      symbol: "angle-left"
    })));
  });

  var SidebarBody = function SidebarBody(_ref2) {
    var children = _ref2.children,
        className = _ref2.className;
    return _react["default"].createElement("div", {
      className: (0, _classnames["default"])(className, 'sidebar-body')
    }, children);
  };

  exports.SidebarBody = SidebarBody;

  var SidebarFooter = function SidebarFooter(_ref3) {
    var children = _ref3.children;
    return _react["default"].createElement("div", {
      className: "sidebar-footer"
    }, children);
  };

  exports.SidebarFooter = SidebarFooter;

  var SidebarHeader = function SidebarHeader(_ref4) {
    var children = _ref4.children,
        className = _ref4.className;
    return _react["default"].createElement("div", {
      className: (0, _classnames["default"])(className, 'sidebar-header')
    }, children);
  };

  exports.SidebarHeader = SidebarHeader;

  var SidebarSearchInput = function SidebarSearchInput(_ref5) {
    var closeable = _ref5.closeable,
        onSearch = _ref5.onSearch,
        onToggle = _ref5.onToggle;
    return _react["default"].createElement(SidebarHeader, null, _react["default"].createElement("div", {
      className: "autofit-row sidebar-section"
    }, _react["default"].createElement("div", {
      className: "autofit-col autofit-col-expand"
    }, onSearch && _react["default"].createElement(_SearchInput["default"], {
      onChange: function onChange(searchText) {
        return onSearch(searchText);
      }
    })), _react["default"].createElement("div", {
      className: "autofit-col ml-2"
    }, closeable && _react["default"].createElement(_button.ClayButtonWithIcon, {
      displayType: "secondary",
      onClick: onToggle,
      symbol: "angle-right"
    }))));
  };

  exports.SidebarSearchInput = SidebarSearchInput;

  var SidebarTab = function SidebarTab(_ref6) {
    var tabs = _ref6.tabs;
    return _react["default"].createElement("nav", {
      className: "component-tbar tbar"
    }, _react["default"].createElement("div", {
      className: "container-fluid"
    }, _react["default"].createElement("ul", {
      className: "nav nav-underline",
      role: "tablist"
    }, tabs.map(function (_ref7, index) {
      var active = _ref7.active,
          label = _ref7.label,
          _onClick = _ref7.onClick;
      return _react["default"].createElement("li", {
        className: "nav-item",
        key: index
      }, _react["default"].createElement("a", {
        className: (0, _classnames["default"])('nav-link', {
          active: active
        }),
        "data-senna-off": true,
        href: "",
        onClick: function onClick(event) {
          event.preventDefault();

          if (_onClick) {
            _onClick(index);
          }
        },
        role: "tab"
      }, label));
    }))));
  };

  exports.SidebarTab = SidebarTab;

  var SidebarTabContent = function SidebarTabContent(_ref8) {
    var children = _ref8.children;
    return _react["default"].createElement("div", {
      className: "tab-content"
    }, _react["default"].createElement("div", {
      className: "active fade mt-3 show tab-pane",
      role: "tabpanel"
    }, children));
  };

  exports.SidebarTabContent = SidebarTabContent;
  Sidebar.Body = SidebarBody;
  Sidebar.Footer = SidebarFooter;
  Sidebar.Header = SidebarHeader;
  Sidebar.SearchInput = SidebarSearchInput;
  Sidebar.Tab = SidebarTab;
  Sidebar.TabContent = SidebarTabContent;
  var _default = Sidebar;
  exports["default"] = _default;
  //# sourceMappingURL=Sidebar.es.js.map
});
//# sourceMappingURL=Sidebar.es.js.map