Liferay.Loader.define("app-builder-web@1.0.2/js/pages/app/EditAppContext.es", ['module', 'exports', 'require', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.reducer = exports.UPDATE_SETTINGS_SCOPE = exports.UPDATE_NAME = exports.UPDATE_DATA_LIST_VIEW_ID = exports.UPDATE_DATA_LAYOUT_ID = exports.UPDATE_APP = exports.TOGGLE_SETTINGS_SITE_ID = exports.SITE_ID_ALL = exports.REMOVE_DEPLOYMENT = exports.PRODUCT_MENU = exports.ADD_DEPLOYMENT = void 0;

  var _react = require("frontend-js-react-web$react");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(source, true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(source).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var ADD_DEPLOYMENT = 'ADD_DEPLOYMENT';
  exports.ADD_DEPLOYMENT = ADD_DEPLOYMENT;
  var PRODUCT_MENU = 'productMenu';
  exports.PRODUCT_MENU = PRODUCT_MENU;
  var REMOVE_DEPLOYMENT = 'REMOVE_DEPLOYMENT';
  exports.REMOVE_DEPLOYMENT = REMOVE_DEPLOYMENT;
  var SITE_ID_ALL = -1;
  exports.SITE_ID_ALL = SITE_ID_ALL;
  var TOGGLE_SETTINGS_SITE_ID = 'TOGGLE_SETTINGS_SITE_ID';
  exports.TOGGLE_SETTINGS_SITE_ID = TOGGLE_SETTINGS_SITE_ID;
  var UPDATE_APP = 'UPDATE_APP';
  exports.UPDATE_APP = UPDATE_APP;
  var UPDATE_DATA_LAYOUT_ID = 'UPDATE_DATA_LAYOUT_ID';
  exports.UPDATE_DATA_LAYOUT_ID = UPDATE_DATA_LAYOUT_ID;
  var UPDATE_DATA_LIST_VIEW_ID = 'UPDATE_DATA_LIST_VIEW_ID';
  exports.UPDATE_DATA_LIST_VIEW_ID = UPDATE_DATA_LIST_VIEW_ID;
  var UPDATE_NAME = 'UPDATE_NAME';
  exports.UPDATE_NAME = UPDATE_NAME;
  var UPDATE_SETTINGS_SCOPE = 'UPDATE_SETTINGS_SCOPE';
  exports.UPDATE_SETTINGS_SCOPE = UPDATE_SETTINGS_SCOPE;

  var uppdateAppDeployment = function uppdateAppDeployment(state, appDeploymentType, appDeployment) {
    return _objectSpread({}, state, {
      app: _objectSpread({}, state.app, {
        appDeployments: state.app.appDeployments.filter(function (appDeployment) {
          return appDeployment.type !== appDeploymentType;
        }).concat(appDeployment)
      })
    });
  };

  var reducer = function reducer(state, action) {
    switch (action.type) {
      case ADD_DEPLOYMENT:
        {
          var settings = {};

          if (action.deploymentType == PRODUCT_MENU) {
            settings = {
              scope: ['control_panel']
            };
          }

          return _objectSpread({}, state, {
            app: _objectSpread({}, state.app, {
              appDeployments: state.app.appDeployments.concat({
                settings: settings,
                type: action.deploymentType
              })
            })
          });
        }

      case REMOVE_DEPLOYMENT:
        {
          return _objectSpread({}, state, {
            app: _objectSpread({}, state.app, {
              appDeployments: state.app.appDeployments.filter(function (appDeployment) {
                return appDeployment.type !== action.deploymentType;
              })
            })
          });
        }

      case TOGGLE_SETTINGS_SITE_ID:
        {
          var appDeployment = state.app.appDeployments.find(function (appDeployment) {
            return appDeployment.type === PRODUCT_MENU;
          });
          var _appDeployment$settin = appDeployment.settings.siteIds,
              siteIds = _appDeployment$settin === void 0 ? [] : _appDeployment$settin;
          var siteId = action.siteId;

          if (siteId === -1) {
            siteIds = siteIds.includes(siteId) ? [] : [siteId];
          } else {
            siteIds = siteIds.includes(siteId) ? siteIds.filter(function (id) {
              return id != siteId;
            }) : siteIds.concat(siteId);
          }

          var newAppDeployment = _objectSpread({}, appDeployment, {
            settings: _objectSpread({}, appDeployment.settings, {
              siteIds: siteIds
            })
          });

          return uppdateAppDeployment(state, PRODUCT_MENU, newAppDeployment);
        }

      case UPDATE_APP:
        {
          return _objectSpread({}, state, {
            app: _objectSpread({}, state.app, {}, action.app)
          });
        }

      case UPDATE_DATA_LAYOUT_ID:
        {
          return _objectSpread({}, state, {
            app: _objectSpread({}, state.app, {
              dataLayoutId: action.id
            })
          });
        }

      case UPDATE_DATA_LIST_VIEW_ID:
        {
          return _objectSpread({}, state, {
            app: _objectSpread({}, state.app, {
              dataListViewId: action.id
            })
          });
        }

      case UPDATE_NAME:
        {
          return _objectSpread({}, state, {
            app: _objectSpread({}, state.app, {
              name: {
                en_US: action.appName
              }
            })
          });
        }

      case UPDATE_SETTINGS_SCOPE:
        {
          var _appDeployment = state.app.appDeployments.find(function (appDeployment) {
            return appDeployment.type === PRODUCT_MENU;
          });

          var _newAppDeployment = _objectSpread({}, _appDeployment, {
            settings: _objectSpread({}, _appDeployment.settings, {
              scope: action.scope
            })
          });

          return uppdateAppDeployment(state, PRODUCT_MENU, _newAppDeployment);
        }

      default:
        {
          return state;
        }
    }
  };

  exports.reducer = reducer;
  var EditAppContext = (0, _react.createContext)();
  var _default = EditAppContext;
  exports["default"] = _default;
  //# sourceMappingURL=EditAppContext.es.js.map
});
//# sourceMappingURL=EditAppContext.es.js.map