Liferay.Loader.define("app-builder-web@1.0.2/js/pages/app/EditAppFooter.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/link', 'frontend-js-react-web$react', 'app-builder-web$react-router-dom', '../../AppContext.es', '../../components/button/Button.es', '../../components/toast/ToastContext.es', '../../utils/client.es', './EditAppContext.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _link = _interopRequireDefault(require("@frontend-taglib-clay$clayui/link"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _reactRouterDom = require("app-builder-web$react-router-dom");

  var _AppContext = require("../../AppContext.es");

  var _Button = _interopRequireDefault(require("../../components/button/Button.es"));

  var _ToastContext = require("../../components/toast/ToastContext.es");

  var _client = require("../../utils/client.es");

  var _EditAppContext = _interopRequireDefault(require("./EditAppContext.es"));

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var _default = (0, _reactRouterDom.withRouter)(function (_ref) {
    var currentStep = _ref.currentStep,
        history = _ref.history,
        dataDefinitionId = _ref.match.params.dataDefinitionId,
        onCurrentStepChange = _ref.onCurrentStepChange;

    var _useContext = (0, _react.useContext)(_EditAppContext["default"]),
        app = _useContext.state.app;

    var _useContext2 = (0, _react.useContext)(_AppContext.AppContext),
        getStandaloneURL = _useContext2.getStandaloneURL;

    var _useContext3 = (0, _react.useContext)(_ToastContext.ToastContext),
        addToast = _useContext3.addToast;

    var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        isDeploying = _useState2[0],
        setDeploying = _useState2[1];

    var appDeployments = app.appDeployments,
        dataLayoutId = app.dataLayoutId,
        dataListViewId = app.dataListViewId,
        appId = app.id,
        appName = app.name.en_US;

    var getStandaloneLink = function getStandaloneLink(appId) {
      var isStandalone = appDeployments.some(function (deployment) {
        return deployment.type === 'standalone';
      });

      if (!isStandalone) {
        return _react["default"].createElement(_react["default"].Fragment, null);
      }

      var url = getStandaloneURL(appId);
      return _react["default"].createElement(_link["default"], {
        href: url,
        target: "_blank"
      }, url, " ", _react["default"].createElement(_icon["default"], {
        symbol: "shortcut"
      }));
    };

    var addSuccessToast = function addSuccessToast(appId) {
      addToast({
        displayType: 'success',
        message: _react["default"].createElement(_react["default"].Fragment, null, Liferay.Language.get('the-app-was-deployed-successfully'), ' ', getStandaloneLink(appId)),
        title: "".concat(Liferay.Language.get('success'), ":")
      });
    };

    var onCancel = function onCancel() {
      history.push("/custom-object/".concat(dataDefinitionId, "/apps"));
    };

    return _react["default"].createElement("div", {
      className: "bg-transparent card-footer"
    }, _react["default"].createElement("div", {
      className: "autofit-row"
    }, _react["default"].createElement("div", {
      className: "col-md-4"
    }, _react["default"].createElement(_Button["default"], {
      displayType: "secondary",
      onClick: onCancel
    }, Liferay.Language.get('cancel'))), _react["default"].createElement("div", {
      className: "col-md-4 offset-md-4 text-right"
    }, currentStep > 0 && _react["default"].createElement(_Button["default"], {
      className: "mr-3",
      displayType: "secondary",
      onClick: function onClick() {
        return onCurrentStepChange(currentStep - 1);
      }
    }, Liferay.Language.get('previous')), currentStep < 2 && _react["default"].createElement(_Button["default"], {
      disabled: currentStep === 0 && !dataLayoutId || currentStep === 1 && !dataListViewId,
      displayType: "primary",
      onClick: function onClick() {
        return onCurrentStepChange(currentStep + 1);
      }
    }, Liferay.Language.get('next')), currentStep === 2 && _react["default"].createElement(_Button["default"], {
      disabled: appDeployments.length === 0 || !appName || isDeploying,
      displayType: "primary",
      onClick: function onDeploy() {
        setDeploying(true);

        if (appId) {
          (0, _client.updateItem)("/o/app-builder/v1.0/apps/".concat(appId), app).then(function () {
            return addSuccessToast(appId);
          }).then(onCancel)["catch"](function () {
            return setDeploying(false);
          });
        } else {
          (0, _client.addItem)("/o/app-builder/v1.0/data-definitions/".concat(dataDefinitionId, "/apps"), app).then(function (app) {
            return addSuccessToast(app.id);
          }).then(onCancel)["catch"](function () {
            return setDeploying(false);
          });
        }
      }
    }, app.id ? Liferay.Language.get('save') : Liferay.Language.get('deploy')))));
  });

  exports["default"] = _default;
  //# sourceMappingURL=EditAppFooter.es.js.map
});
//# sourceMappingURL=EditAppFooter.es.js.map