Liferay.Loader.define("app-builder-web@1.0.2/js/pages/entry/EditEntry.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', 'frontend-js-web/liferay/toast/commands/OpenToast.es', 'frontend-js-react-web$react', '../../AppContext.es', '../../components/button/Button.es', '../../components/control-menu/ControlMenu.es', '../../utils/client.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.EditEntry = void 0;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  var _OpenToast = _interopRequireDefault(require("frontend-js-web/liferay/toast/commands/OpenToast.es"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _AppContext = require("../../AppContext.es");

  var _Button = _interopRequireDefault(require("../../components/button/Button.es"));

  var _ControlMenu = require("../../components/control-menu/ControlMenu.es");

  var _client = require("../../utils/client.es");

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }return target;
    };return _extends.apply(this, arguments);
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
      }
    }return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
    }return target;
  }

  var EditEntry = function EditEntry(_ref) {
    var dataDefinitionId = _ref.dataDefinitionId,
        dataRecordId = _ref.dataRecordId,
        ddmForm = _ref.ddmForm,
        redirect = _ref.redirect;

    var _useContext = (0, _react.useContext)(_AppContext.AppContext),
        basePortletURL = _useContext.basePortletURL;

    var onCancel = (0, _react.useCallback)(function () {
      if (redirect) {
        Liferay.Util.navigate(redirect);
      } else {
        Liferay.Util.navigate(basePortletURL);
      }
    }, [basePortletURL, redirect]);
    var onSave = (0, _react.useCallback)(function () {
      var pages = ddmForm.pages;
      var visitor = new _visitors.PagesVisitor(pages);
      ddmForm.validate().then(function (validForm) {
        if (!validForm) {
          return;
        }

        var dataRecord = {
          dataRecordValues: {}
        };
        visitor.mapFields(function (_ref2) {
          var fieldName = _ref2.fieldName,
              value = _ref2.value;
          dataRecord.dataRecordValues[fieldName] = value;
        });

        var openSuccessToast = function openSuccessToast(isNew) {
          var message = isNew ? Liferay.Language.get('an-entry-was-added') : Liferay.Language.get('an-entry-was-updated');
          (0, _OpenToast["default"])({
            message: message,
            title: Liferay.Language.get('success'),
            type: 'success'
          });
        };

        if (dataRecordId !== '0') {
          (0, _client.updateItem)("/o/data-engine/v2.0/data-records/".concat(dataRecordId), dataRecord).then(function () {
            openSuccessToast(false);
            onCancel();
          });
        } else {
          (0, _client.addItem)("/o/data-engine/v2.0/data-definitions/".concat(dataDefinitionId, "/data-records"), dataRecord).then(function () {
            openSuccessToast(true);
            onCancel();
          });
        }
      });
    }, [dataDefinitionId, dataRecordId, ddmForm, onCancel]);
    (0, _react.useEffect)(function () {
      var formNode = ddmForm.getFormNode();

      var onSubmit = function onSubmit() {
        return onSave();
      };

      formNode.addEventListener('submit', onSubmit);
      return function () {
        return formNode.removeEventListener('submit', onSubmit);
      };
    }, [ddmForm, onSave]);
    return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_ControlMenu.ControlMenuBase, {
      backURL: redirect ? redirect : "".concat(basePortletURL, "/#/"),
      title: dataRecordId !== '0' ? Liferay.Language.get('edit-entry') : Liferay.Language.get('add-entry'),
      url: location.href
    }), _react["default"].createElement(_button["default"].Group, {
      className: "app-builder-form-buttons",
      spaced: true
    }, _react["default"].createElement(_Button["default"], {
      onClick: onSave
    }, Liferay.Language.get('save')), _react["default"].createElement(_Button["default"], {
      displayType: "secondary",
      onClick: onCancel
    }, Liferay.Language.get('cancel'))));
  };

  exports.EditEntry = EditEntry;

  var _default = function _default(_ref3) {
    var editEntryContainerElementId = _ref3.editEntryContainerElementId,
        props = _objectWithoutProperties(_ref3, ["editEntryContainerElementId"]);

    var _useState = (0, _react.useState)(),
        _useState2 = _slicedToArray(_useState, 2),
        ddmForm = _useState2[0],
        setDDMForm = _useState2[1];

    if (!ddmForm) {
      Liferay.componentReady(editEntryContainerElementId).then(setDDMForm);
    }

    return ddmForm ? _react["default"].createElement(EditEntry, _extends({
      ddmForm: ddmForm
    }, props)) : null;
  };

  exports["default"] = _default;
  //# sourceMappingURL=EditEntry.es.js.map
});
//# sourceMappingURL=EditEntry.es.js.map