Liferay.Loader.define("app-builder-web@1.0.2/js/pages/entry/FieldPreview.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/tooltip', 'frontend-js-react-web$react', '../../utils/dataDefinition.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.FieldValuePreview = void 0;

  var _button = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/button"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _tooltip = require("@frontend-taglib-clay$clayui/tooltip");

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  var _dataDefinition = require("../../utils/dataDefinition.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    } else {
      var newObj = {};if (obj != null) {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};if (desc.get || desc.set) {
              Object.defineProperty(newObj, key, desc);
            } else {
              newObj[key] = obj[key];
            }
          }
        }
      }newObj["default"] = obj;return newObj;
    }
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  var createFileEntryPreviewURL = function createFileEntryPreviewURL(groupId, fileEntryId) {
    var portletURL = Liferay.PortletURL.createURL(themeDisplay.getLayoutRelativeControlPanelURL());
    portletURL.setParameter('doAsGroupId', groupId);
    portletURL.setParameter('fileEntryId', fileEntryId);
    portletURL.setParameter('mvcRenderCommandName', '/document_library/view_file_entry');
    portletURL.setParameter('p_p_auth', Liferay.authToken);
    portletURL.setParameter('refererGroupId', themeDisplay.getScopeGroupId());
    portletURL.setPortletId(Liferay.PortletKeys.DOCUMENT_LIBRARY);
    portletURL.setPortletMode('view');
    portletURL.setWindowState('pop_up');
    return portletURL.toString();
  };

  var getDocumentIcon = function getDocumentIcon(fileName) {
    var extension = fileName.split('.').pop();

    if (extension === 'pdf') {
      return 'document-pdf';
    }

    if (extension === 'doc' || extension === 'txt') {
      return 'document-text';
    }

    return 'document-default';
  };

  var DocumentRenderer = function DocumentRenderer(_ref) {
    var displayType = _ref.displayType,
        _ref$value = _ref.value,
        value = _ref$value === void 0 ? {} : _ref$value;
    var fileEntry = {};

    if (typeof value === 'string' && value.startsWith('{')) {
      fileEntry = JSON.parse(value);
    }

    var _fileEntry = fileEntry,
        fileEntryId = _fileEntry.fileEntryId,
        folderId = _fileEntry.folderId,
        groupId = _fileEntry.groupId,
        _fileEntry$title = _fileEntry.title,
        title = _fileEntry$title === void 0 ? '' : _fileEntry$title;

    var _useState = (0, _react.useState)(''),
        _useState2 = _slicedToArray(_useState, 2),
        previewURL = _useState2[0],
        setPreviewURL = _useState2[1];

    (0, _react.useEffect)(function () {
      AUI().use('liferay-portlet-url', function () {
        setPreviewURL(createFileEntryPreviewURL(groupId, fileEntryId));
      });
    });

    return _react["default"].createElement(_react["default"].Fragment, null, displayType === 'list' ? _react["default"].createElement(StringRenderer, {
      value: title
    }) : fileEntryId ? _react["default"].createElement(_tooltip.ClayTooltipProvider, null, _react["default"].createElement(_button["default"].Group, {
      className: "data-record-document-field"
    }, _react["default"].createElement(_button["default"], {
      "data-tooltip-align": "bottom",
      "data-tooltip-delay": "200",
      displayType: "secondary",
      onClick: function onClickPreview() {
        Liferay.Util.openWindow({
          dialog: {
            destroyOnHide: true,
            modal: true
          },
          title: Liferay.Language.get('file-preview'),
          uri: previewURL
        });
      },
      title: Liferay.Language.get('file-preview')
    }, _react["default"].createElement(_icon["default"], {
      className: "mr-2",
      symbol: getDocumentIcon(title)
    }), title), _react["default"].createElement(_button.ClayButtonWithIcon, {
      "data-tooltip-align": "bottom",
      "data-tooltip-delay": "200",
      displayType: "secondary",
      onClick: function onClickDownload() {
        location.href = "".concat(themeDisplay.getPathContext(), "/documents/").concat(groupId, "/").concat(folderId || '0', "/").concat(encodeURIComponent(title), "?download=true");
      },
      symbol: "download",
      title: Liferay.Language.get('download')
    }))) : _react["default"].createElement(StringRenderer, {
      value: ' - '
    }));
  };

  var OptionsRenderer = function OptionsRenderer(_ref2) {
    var displayType = _ref2.displayType,
        options = _ref2.options,
        _ref2$values = _ref2.values,
        values = _ref2$values === void 0 ? [] : _ref2$values;
    var labels = values.map(function (value) {
      return (0, _dataDefinition.getOptionLabel)(options, value);
    });

    if (displayType === 'list') {
      return _react["default"].createElement(StringRenderer, {
        value: labels.join(', ')
      });
    }

    return _react["default"].createElement("ul", null, labels.map(function (label, index) {
      return _react["default"].createElement("li", {
        key: index
      }, label);
    }));
  };

  var StringRenderer = function StringRenderer(_ref3) {
    var value = _ref3.value;
    return _react["default"].createElement("div", null, value || ' - ');
  };

  var getFieldValueRenderer = function getFieldValueRenderer(dataDefinitionField, displayType) {
    var customProperties = dataDefinitionField.customProperties,
        fieldType = dataDefinitionField.fieldType;

    if (fieldType === 'checkbox_multiple') {
      var options = customProperties.options;
      return function (_ref4) {
        var value = _ref4.value;
        return _react["default"].createElement(OptionsRenderer, {
          displayType: displayType,
          options: options,
          values: value
        });
      };
    }

    if (fieldType === 'document_library') {
      return function (_ref5) {
        var value = _ref5.value;
        return _react["default"].createElement(DocumentRenderer, {
          displayType: displayType,
          value: value
        });
      };
    }

    if (fieldType === 'radio') {
      var _options = customProperties.options;
      return function (_ref6) {
        var value = _ref6.value;
        return _react["default"].createElement(StringRenderer, {
          value: (0, _dataDefinition.getOptionLabel)(_options, value)
        });
      };
    }

    if (fieldType === 'select') {
      var multiple = customProperties.multiple,
          _options2 = customProperties.options;

      if (multiple) {
        return function (_ref7) {
          var value = _ref7.value;
          return _react["default"].createElement(OptionsRenderer, {
            displayType: displayType,
            options: _options2,
            values: value
          });
        };
      }

      return function (_ref8) {
        var _ref8$value = _ref8.value,
            value = _ref8$value === void 0 ? [] : _ref8$value;
        return _react["default"].createElement(StringRenderer, {
          value: (0, _dataDefinition.getOptionLabel)(_options2, value[0])
        });
      };
    }

    return function (_ref9) {
      var value = _ref9.value;
      return _react["default"].createElement(StringRenderer, {
        value: value
      });
    };
  };

  var FieldValuePreview = function FieldValuePreview(_ref10) {
    var dataDefinition = _ref10.dataDefinition,
        dataRecordValues = _ref10.dataRecordValues,
        _ref10$displayType = _ref10.displayType,
        displayType = _ref10$displayType === void 0 ? 'form' : _ref10$displayType,
        fieldName = _ref10.fieldName;
    var dataDefinitionField = (0, _dataDefinition.getDataDefinitionField)(dataDefinition, fieldName);
    var Renderer = getFieldValueRenderer(dataDefinitionField, displayType);
    var value = dataRecordValues[fieldName];
    return _react["default"].createElement(Renderer, {
      value: value
    });
  };

  exports.FieldValuePreview = FieldValuePreview;

  var _default = function _default(_ref11) {
    var dataDefinition = _ref11.dataDefinition,
        dataRecordValues = _ref11.dataRecordValues,
        fieldName = _ref11.fieldName;
    var label = (0, _dataDefinition.getFieldLabel)(dataDefinition, fieldName);
    return _react["default"].createElement("div", {
      className: "data-record-field-preview"
    }, _react["default"].createElement("label", null, label), _react["default"].createElement(FieldValuePreview, {
      dataDefinition: dataDefinition,
      dataRecordValues: dataRecordValues,
      fieldName: fieldName
    }));
  };

  exports["default"] = _default;
  //# sourceMappingURL=FieldPreview.es.js.map
});
//# sourceMappingURL=FieldPreview.es.js.map